/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent;

import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.systemtray.TrayIcon;
import net.java.sip.communicator.service.systray.AbstractPopupMessageHandler;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageEvent;

public class PopupMessageHandlerTrayIconImpl
extends AbstractPopupMessageHandler {
    private TrayIcon trayIcon;

    public PopupMessageHandlerTrayIconImpl(TrayIcon icon) {
        this.trayIcon = icon;
        icon.addBalloonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMessageHandlerTrayIconImpl.this.firePopupMessageClicked(new SystrayPopupMessageEvent(e));
            }
        });
    }

    @Override
    public void showPopupMessage(PopupMessage popupMessage) {
        String messageContent = popupMessage.getMessage().replaceAll("</?\\w++[^>]*+>", "");
        String messageTitle = popupMessage.getMessageTitle().replaceAll("</?\\w++[^>]*+>", "");
        if (messageContent.length() > 40) {
            messageContent = messageContent.substring(0, 40).concat("...");
        }
        this.trayIcon.displayMessage(messageTitle, messageContent, TrayIcon.MessageType.NONE);
    }

    @Override
    public String toString() {
        return OsDependentActivator.getResources().getI18NString("impl.systray.POPUP_MESSAGE_HANDLER");
    }

    @Override
    public int getPreferenceIndex() {
        return 1;
    }
}

