/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import net.java.sip.communicator.impl.osdependent.systemtray.SystemTray;
import net.java.sip.communicator.util.Logger;

public class Desktop {
    private static final Logger logger = Logger.getLogger(SystemTray.class);
    private static Desktop defaultDesktop;
    private final DesktopPeer peer;

    public static Desktop getDefaultDesktop() throws UnsupportedOperationException, HeadlessException, SecurityException {
        if (defaultDesktop != null) {
            return defaultDesktop;
        }
        Class<?> awtDesktopClass = null;
        try {
            awtDesktopClass = Class.forName("java.awt.Desktop");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        AWTDesktopPeer peer = null;
        if (awtDesktopClass != null) {
            try {
                peer = new AWTDesktopPeer(awtDesktopClass);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to initialize the java.awt.SystemTray implementation.", (Throwable)ex);
            }
        }
        if (peer == null) {
            logger.error((Object)"Failed to initialize the desktop.tray implementation.");
            throw new UnsupportedOperationException("Failed to initialize the desktop.tray implementation.");
        }
        defaultDesktop = new Desktop(peer);
        return defaultDesktop;
    }

    private Desktop(DesktopPeer peer) {
        this.peer = peer;
    }

    DesktopPeer getPeer() {
        return this.peer;
    }

    private static class AWTDesktopPeer
    implements DesktopPeer {
        private final Object impl;
        private final Method open;
        private final Method print;
        private final Method edit;
        private final Method browse;

        public AWTDesktopPeer(Class<?> clazz) throws UnsupportedOperationException, HeadlessException, SecurityException {
            Method getDefaultDesktop;
            try {
                getDefaultDesktop = clazz.getMethod("getDesktop", null);
                this.open = clazz.getMethod("open", File.class);
                this.print = clazz.getMethod("print", File.class);
                this.edit = clazz.getMethod("edit", File.class);
                this.browse = clazz.getMethod("browse", URI.class);
            }
            catch (NoSuchMethodException ex) {
                throw new UnsupportedOperationException(ex);
            }
            try {
                this.impl = getDefaultDesktop.invoke(null, (Object[])null);
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }

        @Override
        public void open(File file) throws IOException {
            try {
                this.open.invoke(this.impl, file);
            }
            catch (IllegalAccessException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    throw new UndeclaredThrowableException(ex);
                }
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }

        @Override
        public void print(File file) throws IOException {
            try {
                this.print.invoke(this.impl, file);
            }
            catch (IllegalAccessException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    throw new UndeclaredThrowableException(ex);
                }
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }

        @Override
        public void edit(File file) throws IOException {
            try {
                this.edit.invoke(this.impl, file);
            }
            catch (IllegalAccessException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    throw new UndeclaredThrowableException(ex);
                }
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }

        @Override
        public void browse(URI uri) throws IOException {
            try {
                this.browse.invoke(this.impl, uri);
            }
            catch (IllegalAccessException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    throw new UndeclaredThrowableException(ex);
                }
                if (cause instanceof NullPointerException) {
                    throw (NullPointerException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                if (cause instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SecurityException) {
                    throw (SecurityException)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }
    }

    static interface DesktopPeer {
        public void open(File var1) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

        public void print(File var1) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

        public void edit(File var1) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

        public void browse(URI var1) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;
    }
}

