/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;

public class Msg
implements Command {
    private static final int END_OF_MSG_COMMAND_PREFIX = 5;
    private IrcConnection connection;

    public Msg(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(String source, String line) {
        if (line.length() < 5) {
            throw new IllegalArgumentException("Both target nick and message are missing.");
        }
        String part = line.substring(5);
        int endOfNick = part.indexOf(32);
        if (endOfNick == -1) {
            throw new IllegalArgumentException("Invalid private message format: Expecting both nick and message. Message was not sent.");
        }
        String target = part.substring(0, endOfNick);
        if (target.length() == 0) {
            throw new IllegalArgumentException("Invalid private message format: Zero-length nick is not allowed. Message was not sent.");
        }
        String message = part.substring(endOfNick + 1);
        if (message.length() == 0) {
            throw new IllegalArgumentException("Invalid private message format: Zero-length message is not allowed. Message was not sent.");
        }
        this.connection.getClient().message(target, message);
    }

    public String help() {
        return "Usage: /msg <user> <message>";
    }
}

