/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import com.ircclouds.irc.api.IRCApi;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.plugin.irccommands.command.Me;
import org.easymock.EasyMock;

public class MeTest
extends TestCase {
    public void testGoodInit() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        Me me = new Me(null, connection);
    }

    public void testBadInit() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{provider});
        try {
            Me me = new Me(provider, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoMessage() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Me me = new Me(provider, connection);
        try {
            me.execute("#test", "/me");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testZeroLengthMessage() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Me me = new Me(provider, connection);
        try {
            me.execute("#test", "/me ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSendMessage() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        IRCApi client = (IRCApi)EasyMock.createMock(IRCApi.class);
        EasyMock.expect((Object)connection.getClient()).andReturn((Object)client);
        client.act((String)EasyMock.eq((Object)"#test"), (String)EasyMock.eq((Object)"says hello world!"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{provider, connection, client});
        Me me = new Me(provider, connection);
        me.execute("#test", "/me says hello world!");
    }
}

