/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.CommandFactory;
import net.java.sip.communicator.plugin.irccommands.command.Join;
import net.java.sip.communicator.plugin.irccommands.command.Me;
import net.java.sip.communicator.plugin.irccommands.command.Mode;
import net.java.sip.communicator.plugin.irccommands.command.Msg;
import net.java.sip.communicator.plugin.irccommands.command.Nick;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class IrcCommandsActivator
implements BundleActivator {
    private static final Map<String, Class<? extends Command>> COMMANDS;

    public void stop(BundleContext context) {
        HashSet<Class<? extends Command>> implementations = new HashSet<Class<? extends Command>>(COMMANDS.values());
        for (Class clazz : implementations) {
            CommandFactory.unregisterCommand((Class)clazz, null);
        }
    }

    public void start(BundleContext context) {
        for (Map.Entry<String, Class<? extends Command>> entry : COMMANDS.entrySet()) {
            CommandFactory.registerCommand((String)entry.getKey(), entry.getValue());
        }
    }

    static {
        HashMap<String, Class<Join>> commands = new HashMap<String, Class<Join>>();
        commands.put("me", Me.class);
        commands.put("msg", Msg.class);
        commands.put("mode", Mode.class);
        commands.put("nick", Nick.class);
        commands.put("join", Join.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }
}

