/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.propertieseditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.propertieseditor.NewPropertyDialog;
import net.java.sip.communicator.plugin.propertieseditor.PropertiesEditorActivator;
import net.java.sip.communicator.plugin.propertieseditor.SearchField;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class ButtonsPanel
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ConfigurationService confService = PropertiesEditorActivator.getConfigurationService();
    private final JButton deleteButton;
    private final JButton newButton;
    private final JTable propsTable;

    public ButtonsPanel(JTable propsTable, SearchField searchField) {
        this.propsTable = propsTable;
        ResourceManagementService r = PropertiesEditorActivator.getResourceManagementService();
        this.newButton = new JButton(r.getI18NString("service.gui.NEW"));
        this.deleteButton = new JButton(r.getI18NString("service.gui.DELETE"));
        this.newButton.setOpaque(false);
        this.deleteButton.setOpaque(false);
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 8, 8));
        buttonsPanel.add(this.newButton);
        buttonsPanel.add(this.deleteButton);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsPanel, "North");
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.defaultButtonState();
    }

    public void defaultButtonState() {
        this.enableDeleteButton(false);
    }

    public void enableDeleteButton(boolean enable) {
        this.deleteButton.setEnabled(enable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.newButton)) {
            NewPropertyDialog dialog = new NewPropertyDialog();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.pack();
            dialog.setLocation((screenSize.width - dialog.getWidth()) / 2, (screenSize.height - dialog.getHeight()) / 2);
            dialog.setVisible(true);
        } else if (sourceButton.equals(this.deleteButton)) {
            int viewRow = this.propsTable.getSelectedRow();
            int modelRow = this.propsTable.convertRowIndexToModel(viewRow);
            String selectedProperty = (String)this.propsTable.getModel().getValueAt(modelRow, 0);
            this.confService.removeProperty(selectedProperty);
            ((DefaultTableModel)this.propsTable.getModel()).removeRow(modelRow);
            this.propsTable.clearSelection();
            this.defaultButtonState();
        }
    }
}

