/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.galagonotification;

import net.java.sip.communicator.impl.galagonotification.GalagoNotification;
import net.java.sip.communicator.impl.galagonotification.GalagoPopupMessageHandler;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.service.systray.PopupMessageHandler;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class GalagoNotificationActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(GalagoNotificationActivator.class);
    private static BundleContext bundleContext;
    static long dbusConnection;
    private static ResourceManagementService resources;

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resources;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String[] capabilities;
        long dbusConnection = GalagoNotification.dbus_bus_get_session();
        if (dbusConnection != 0L && (capabilities = GalagoNotification.getCapabilities(dbusConnection)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"org.freedesktop.Notifications.GetCapabilities:");
                for (String capability : capabilities) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\t" + capability));
                }
            }
            boolean bodyIsImplemented = false;
            boolean iconStaticIsImplemented = false;
            for (String capability : capabilities) {
                if ("body".equals(capability)) {
                    bodyIsImplemented = true;
                    if (!iconStaticIsImplemented) continue;
                    break;
                }
                if (!"icon-static".equals(capability)) continue;
                iconStaticIsImplemented = true;
                if (bodyIsImplemented) break;
            }
            if (bodyIsImplemented) {
                GalagoNotificationActivator.bundleContext = bundleContext;
                GalagoNotificationActivator.dbusConnection = dbusConnection;
                bundleContext.registerService(PopupMessageHandler.class.getName(), (Object)new GalagoPopupMessageHandler(iconStaticIsImplemented), null);
            } else {
                GalagoNotification.dbus_connection_unref(dbusConnection);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (dbusConnection != 0L) {
            GalagoNotification.dbus_connection_unref(dbusConnection);
            dbusConnection = 0L;
        }
        if (bundleContext.equals(GalagoNotificationActivator.bundleContext)) {
            GalagoNotificationActivator.bundleContext = null;
        }
    }
}

