/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.util.Logger;

public class ProtocolIconIrcImpl
implements ProtocolIcon {
    private static final Logger LOGGER = Logger.getLogger(ProtocolIconIrcImpl.class);
    private static final Map<String, byte[]> ICONS_TABLE = new Hashtable<String, byte[]>();
    private static final Map<String, String> ICONPATHS_TABLE;

    public Iterator<String> getSupportedSizes() {
        return ICONS_TABLE.keySet().iterator();
    }

    public boolean isSizeSupported(String iconSize) {
        return ICONS_TABLE.containsKey(iconSize);
    }

    public byte[] getIcon(String iconSize) {
        return ICONS_TABLE.get(iconSize);
    }

    public String getIconPath(String iconSize) {
        return ICONPATHS_TABLE.get(iconSize);
    }

    public byte[] getConnectingIcon() {
        return ProtocolIconIrcImpl.getImageInBytes("ircConnectingIcon");
    }

    static byte[] getImageInBytes(String imageID) {
        InputStream in = IrcActivator.getResources().getImageInputStream(imageID);
        byte[] image = null;
        if (in != null) {
            try {
                image = new byte[in.available()];
                in.read(image);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Failed to load image:" + imageID), (Throwable)e);
            }
        }
        return image;
    }

    static {
        ICONS_TABLE.put("IconSize16x16", ProtocolIconIrcImpl.getImageInBytes("service.protocol.irc.IRC_16x16"));
        ICONS_TABLE.put("IconSize32x32", ProtocolIconIrcImpl.getImageInBytes("service.protocol.irc.IRC_32x32"));
        ICONS_TABLE.put("IconSize48x48", ProtocolIconIrcImpl.getImageInBytes("service.protocol.irc.IRC_48x48"));
        ICONS_TABLE.put("IconSize64x64", ProtocolIconIrcImpl.getImageInBytes("service.protocol.irc.IRC_64x64"));
        ICONPATHS_TABLE = new Hashtable<String, String>();
        ICONPATHS_TABLE.put("IconSize16x16", IrcActivator.getResources().getImagePath("service.protocol.irc.IRC_16x16"));
        ICONPATHS_TABLE.put("IconSize32x32", IrcActivator.getResources().getImagePath("service.protocol.irc.IRC_32x32"));
        ICONPATHS_TABLE.put("IconSize48x48", IrcActivator.getResources().getImagePath("service.protocol.irc.IRC_48x48"));
        ICONPATHS_TABLE.put("IconSize64x64", IrcActivator.getResources().getImagePath("service.protocol.irc.IRC_64x64"));
    }
}

