/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.menus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferenceInviteDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.menus.AutoAnswerMenu;
import net.java.sip.communicator.impl.gui.main.menus.FileMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.notification.NotificationHandler;
import net.java.sip.communicator.service.notification.SoundNotificationHandler;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ToolsMenu
extends SIPCommMenu
implements ActionListener,
PluginComponentListener,
ServiceListener,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(ToolsMenu.class);
    private static final String AUTO_ANSWER_MENU_DISABLED_PROP = "net.java.sip.communicator.impl.gui.main.menus.AUTO_ANSWER_MENU_DISABLED";
    private static final String CONFERENCE_CALL_DISABLED_PROP = "net.java.sip.communicator.impl.gui.main.menus.CONFERENCE_CALL_MENU_ITEM_DISABLED";
    private JMenuItem conferenceMenuItem;
    private JMenuItem videoBridgeMenuItem;
    private JMenuItem hideOfflineMenuItem;
    private JMenuItem soundMenuItem;
    JMenuItem configMenuItem;
    private SwingWorker initVideoBridgeMenuWorker;
    private MenuListener videoBridgeMenuListener;
    private boolean isChatMenu;
    private List<Integer> separatorIndices = new LinkedList<Integer>();

    public ToolsMenu() {
        this(false);
    }

    public ToolsMenu(boolean isChatMenu) {
        this.isChatMenu = isChatMenu;
        ResourceManagementService r = GuiActivator.getResources();
        this.setText(r.getI18NString("service.gui.TOOLS"));
        this.setMnemonic(r.getI18nMnemonic("service.gui.TOOLS"));
        this.registerMenuItems();
        this.initPluginComponents();
    }

    private void initPluginComponents() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(CONTAINER_ID=" + net.java.sip.communicator.service.gui.Container.CONTAINER_TOOLS_MENU.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException exc) {
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                final PluginComponentFactory f = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginComponent pluginComponent = f.getPluginComponentInstance((Object)ToolsMenu.this);
                        ToolsMenu.this.insertInSection((JMenuItem)pluginComponent.getComponent(), pluginComponent.getPositionIndex());
                    }
                });
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemName = menuItem.getName();
        if (itemName == null) {
            return;
        }
        if (itemName.equalsIgnoreCase("config")) {
            this.configActionPerformed();
        } else if (itemName.equals("conference")) {
            List<ProtocolProviderService> confProviders = CallManager.getTelephonyConferencingProviders();
            if (confProviders != null && confProviders.size() > 0) {
                ConferenceInviteDialog confInviteDialog = new ConferenceInviteDialog();
                confInviteDialog.setVisible(true);
            } else {
                ResourceManagementService r = GuiActivator.getResources();
                new ErrorDialog(null, r.getI18NString("service.gui.WARNING"), r.getI18NString("service.gui.NO_ONLINE_CONFERENCING_ACCOUNT")).showDialog();
            }
        } else if (itemName.equals("showHideOffline")) {
            boolean isShowOffline = ConfigurationUtils.isShowOffline();
            TreeContactList.presenceFilter.setShowOffline(!isShowOffline);
            if (GuiActivator.getContactList().getDefaultFilter() == TreeContactList.presenceFilter) {
                GuiActivator.getContactList().setDefaultFilter(TreeContactList.presenceFilter);
                GuiActivator.getContactList().applyDefaultFilter();
            }
            String itemTextKey = !isShowOffline ? "service.gui.HIDE_OFFLINE_CONTACTS" : "service.gui.SHOW_OFFLINE_CONTACTS";
            menuItem.setText(GuiActivator.getResources().getI18NString(itemTextKey));
        } else if (itemName.equals("sound")) {
            boolean mute = !GuiActivator.getAudioNotifier().isMute();
            GuiActivator.getAudioNotifier().setMute(mute);
            for (NotificationHandler handler : GuiActivator.getNotificationService().getActionHandlers("SoundAction")) {
                if (!(handler instanceof SoundNotificationHandler)) continue;
                SoundNotificationHandler soundHandler = (SoundNotificationHandler)handler;
                soundHandler.setMute(mute);
            }
            menuItem.setText(GuiActivator.getResources().getI18NString(mute ? "service.gui.SOUND_ON" : "service.gui.SOUND_OFF"));
        }
    }

    void configActionPerformed() {
        GuiActivator.getUIService().getConfigurationContainer().setVisible(true);
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        final PluginComponentFactory c = event.getPluginComponentFactory();
        if (c.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_TOOLS_MENU)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginComponent pluginComponent = c.getPluginComponentInstance((Object)ToolsMenu.this);
                    ToolsMenu.this.insertInSection((JMenuItem)pluginComponent.getComponent(), pluginComponent.getPositionIndex());
                }
            });
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        final PluginComponentFactory c = event.getPluginComponentFactory();
        if (c.getContainer().equals((Object)net.java.sip.communicator.service.gui.Container.CONTAINER_TOOLS_MENU)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolsMenu.this.remove((Component)c.getPluginComponentInstance((Object)ToolsMenu.this).getComponent());
                }
            });
        }
    }

    private void registerMenuItems() {
        String offlineTextKey;
        UIServiceImpl uiService;
        ConfigurationService cfg = GuiActivator.getConfigurationService();
        Boolean showOptionsProp = cfg.getBoolean("net.java.sip.communicator.impl.gui.main.configforms.SHOW_OPTIONS_WINDOW", true);
        if (!(!showOptionsProp.booleanValue() || (uiService = GuiActivator.getUIService()) != null && uiService.useMacOSXScreenMenuBar() && this.registerConfigMenuItemMacOSX())) {
            this.registerConfigMenuItemNonMacOSX();
        }
        ResourceManagementService r = GuiActivator.getResources();
        Boolean showConferenceMenuItemProp = cfg.getBoolean(CONFERENCE_CALL_DISABLED_PROP, false);
        if (!showConferenceMenuItemProp.booleanValue()) {
            this.conferenceMenuItem = new JMenuItem(r.getI18NString("service.gui.CREATE_CONFERENCE_CALL"));
            this.conferenceMenuItem.setMnemonic(r.getI18nMnemonic("service.gui.CREATE_CONFERENCE_CALL"));
            this.conferenceMenuItem.setName("conference");
            this.conferenceMenuItem.addActionListener(this);
            this.add(this.conferenceMenuItem);
        }
        GuiActivator.bundleContext.addServiceListener((ServiceListener)this);
        this.initVideoBridgeMenu();
        if (!cfg.getBoolean(AUTO_ANSWER_MENU_DISABLED_PROP, false)) {
            if (ConfigurationUtils.isAutoAnswerDisableSubmenu()) {
                this.addSeparator();
                AutoAnswerMenu.registerMenuItems(this);
            } else {
                AutoAnswerMenu autoAnswerMenu = new AutoAnswerMenu();
                this.add((JMenuItem)((Object)autoAnswerMenu));
            }
        }
        this.addSeparator();
        String string = offlineTextKey = ConfigurationUtils.isShowOffline() ? "service.gui.HIDE_OFFLINE_CONTACTS" : "service.gui.SHOW_OFFLINE_CONTACTS";
        if (!this.isChatMenu) {
            this.hideOfflineMenuItem = new JMenuItem(r.getI18NString(offlineTextKey));
            this.hideOfflineMenuItem.setMnemonic(r.getI18nMnemonic(offlineTextKey));
            this.hideOfflineMenuItem.setName("showHideOffline");
            this.hideOfflineMenuItem.addActionListener(this);
            this.add(this.hideOfflineMenuItem);
        }
        String soundTextKey = GuiActivator.getAudioNotifier().isMute() ? "service.gui.SOUND_ON" : "service.gui.SOUND_OFF";
        this.soundMenuItem = new JMenuItem(r.getI18NString(soundTextKey));
        this.soundMenuItem.setMnemonic(r.getI18nMnemonic(soundTextKey));
        this.soundMenuItem.setName("sound");
        this.soundMenuItem.addActionListener(this);
        this.add(this.soundMenuItem);
        this.loadSkin();
    }

    public void addSeparator() {
        super.addSeparator();
        this.separatorIndices.add(this.getMenuComponentCount() - 1);
    }

    private JMenuItem insertInSection(JMenuItem item, int section) {
        if (section < 0 || section >= this.separatorIndices.size()) {
            this.add(item);
            return item;
        }
        int separatorIndex = this.separatorIndices.get(section);
        ListIterator<Integer> it = this.separatorIndices.listIterator(section);
        while (it.hasNext()) {
            int i = it.next() + 1;
            it.remove();
            it.add(i);
        }
        this.insert(item, separatorIndex);
        return item;
    }

    private List<ProtocolProviderService> getVideoBridgeProviders() {
        ArrayList<ProtocolProviderService> activeBridgeProviders = new ArrayList<ProtocolProviderService>();
        for (ProtocolProviderService videoBridgeProvider : AccountUtils.getRegisteredProviders(OperationSetVideoBridge.class)) {
            OperationSetVideoBridge videoBridgeOpSet = (OperationSetVideoBridge)videoBridgeProvider.getOperationSet(OperationSetVideoBridge.class);
            if (!videoBridgeOpSet.isActive()) continue;
            activeBridgeProviders.add(videoBridgeProvider);
        }
        return activeBridgeProviders;
    }

    private void initVideoBridgeMenu() {
        if (GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.service.protocol.VIDEO_BRIDGE_DISABLED", false)) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolsMenu.this.initVideoBridgeMenu();
                }
            });
            return;
        }
        if (this.videoBridgeMenuItem == null) {
            this.videoBridgeMenuItem = new VideoBridgeProviderMenuItem(GuiActivator.getResources().getI18NString("service.gui.CREATE_VIDEO_BRIDGE"), null);
            this.videoBridgeMenuItem.setEnabled(false);
            this.insert(this.videoBridgeMenuItem, 1);
        }
        if (this.videoBridgeMenuListener == null) {
            this.videoBridgeMenuListener = new VideoBridgeMenuListener();
            this.addMenuListener(this.videoBridgeMenuListener);
        }
        if (this.initVideoBridgeMenuWorker == null) {
            this.initVideoBridgeMenuWorker = OSUtils.IS_MAC ? new InitVideoBridgeMenuWorkerMacOSX() : new InitVideoBridgeMenuWorker();
        } else {
            this.initVideoBridgeMenuWorker.interrupt();
        }
        this.initVideoBridgeMenuWorker.start();
    }

    public void dispose() {
        GuiActivator.bundleContext.removeServiceListener((ServiceListener)this);
        GuiActivator.getUIService().removePluginComponentListener(this);
        this.removeAll();
    }

    private boolean registerConfigMenuItemMacOSX() {
        return FileMenu.registerMenuItemMacOSX("Preferences", this);
    }

    private void registerConfigMenuItemNonMacOSX() {
        ResourceManagementService r = GuiActivator.getResources();
        this.configMenuItem = new JMenuItem(r.getI18NString("service.gui.SETTINGS"), r.getImage("service.gui.icons.CONFIGURE_ICON"));
        this.add(this.configMenuItem);
        this.configMenuItem.setMnemonic(r.getI18nMnemonic("service.gui.SETTINGS"));
        this.configMenuItem.setName("config");
        this.configMenuItem.addActionListener(this);
    }

    public void loadSkin() {
        ResourceManagementService r = GuiActivator.getResources();
        if (this.conferenceMenuItem != null) {
            this.conferenceMenuItem.setIcon(r.getImage("service.gui.icons.CONFERENCE_CALL"));
        }
        if (this.configMenuItem != null) {
            this.configMenuItem.setIcon(r.getImage("service.gui.icons.CONFIGURE_ICON"));
        }
        if (this.hideOfflineMenuItem != null) {
            this.hideOfflineMenuItem.setIcon(r.getImage("service.gui.icons.SHOW_HIDE_OFFLINE_ICON"));
        }
        this.soundMenuItem.setIcon(r.getImage("service.gui.icons.SOUND_MENU_ICON"));
        if (this.videoBridgeMenuItem != null) {
            this.videoBridgeMenuItem.setIcon(r.getImage("service.gui.icons.VIDEO_BRIDGE"));
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = GuiActivator.bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        switch (event.getType()) {
            case 1: 
            case 4: {
                this.initVideoBridgeMenu();
            }
        }
    }

    private class VideoBridgeMenuListener
    implements MenuListener {
        private VideoBridgeMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent arg0) {
            ToolsMenu.this.initVideoBridgeMenu();
        }

        @Override
        public void menuDeselected(MenuEvent arg0) {
        }

        @Override
        public void menuCanceled(MenuEvent arg0) {
        }
    }

    private class VideoBridgeProviderMenuItem
    extends JMenuItem
    implements ActionListener {
        private ProtocolProviderService preselectedProvider;
        private List<ProtocolProviderService> videoBridgeProviders;

        public VideoBridgeProviderMenuItem(ProtocolProviderService protocolProvider) {
            this(null, protocolProvider);
        }

        public VideoBridgeProviderMenuItem(String name, ProtocolProviderService preselectedProvider) {
            if (name != null && name.length() > 0) {
                this.setText(name);
            } else {
                this.setText(preselectedProvider.getAccountID().getDisplayName());
            }
            this.preselectedProvider = preselectedProvider;
            ResourceManagementService r = GuiActivator.getResources();
            this.setIcon(r.getImage("service.gui.icons.VIDEO_BRIDGE"));
            this.setMnemonic(r.getI18nMnemonic("service.gui.CREATE_VIDEO_BRIDGE"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConferenceInviteDialog inviteDialog = this.preselectedProvider != null ? new ConferenceInviteDialog(this.preselectedProvider, true) : new ConferenceInviteDialog(this.videoBridgeProviders, true);
            inviteDialog.setVisible(true);
        }

        public void setPreselectedProvider(ProtocolProviderService protocolProvider) {
            this.preselectedProvider = protocolProvider;
        }

        public void setVideoBridgeProviders(List<ProtocolProviderService> videoBridgeProviders) {
            this.videoBridgeProviders = videoBridgeProviders;
        }
    }

    private class InitVideoBridgeMenuWorker
    extends SwingWorker {
        private ResourceManagementService r = GuiActivator.getResources();

        private InitVideoBridgeMenuWorker() {
        }

        protected Object construct() {
            return ToolsMenu.this.getVideoBridgeProviders();
        }

        private JMenuItem createNewMenuItem(List<ProtocolProviderService> videoBridgeProviders) {
            int videoBridgeProviderCount = videoBridgeProviders == null ? 0 : videoBridgeProviders.size();
            VideoBridgeProviderMenuItem newMenuItem = null;
            if (videoBridgeProviderCount <= 0) {
                newMenuItem = new VideoBridgeProviderMenuItem(this.r.getI18NString("service.gui.CREATE_VIDEO_BRIDGE"), null);
                newMenuItem.setEnabled(false);
            } else if (videoBridgeProviderCount == 1) {
                newMenuItem = new VideoBridgeProviderMenuItem(this.r.getI18NString("service.gui.CREATE_VIDEO_BRIDGE"), videoBridgeProviders.get(0));
                newMenuItem.setName("videoBridge");
                newMenuItem.addActionListener(ToolsMenu.this);
            } else if (videoBridgeProviderCount > 1) {
                newMenuItem = new SIPCommMenu(this.r.getI18NString("service.gui.CREATE_VIDEO_BRIDGE_MENU"));
                for (ProtocolProviderService videoBridgeProvider : videoBridgeProviders) {
                    VideoBridgeProviderMenuItem videoBridgeItem = new VideoBridgeProviderMenuItem(videoBridgeProvider);
                    ((JMenu)((Object)newMenuItem)).add(videoBridgeItem);
                    videoBridgeItem.setIcon(ImageLoader.getAccountStatusImage(videoBridgeProvider));
                }
            }
            return newMenuItem;
        }

        protected void finished() {
            if (ToolsMenu.this.videoBridgeMenuItem != null) {
                ToolsMenu.this.remove(ToolsMenu.this.videoBridgeMenuItem);
            }
            ToolsMenu.this.videoBridgeMenuItem = this.createNewMenuItem((List)this.get());
            ToolsMenu.this.videoBridgeMenuItem.setIcon(this.r.getImage("service.gui.icons.VIDEO_BRIDGE"));
            ToolsMenu.this.videoBridgeMenuItem.setMnemonic(this.r.getI18nMnemonic("service.gui.CREATE_VIDEO_BRIDGE"));
            ToolsMenu.this.insert(ToolsMenu.this.videoBridgeMenuItem, 1);
            if (ToolsMenu.this.isPopupMenuVisible()) {
                Container c = ToolsMenu.this.videoBridgeMenuItem.getParent();
                if (c instanceof JComponent) {
                    ((JComponent)c).revalidate();
                }
                c.repaint();
            }
        }
    }

    private class InitVideoBridgeMenuWorkerMacOSX
    extends SwingWorker {
        private InitVideoBridgeMenuWorkerMacOSX() {
        }

        protected Object construct() {
            Boolean enableMenu = true;
            List videoBridgeProviders = ToolsMenu.this.getVideoBridgeProviders();
            int videoBridgeProviderCount = videoBridgeProviders == null ? 0 : videoBridgeProviders.size();
            VideoBridgeProviderMenuItem menuItem = (VideoBridgeProviderMenuItem)ToolsMenu.this.videoBridgeMenuItem;
            if (videoBridgeProviderCount <= 0) {
                enableMenu = false;
            } else if (videoBridgeProviderCount == 1) {
                menuItem.setPreselectedProvider((ProtocolProviderService)videoBridgeProviders.get(0));
                enableMenu = true;
            } else if (videoBridgeProviderCount > 1) {
                menuItem.setPreselectedProvider(null);
                menuItem.setVideoBridgeProviders(videoBridgeProviders);
                enableMenu = true;
            }
            return enableMenu;
        }

        protected void finished() {
            Boolean enabled = (Boolean)this.get();
            if (enabled != null) {
                ToolsMenu.this.videoBridgeMenuItem.setEnabled(enabled);
            }
        }
    }
}

