/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.notifsource;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ChooseUIContactDetailPopupMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContact;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationGroup;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.customcontactactions.ContactAction;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactDetailAction;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.NotificationMessage;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMessageWaiting;
import net.java.sip.communicator.service.protocol.event.MessageWaitingEvent;
import net.java.sip.communicator.service.protocol.event.MessageWaitingListener;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class NotificationContactSource
implements MessageWaitingListener {
    private final Hashtable<String, NotificationGroup> groups = new Hashtable();
    private static Map<ContactAction<NotificationMessage>, SIPCommButton> customActionButtons;
    private static NotificationContact customActionContact;
    private static final Logger logger;

    public void messageWaitingNotify(MessageWaitingEvent evt) {
        OperationSetMessageWaiting.MessageType type = evt.getMessageType();
        NotificationGroup group = this.groups.get(type.toString());
        if (group == null) {
            String displayName = type.equals((Object)OperationSetMessageWaiting.MessageType.VOICE) ? GuiActivator.getResources().getI18NString("service.gui.VOICEMAIL_TITLE") : type.toString();
            group = new NotificationGroup(displayName);
            this.groups.put(type.toString(), group);
        }
        group.messageWaitingNotify(new MessageWaitingEvent(evt.getSourceProvider(), evt.getMessageType(), evt.getAccount(), evt.getUnreadMessages(), evt.getReadMessages(), evt.getUnreadUrgentMessages(), evt.getReadUrgentMessages()));
        Iterator messages = evt.getMessages();
        if (messages != null) {
            while (messages.hasNext()) {
                NotificationMessage message = (NotificationMessage)messages.next();
                String messageGroupName = message.getMessageGroup();
                NotificationGroup messageGroup = this.groups.get(messageGroupName);
                if (messageGroup == null) {
                    messageGroup = new NotificationGroup(messageGroupName);
                    this.groups.put(messageGroupName, messageGroup);
                }
                messageGroup.messageWaitingNotify(evt);
            }
        }
    }

    public Iterator<? extends UIGroup> getNotificationGroups() {
        return this.groups.values().iterator();
    }

    public Iterator<? extends UIContact> getNotifications(UIGroup group) {
        if (!(group instanceof NotificationGroup)) {
            return null;
        }
        NotificationGroup notifGroup = (NotificationGroup)group;
        return notifGroup.getNotifications();
    }

    public static Collection<SIPCommButton> getContactCustomActionButtons(NotificationContact notificationContact) {
        customActionContact = notificationContact;
        if (customActionButtons == null) {
            NotificationContactSource.initCustomActionButtons();
        }
        Iterator<ContactAction<NotificationMessage>> customActionsIter = customActionButtons.keySet().iterator();
        LinkedList<SIPCommButton> availableCustomActionButtons = new LinkedList<SIPCommButton>();
        while (customActionsIter.hasNext()) {
            ContactAction<NotificationMessage> contactAction = customActionsIter.next();
            SIPCommButton actionButton = customActionButtons.get(contactAction);
            if (!NotificationContactSource.isContactActionVisible(contactAction, notificationContact)) continue;
            availableCustomActionButtons.add(actionButton);
        }
        return availableCustomActionButtons;
    }

    private static boolean isContactActionVisible(ContactAction<NotificationMessage> contactAction, NotificationContact notifContact) {
        return contactAction.isVisible((Object)notifContact.getNotificationMessage());
    }

    private static void initCustomActionButtons() {
        customActionButtons = new LinkedHashMap<ContactAction<NotificationMessage>, SIPCommButton>();
        for (CustomContactActionsService<NotificationMessage> ccas : NotificationContactSource.getNotificationActionsServices()) {
            Iterator actionIterator = ccas.getCustomContactActions();
            while (actionIterator != null && actionIterator.hasNext()) {
                final ContactAction ca = (ContactAction)actionIterator.next();
                SIPCommButton actionButton = customActionButtons.get(ca);
                if (actionButton != null) continue;
                actionButton = new SIPCommButton();
                actionButton.setToolTipText(ca.getToolTipText());
                actionButton.setIconImage(new ImageIcon(ca.getIcon()).getImage());
                actionButton.setRolloverIcon(new ImageIcon(ca.getRolloverIcon()).getImage());
                actionButton.setPressedIcon(new ImageIcon(ca.getPressedIcon()).getImage());
                actionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<UIContactDetail> contactDetails = customActionContact.getContactDetails();
                        UIContactDetailCustomAction contactAction = new UIContactDetailCustomAction((ContactAction<NotificationMessage>)ca);
                        if (contactDetails.size() > 1) {
                            ChooseUIContactDetailPopupMenu detailsPopupMenu = new ChooseUIContactDetailPopupMenu((JButton)e.getSource(), customActionContact.getContactDetails(), contactAction);
                            detailsPopupMenu.showPopupMenu();
                        } else if (contactDetails.size() == 1) {
                            JButton button = (JButton)e.getSource();
                            Point location = new Point(button.getX(), button.getY() + button.getHeight());
                            SwingUtilities.convertPointToScreen(location, GuiActivator.getContactList());
                            location.y += GuiActivator.getContactList().getPathBounds((TreePath)GuiActivator.getContactList().getSelectionPath()).y;
                            contactAction.actionPerformed(contactDetails.get(0), location.x, location.y);
                        }
                    }
                });
                customActionButtons.put((ContactAction<NotificationMessage>)ca, actionButton);
            }
        }
    }

    private static List<CustomContactActionsService<NotificationMessage>> getNotificationActionsServices() {
        ArrayList<CustomContactActionsService<NotificationMessage>> contactActionsServices = new ArrayList<CustomContactActionsService<NotificationMessage>>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(CustomContactActionsService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("NotificationContactSource : " + (Object)((Object)e)));
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                CustomContactActionsService customActionService = (CustomContactActionsService)GuiActivator.bundleContext.getService(serRef);
                if (!customActionService.getContactSourceClass().equals(NotificationMessage.class)) continue;
                contactActionsServices.add((CustomContactActionsService<NotificationMessage>)customActionService);
            }
        }
        return contactActionsServices;
    }

    static {
        logger = Logger.getLogger(NotificationContactSource.class);
    }

    private static class UIContactDetailCustomAction
    implements UIContactDetailAction {
        private final ContactAction<NotificationMessage> contactAction;

        public UIContactDetailCustomAction(ContactAction<NotificationMessage> contactAction) {
            this.contactAction = contactAction;
        }

        public void actionPerformed(final UIContactDetail contactDetail, final int x, final int y) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        UIContactDetailCustomAction.this.contactAction.actionPerformed((Object)((NotificationMessage)contactDetail.getDescriptor()), x, y);
                    }
                    catch (OperationFailedException e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage()).setVisible(true);
                            }
                        });
                    }
                }
            }.start();
        }
    }
}

