/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameContactPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;

public class RenameContactDialog
extends SIPCommDialog
implements ActionListener {
    private RenameContactPanel renameContactPanel;
    private JButton renameButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.RENAME"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private JButton clearButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.RENAME_CLEAR_USER_DEFINED"));
    private TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private MetaContactListService clist;
    private MetaContact metaContact;

    public RenameContactDialog(MainFrame mainFrame, MetaContact metaContact) {
        super((Frame)((Object)mainFrame));
        this.setSize(new Dimension(520, 270));
        this.clist = GuiActivator.getContactListService();
        this.metaContact = metaContact;
        this.renameContactPanel = new RenameContactPanel(metaContact.getDisplayName());
        this.init();
    }

    private void init() {
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.RENAME_CONTACT"));
        this.getRootPane().setDefaultButton(this.renameButton);
        this.renameButton.setName("rename");
        this.cancelButton.setName("cancel");
        this.clearButton.setName("clear");
        this.renameButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.RENAME"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.renameButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.buttonsPanel.add((Component)this.renameButton);
        this.buttonsPanel.add((Component)this.cancelButton);
        TransparentPanel allButtonsPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel firstButonPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        firstButonPanel.add((Component)this.clearButton);
        if (this.metaContact.getContactCount() == 1) {
            allButtonsPanel.add((Component)firstButonPanel, (Object)"West");
        }
        allButtonsPanel.add((Component)this.buttonsPanel, (Object)"Center");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.mainPanel.add((Component)((Object)this.renameContactPanel), (Object)"North");
        this.mainPanel.add((Component)allButtonsPanel, (Object)"South");
        this.getContentPane().add((Component)this.mainPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("rename")) {
            if (this.metaContact != null) {
                new Thread(){

                    @Override
                    public void run() {
                        RenameContactDialog.this.clist.renameMetaContact(RenameContactDialog.this.metaContact, RenameContactDialog.this.renameContactPanel.getNewName());
                    }
                }.start();
            }
        } else if (name.equals("clear")) {
            this.clist.clearUserDefinedDisplayName(this.metaContact);
        }
        this.dispose();
    }

    public void requestFocusInFiled() {
        this.renameContactPanel.requestFocusInField();
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }
}

