/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.DefaultContactList;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.skin.Skinnable;

public class ContactListCellRenderer
extends JPanel
implements ListCellRenderer,
Icon,
Skinnable {
    private static final long serialVersionUID = 0L;
    private static final int AVATAR_HEIGHT = 30;
    private static final int AVATAR_WIDTH = 30;
    private static final String AVATAR_DATA_KEY = ContactListCellRenderer.class.getName() + ".avatar";
    private ImageIcon openedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.OPENED_GROUP_ICON));
    private ImageIcon closedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSED_GROUP_ICON));
    private Color groupForegroundColor;
    protected Color contactForegroundColor;
    protected final JLabel nameLabel = new JLabel();
    protected final JLabel statusMessageLabel = new JLabel();
    protected final JLabel rightLabel = new JLabel();
    private final Image msgReceivedImage = ImageLoader.getImage(ImageLoader.MESSAGE_RECEIVED_ICON);
    private final JLabel statusLabel = new JLabel();
    protected final ImageIcon statusIcon = new ImageIcon();
    private final TransparentPanel centerPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    protected boolean isSelected = false;
    protected int index = 0;
    protected boolean isLeaf = true;

    public ContactListCellRenderer() {
        super(new BorderLayout());
        int contactForegroundProperty;
        int groupForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_FOREGROUND");
        if (groupForegroundProperty > -1) {
            this.groupForegroundColor = new Color(groupForegroundProperty);
        }
        if ((contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_CONTACT_FOREGROUND")) > -1) {
            this.contactForegroundColor = new Color(contactForegroundProperty);
        }
        this.setOpaque(false);
        this.nameLabel.setOpaque(false);
        this.nameLabel.setPreferredSize(new Dimension(10, 20));
        this.statusMessageLabel.setFont(this.getFont().deriveFont(9.0f));
        this.statusMessageLabel.setForeground(Color.GRAY);
        this.rightLabel.setFont(this.rightLabel.getFont().deriveFont(9.0f));
        this.rightLabel.setHorizontalAlignment(4);
        this.centerPanel.add((Component)this.nameLabel);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.rightLabel, "East");
        this.setToolTipText("");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.index = index;
        this.rightLabel.setIcon(null);
        DefaultContactList contactList = (DefaultContactList)list;
        if (value instanceof MetaContact) {
            this.setPreferredSize(new Dimension(20, 30));
            MetaContact metaContact = (MetaContact)value;
            String displayName = metaContact.getDisplayName();
            if (displayName == null || displayName.length() < 1) {
                displayName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN");
            }
            this.nameLabel.setText(displayName);
            if (contactList.isMetaContactActive(metaContact)) {
                this.statusIcon.setImage(this.msgReceivedImage);
            } else {
                this.statusIcon.setImage(Constants.getStatusIcon(contactList.getMetaContactStatus(metaContact)));
            }
            this.statusLabel.setIcon(this.statusIcon);
            this.nameLabel.setFont(this.getFont().deriveFont(0));
            if (this.contactForegroundColor != null) {
                this.nameLabel.setForeground(this.contactForegroundColor);
            }
            String statusMessage = this.getStatusMessage(metaContact);
            if (this.getStatusMessage(metaContact) != null) {
                this.statusMessageLabel.setText(statusMessage);
                this.centerPanel.add((Component)this.statusMessageLabel);
            } else {
                this.centerPanel.remove((Component)this.statusMessageLabel);
            }
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            ImageIcon avatar = this.getAvatar(metaContact);
            if (avatar != null) {
                this.rightLabel.setIcon(avatar);
            }
            this.rightLabel.setText("");
            int listWidth = list.getWidth();
            this.setBounds(0, 0, listWidth - 2, 30);
            this.nameLabel.setBounds(0, 0, listWidth - 28, 17);
            this.rightLabel.setBounds(listWidth - 28, 0, 25, 30);
            this.isLeaf = true;
        } else if (value instanceof MetaContactGroup) {
            this.setPreferredSize(new Dimension(20, 20));
            MetaContactGroup groupItem = (MetaContactGroup)value;
            this.nameLabel.setText(groupItem.getGroupName());
            this.nameLabel.setFont(this.getFont().deriveFont(1));
            if (this.groupForegroundColor != null) {
                this.nameLabel.setForeground(this.groupForegroundColor);
            }
            this.centerPanel.remove((Component)this.statusMessageLabel);
            this.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
            this.setBounds(0, 0, list.getWidth() - 2, 20);
            this.statusLabel.setIcon(contactList.isGroupClosed(groupItem) ? this.closedGroupIcon : this.openedGroupIcon);
            this.rightLabel.setIcon(null);
            this.rightLabel.setText(groupItem.countOnlineChildContacts() + "/" + groupItem.countChildContacts());
            this.isLeaf = false;
        } else if (value instanceof String) {
            this.setPreferredSize(new Dimension(20, 30));
            this.nameLabel.setText((String)value);
            this.nameLabel.setFont(this.getFont().deriveFont(0));
        } else {
            this.setPreferredSize(new Dimension(20, 30));
            this.nameLabel.setText(value.toString());
            this.nameLabel.setFont(this.getFont().deriveFont(0));
        }
        this.isSelected = isSelected;
        return this;
    }

    private ImageIcon getAvatar(MetaContact metaContact) {
        byte[] avatarBytes = metaContact.getAvatar(true);
        ImageIcon avatar = null;
        Object[] avatarCache = (Object[])metaContact.getData((Object)AVATAR_DATA_KEY);
        if (avatarCache != null && avatarCache[0] == avatarBytes) {
            avatar = (ImageIcon)avatarCache[1];
        }
        if (avatar == null && avatarBytes != null && avatarBytes.length > 0) {
            avatar = ImageUtils.getScaledRoundedIcon((byte[])avatarBytes, (int)30, (int)30);
        }
        if (avatarCache == null) {
            if (avatar != null) {
                metaContact.setData((Object)AVATAR_DATA_KEY, (Object)new Object[]{avatarBytes, avatar});
            }
        } else {
            avatarCache[0] = avatarBytes;
            avatarCache[1] = avatar;
        }
        return avatar;
    }

    private String getStatusMessage(MetaContact metaContact) {
        Iterator protoContacts = metaContact.getContacts();
        while (protoContacts.hasNext()) {
            Contact protoContact = (Contact)protoContacts.next();
            String statusMessage = protoContact.getStatusMessage();
            if (statusMessage == null || statusMessage.length() <= 0) continue;
            return statusMessage;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            this.internalPaintComponent(g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics g) {
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        if (!this.isLeaf) {
            int width = this.getWidth();
            GradientPaint p = new GradientPaint(0.0f, 0.0f, Constants.CONTACT_LIST_GROUP_BG_COLOR, width - 5, 0.0f, Constants.CONTACT_LIST_GROUP_BG_GRADIENT_COLOR);
            g2.setPaint(p);
            g2.fillRoundRect(1, 1, width - 2, this.getHeight() - 1, 10, 10);
        }
        if (this.isSelected) {
            g2.setColor(Constants.SELECTED_COLOR);
            g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 1, 10, 10);
        }
    }

    @Override
    public int getIconHeight() {
        return this.getHeight() + 10;
    }

    @Override
    public int getIconWidth() {
        return this.getWidth() + 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g2);
            g2.setColor(Color.WHITE);
            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2.fillRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.setColor(Color.DARK_GRAY);
            g2.drawRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.translate(x + 5, y + 5);
            super.paint(g2);
            g2.translate(x, y);
        }
        finally {
            g.dispose();
        }
    }

    public void loadSkin() {
        int contactForegroundProperty;
        this.openedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.DOWN_ARROW_ICON));
        this.closedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSED_GROUP_ICON));
        int groupForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_FOREGROUND");
        if (groupForegroundProperty > -1) {
            this.groupForegroundColor = new Color(groupForegroundProperty);
        }
        if ((contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_CONTACT_FOREGROUND")) > -1) {
            this.contactForegroundColor = new Color(contactForegroundProperty);
        }
    }
}

