/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.configforms;

import java.awt.Component;
import javax.swing.ImageIcon;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.util.Logger;

public class ConfigFormDescriptor {
    private final Logger logger = Logger.getLogger(ConfigFormDescriptor.class);
    private final ConfigurationForm configForm;
    private ImageIcon configFormIcon;
    private Component configFormPanel;
    private String configFormTitle;

    public ConfigFormDescriptor(ConfigurationForm configForm) {
        this.configForm = configForm;
        byte[] icon = null;
        try {
            icon = configForm.getIcon();
            this.configFormTitle = configForm.getTitle();
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not load configuration form.", (Throwable)e);
        }
        if (icon != null) {
            this.configFormIcon = new ImageIcon(icon);
        }
    }

    public ImageIcon getConfigFormIcon() {
        return this.configFormIcon;
    }

    public Component getConfigFormPanel() {
        if (this.configFormPanel == null) {
            Object form = this.configForm.getForm();
            if (!(form instanceof Component)) {
                throw new ClassCastException("ConfigurationFrame :" + form.getClass() + " is not a class supported by this ui implementation");
            }
            this.configFormPanel = (Component)form;
        }
        return this.configFormPanel;
    }

    public String getConfigFormTitle() {
        return this.configFormTitle;
    }

    public ConfigurationForm getConfigForm() {
        return this.configForm;
    }
}

