/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.createforms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.LabelTableCellRenderer;
import net.java.sip.communicator.impl.gui.customcontrols.RadioButtonCellEditor;
import net.java.sip.communicator.impl.gui.customcontrols.RadioButtonTableCellRenderer;
import net.java.sip.communicator.impl.gui.customcontrols.SIPCommMsgTextArea;
import net.java.sip.communicator.impl.gui.main.chatroomslist.createforms.NewChatRoom;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class SelectAccountPanel
extends TransparentPanel {
    private static final long serialVersionUID = 7709876019954774312L;
    private final JScrollPane tablePane = new JScrollPane(20, 31);
    private final JTable accountsTable;
    private final DefaultTableModel tableModel = new DefaultTableModel();
    private final NewChatRoom newChatRoom;
    private final Iterator<ProtocolProviderService> protocolProvidersList;
    private final JPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private final JPanel rightPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final SIPCommMsgTextArea infoLabel = new SIPCommMsgTextArea(GuiActivator.getResources().getI18NString("service.gui.SELECT_PROVIDERS_FOR_CHAT_ROOM"));
    private final JLabel infoTitleLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_ACCOUNT"), 0);
    private final ButtonGroup radioButtonGroup = new ButtonGroup();

    public SelectAccountPanel(NewChatRoom newChatRoom, Iterator<ProtocolProviderService> protocolProvidersList) {
        super((LayoutManager)new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setPreferredSize(new Dimension(600, 400));
        this.newChatRoom = newChatRoom;
        this.protocolProvidersList = protocolProvidersList;
        this.infoLabel.setEditable(false);
        Font font = this.infoTitleLabel.getFont();
        this.infoTitleLabel.setFont(font.deriveFont(1, font.getSize2D() + 6.0f));
        this.labelsPanel.add(this.infoTitleLabel);
        this.labelsPanel.add(this.infoLabel);
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.rightPanel.add((Component)this.labelsPanel, "North");
        this.rightPanel.add((Component)this.tablePane, "Center");
        this.add(this.rightPanel, "Center");
        this.accountsTable = new JTable(this.tableModel){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                this.repaint();
            }
        };
        this.tableInit();
    }

    private void tableInit() {
        this.accountsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.tableModel.addColumn("");
        this.tableModel.addColumn(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT"));
        this.tableModel.addColumn(GuiActivator.getResources().getI18NString("service.gui.PROTOCOL"));
        while (this.protocolProvidersList.hasNext()) {
            ProtocolProviderService pps = this.protocolProvidersList.next();
            OperationSet opSet = pps.getOperationSet(OperationSetMultiUserChat.class);
            if (opSet == null) continue;
            String pName = pps.getProtocolDisplayName();
            byte[] protocolImage = pps.getProtocolIcon().getIcon("IconSize16x16");
            JLabel protocolLabel = new JLabel();
            protocolLabel.setText(pName);
            protocolLabel.setIcon(new ImageIcon(protocolImage));
            JRadioButton radioButton = new JRadioButton();
            this.tableModel.addRow(new Object[]{radioButton, pps, protocolLabel});
            this.radioButtonGroup.add(radioButton);
        }
        this.accountsTable.setRowHeight(22);
        this.accountsTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.accountsTable.getColumnModel().getColumn(0).setCellRenderer(new RadioButtonTableCellRenderer());
        this.accountsTable.getColumnModel().getColumn(0).setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.accountsTable.getColumnModel().getColumn(2).setCellRenderer(new LabelTableCellRenderer());
        this.accountsTable.getColumnModel().getColumn(1).setCellRenderer(new LabelTableCellRenderer());
        this.tablePane.getViewport().add(this.accountsTable);
        if (this.accountsTable.getModel().getRowCount() == 0) {
            JTextArea noAccountsTextArea = new JTextArea(GuiActivator.getResources().getI18NString("service.gui.NO_GROUP_CHAT_ACCOUNT_AVAILABLE"));
            noAccountsTextArea.setLineWrap(true);
            noAccountsTextArea.setPreferredSize(new Dimension(400, 200));
            noAccountsTextArea.setOpaque(false);
            this.rightPanel.add((Component)noAccountsTextArea, "South");
        }
    }

    public void addCheckBoxCellListener(CellEditorListener l) {
        if (this.accountsTable.getModel().getRowCount() != 0) {
            this.accountsTable.getCellEditor(0, 0).addCellEditorListener(l);
        }
    }

    public boolean isRadioSelected() {
        TableModel model = this.accountsTable.getModel();
        for (int i = 0; i < this.accountsTable.getRowCount(); ++i) {
            JRadioButton radioButton;
            Object value = model.getValueAt(i, 0);
            if (!(value instanceof JRadioButton) || !(radioButton = (JRadioButton)value).isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setSelectedAccount() {
        TableModel model = this.accountsTable.getModel();
        for (int i = 0; i < this.accountsTable.getRowCount(); ++i) {
            JRadioButton radioButton;
            Object value = model.getValueAt(i, 0);
            if (!(value instanceof JRadioButton) || !(radioButton = (JRadioButton)value).isSelected()) continue;
            this.newChatRoom.setProtocolProvider((ProtocolProviderService)model.getValueAt(i, 1));
        }
    }
}

