/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.service.protocol.AdHocChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.util.skin.Skinnable;

public class InvitationReceivedDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private final JTextArea infoTextArea = new JTextArea();
    private final JTextArea invitationReasonTextArea = new JTextArea();
    private final JPanel reasonPanel = new JPanel(new BorderLayout());
    private final JLabel reasonLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.REASON") + ": ");
    private final JTextField reasonField = new JTextField();
    private final JPanel dataPanel = new JPanel(new BorderLayout(10, 10));
    private final JPanel buttonsPanel = new JPanel(new FlowLayout(2));
    private final JButton acceptButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ACCEPT"));
    private final JButton rejectButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.REJECT"));
    private final JButton ignoreButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.IGNORE"));
    private final JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
    private final JPanel northPanel = new JPanel(new BorderLayout(10, 10));
    private final JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.INVITE_DIALOG_ICON)));
    private final String title = GuiActivator.getResources().getI18NString("service.gui.INVITATION_RECEIVED");
    private ChatRoomInvitation invitation = null;
    private AdHocChatRoomInvitation invitationAdHoc = null;
    private final ConferenceChatManager multiUserChatManager;
    private OperationSetMultiUserChat multiUserChatOpSet = null;
    private OperationSetAdHocMultiUserChat multiUserChatAdHocOpSet = null;

    public InvitationReceivedDialog(ConferenceChatManager multiUserChatManager, OperationSetMultiUserChat multiUserChatOpSet, ChatRoomInvitation invitation) {
        super((Frame)((Object)GuiActivator.getUIService().getMainFrame()));
        this.multiUserChatManager = multiUserChatManager;
        this.multiUserChatOpSet = multiUserChatOpSet;
        this.invitation = invitation;
        this.setModal(false);
        this.setTitle(this.title);
        this.mainPanel.setPreferredSize(new Dimension(400, 230));
        this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.INVITATION_RECEIVED_MSG", new String[]{invitation.getInviter(), invitation.getTargetChatRoom().getName()}));
        if (invitation.getReason() != null && invitation.getReason().length() > 0) {
            this.invitationReasonTextArea.setLineWrap(true);
            this.invitationReasonTextArea.setWrapStyleWord(true);
            this.invitationReasonTextArea.setOpaque(false);
            this.invitationReasonTextArea.setEditable(false);
            TitledBorder border = BorderFactory.createTitledBorder(GuiActivator.getResources().getI18NString("service.gui.INVITATION"));
            border.setTitleFont(border.getTitleFont().deriveFont(1));
            this.invitationReasonTextArea.setBorder(border);
            this.invitationReasonTextArea.setText(invitation.getReason());
            this.dataPanel.add((Component)this.invitationReasonTextArea, "Center");
        }
        this.initGUI();
    }

    public InvitationReceivedDialog(ConferenceChatManager multiUserChatManager, OperationSetAdHocMultiUserChat multiUserChatAdHocOpSet, AdHocChatRoomInvitation invitationAdHoc) {
        super((Frame)((Object)GuiActivator.getUIService().getMainFrame()));
        this.multiUserChatManager = multiUserChatManager;
        this.multiUserChatAdHocOpSet = multiUserChatAdHocOpSet;
        this.invitationAdHoc = invitationAdHoc;
        this.setModal(false);
        this.setTitle(this.title);
        this.mainPanel.setPreferredSize(new Dimension(400, 230));
        this.infoTextArea.setText(GuiActivator.getResources().getI18NString("service.gui.INVITATION_RECEIVED_MSG", new String[]{invitationAdHoc.getInviter(), invitationAdHoc.getTargetAdHocChatRoom().getName()}));
        if (invitationAdHoc.getReason() != null && !invitationAdHoc.getReason().equals("")) {
            this.invitationReasonTextArea.setText(invitationAdHoc.getReason());
            this.invitationReasonTextArea.setBorder(BorderFactory.createTitledBorder(GuiActivator.getResources().getI18NString("service.gui.INVITATION")));
            this.dataPanel.add((Component)this.invitationReasonTextArea, "Center");
        }
        this.initGUI();
    }

    public void initGUI() {
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setEditable(false);
        this.northPanel.add((Component)this.iconLabel, "West");
        this.northPanel.add((Component)this.infoTextArea, "Center");
        this.northPanel.setOpaque(false);
        this.reasonPanel.add((Component)this.reasonLabel, "West");
        this.reasonPanel.add((Component)this.reasonField, "Center");
        this.reasonPanel.setOpaque(false);
        this.dataPanel.add((Component)this.reasonPanel, "South");
        this.dataPanel.setOpaque(false);
        this.acceptButton.addActionListener(this);
        this.rejectButton.addActionListener(this);
        this.ignoreButton.addActionListener(this);
        this.buttonsPanel.add(this.acceptButton);
        this.buttonsPanel.add(this.rejectButton);
        this.buttonsPanel.add(this.ignoreButton);
        this.buttonsPanel.setOpaque(false);
        this.getRootPane().setDefaultButton(this.acceptButton);
        this.acceptButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ACCEPT"));
        this.rejectButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REJECT"));
        this.ignoreButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.IGNORE"));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.dataPanel, "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.mainPanel.setOpaque(false);
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button.equals(this.acceptButton)) {
            if (this.invitationAdHoc == null) {
                GuiActivator.getMUCService().acceptInvitation(this.invitation);
            } else {
                try {
                    this.multiUserChatManager.acceptInvitation(this.invitationAdHoc, this.multiUserChatAdHocOpSet);
                }
                catch (OperationFailedException e1) {
                    e1.printStackTrace();
                }
            }
        } else if (button.equals(this.rejectButton)) {
            if (this.multiUserChatAdHocOpSet == null && this.invitationAdHoc == null) {
                GuiActivator.getMUCService().rejectInvitation(this.multiUserChatOpSet, this.invitation, this.reasonField.getText());
            } else {
                this.multiUserChatManager.rejectInvitation(this.multiUserChatAdHocOpSet, this.invitationAdHoc, this.reasonField.getText());
            }
        }
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.dispose();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.INVITE_DIALOG_ICON)));
    }
}

