/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.io.File;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.MessageListener;

public class ConferenceChatTransport
implements ChatTransport {
    private final ChatSession chatSession;
    private final ChatRoom chatRoom;

    public ConferenceChatTransport(ChatSession chatSession, ChatRoom chatRoom) {
        this.chatSession = chatSession;
        this.chatRoom = chatRoom;
    }

    @Override
    public String getName() {
        return this.chatRoom.getName();
    }

    @Override
    public String getDisplayName() {
        return this.chatRoom.getName();
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    public boolean isDisplayResourceOnly() {
        return false;
    }

    @Override
    public PresenceStatus getStatus() {
        return null;
    }

    @Override
    public ProtocolProviderService getProtocolProvider() {
        return this.chatRoom.getParentProvider();
    }

    @Override
    public boolean allowsInstantMessage() {
        return this.chatRoom.isJoined();
    }

    @Override
    public boolean allowsSmsMessage() {
        return false;
    }

    @Override
    public boolean allowsTypingNotifications() {
        OperationSet tnOpSet = this.chatRoom.getParentProvider().getOperationSet(OperationSetTypingNotifications.class);
        return tnOpSet != null;
    }

    @Override
    public void sendInstantMessage(String messageText, String mimeType) throws Exception {
        if (!this.allowsInstantMessage()) {
            return;
        }
        Message message = this.chatRoom.createMessage(messageText);
        this.chatRoom.sendMessage(message);
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        return "text/plain".equals(contentType);
    }

    @Override
    public void sendSmsMessage(String phoneNumber, String message) throws Exception {
    }

    @Override
    public void sendSmsMessage(String message) throws Exception {
    }

    @Override
    public FileTransfer sendMultimediaFile(File file) throws Exception {
        return null;
    }

    @Override
    public boolean askForSMSNumber() {
        return false;
    }

    @Override
    public int sendTypingNotification(int typingState) {
        return 0;
    }

    @Override
    public FileTransfer sendFile(File file) throws Exception {
        return null;
    }

    @Override
    public long getMaximumFileLength() {
        return -1L;
    }

    @Override
    public void inviteChatContact(String contactAddress, String reason) {
        if (this.chatRoom != null) {
            this.chatRoom.invite(contactAddress, reason);
        }
    }

    @Override
    public ChatSession getParentChatSession() {
        return this.chatSession;
    }

    @Override
    public void addSmsMessageListener(MessageListener l) {
        if (!this.allowsSmsMessage()) {
            return;
        }
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.chatRoom.getParentProvider().getOperationSet(OperationSetSmsMessaging.class);
        smsOpSet.addMessageListener(l);
    }

    @Override
    public void addInstantMessageListener(MessageListener l) {
        if (!this.allowsInstantMessage()) {
            return;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.chatRoom.getParentProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        imOpSet.addMessageListener(l);
    }

    @Override
    public void removeSmsMessageListener(MessageListener l) {
        if (!this.allowsSmsMessage()) {
            return;
        }
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)this.chatRoom.getParentProvider().getOperationSet(OperationSetSmsMessaging.class);
        smsOpSet.removeMessageListener(l);
    }

    @Override
    public void removeInstantMessageListener(MessageListener l) {
        if (!this.allowsInstantMessage()) {
            return;
        }
        OperationSetBasicInstantMessaging imOpSet = (OperationSetBasicInstantMessaging)this.chatRoom.getParentProvider().getOperationSet(OperationSetBasicInstantMessaging.class);
        imOpSet.removeMessageListener(l);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getDescriptor() {
        return this.chatRoom;
    }

    @Override
    public void correctInstantMessage(String message, String mimeType, String correctedMessageUID) {
    }

    @Override
    public boolean allowsMessageCorrections() {
        return false;
    }
}

