/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionRenderer;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatContact;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatTransport;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.contactlist.event.MetaContactAvatarUpdateEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactGroupEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactMovedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import net.java.sip.communicator.service.protocol.event.ContactResourceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.ConfigurationUtils;

public class MetaContactChatSession
extends ChatSession
implements MetaContactListListener,
ContactResourceListener {
    private final MetaContact metaContact;
    private final MetaContactListService metaContactListService;
    private ChatTransport currentChatTransport;
    private final ChatSessionRenderer sessionRenderer;

    public MetaContactChatSession(ChatSessionRenderer sessionRenderer, MetaContact metaContact, Contact protocolContact, ContactResource contactResource) {
        this.sessionRenderer = sessionRenderer;
        this.metaContact = metaContact;
        this.persistableAddress = protocolContact.getPersistableAddress();
        MetaContactChatContact chatContact = new MetaContactChatContact(metaContact);
        this.chatParticipants.add(chatContact);
        this.initChatTransports(protocolContact, contactResource);
        this.metaContactListService = GuiActivator.getContactListService();
        if (this.metaContactListService != null) {
            this.metaContactListService.addMetaContactListListener((MetaContactListListener)this);
        }
    }

    @Override
    public String getChatName() {
        String displayName = this.metaContact.getDisplayName();
        if (displayName != null && displayName.length() > 0) {
            return this.metaContact.getDisplayName();
        }
        return GuiActivator.getResources().getI18NString("service.gui.UNKNOWN");
    }

    @Override
    public Collection<Object> getHistory(int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLast(this.chatHistoryFilter, (Object)this.metaContact, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Collection<Object> getHistoryBeforeDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.metaContact, date, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Collection<Object> getHistoryAfterDate(Date date, int count) {
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return null;
        }
        return metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.metaContact, date, ConfigurationUtils.getChatHistorySize());
    }

    @Override
    public Date getHistoryStartDate() {
        Date startHistoryDate = new Date(0L);
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return startHistoryDate;
        }
        Collection firstMessage = metaHistory.findFirstMessagesAfter(this.chatHistoryFilter, (Object)this.metaContact, new Date(0L), 1);
        if (firstMessage.size() > 0) {
            Iterator i = firstMessage.iterator();
            Object o = i.next();
            if (o instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o;
                startHistoryDate = evt.getTimestamp();
            } else if (o instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o;
                startHistoryDate = evt.getTimestamp();
            } else if (o instanceof FileRecord) {
                FileRecord fileRecord = (FileRecord)o;
                startHistoryDate = fileRecord.getDate();
            }
        }
        return startHistoryDate;
    }

    @Override
    public Date getHistoryEndDate() {
        Date endHistoryDate = new Date(0L);
        MetaHistoryService metaHistory = GuiActivator.getMetaHistoryService();
        if (metaHistory == null) {
            return endHistoryDate;
        }
        Collection lastMessage = metaHistory.findLastMessagesBefore(this.chatHistoryFilter, (Object)this.metaContact, new Date(Long.MAX_VALUE), 1);
        if (lastMessage.size() > 0) {
            Iterator i1 = lastMessage.iterator();
            Object o1 = i1.next();
            if (o1 instanceof MessageDeliveredEvent) {
                MessageDeliveredEvent evt = (MessageDeliveredEvent)o1;
                endHistoryDate = evt.getTimestamp();
            } else if (o1 instanceof MessageReceivedEvent) {
                MessageReceivedEvent evt = (MessageReceivedEvent)o1;
                endHistoryDate = evt.getTimestamp();
            } else if (o1 instanceof FileRecord) {
                FileRecord fileRecord = (FileRecord)o1;
                endHistoryDate = fileRecord.getDate();
            }
        }
        return endHistoryDate;
    }

    @Override
    public String getDefaultSmsNumber() {
        String smsNumber = null;
        List detailsList = this.metaContact.getDetails("mobile");
        if (detailsList != null && detailsList.size() > 0) {
            smsNumber = (String)detailsList.iterator().next();
        }
        return smsNumber;
    }

    @Override
    public void setDefaultSmsNumber(String smsPhoneNumber) {
        this.metaContact.addDetail("mobile", smsPhoneNumber);
    }

    private void initChatTransports(Contact protocolContact, ContactResource contactResource) {
        Iterator protocolContacts = this.metaContact.getContacts();
        while (protocolContacts.hasNext()) {
            Contact contact = (Contact)protocolContacts.next();
            this.addChatTransports(contact, contactResource != null ? contactResource.getResourceName() : null, protocolContact != null && contact.equals(protocolContact));
        }
    }

    @Override
    public ChatTransport getCurrentChatTransport() {
        return this.currentChatTransport;
    }

    @Override
    public void setCurrentChatTransport(ChatTransport chatTransport) {
        this.currentChatTransport = chatTransport;
        this.fireCurrentChatTransportChange();
    }

    public void childContactsReordered(MetaContactGroupEvent evt) {
    }

    public void metaContactAdded(MetaContactEvent evt) {
    }

    public void metaContactGroupAdded(MetaContactGroupEvent evt) {
    }

    public void metaContactGroupModified(MetaContactGroupEvent evt) {
    }

    public void metaContactGroupRemoved(MetaContactGroupEvent evt) {
    }

    public void metaContactModified(MetaContactModifiedEvent evt) {
    }

    public void metaContactMoved(MetaContactMovedEvent evt) {
    }

    public void metaContactRemoved(MetaContactEvent evt) {
    }

    public void metaContactAvatarUpdated(MetaContactAvatarUpdateEvent evt) {
    }

    public void metaContactRenamed(MetaContactRenamedEvent evt) {
        String newName = evt.getNewDisplayName();
        if (evt.getSourceMetaContact().equals(this.metaContact)) {
            ChatContact<?> chatContact = this.findChatContactByMetaContact(evt.getSourceMetaContact());
            this.sessionRenderer.setContactName(chatContact, newName);
        }
    }

    public void protoContactAdded(ProtoContactEvent evt) {
        if (evt.getNewParent().equals(this.metaContact)) {
            this.addChatTransports(evt.getProtoContact(), null, false);
        }
    }

    public void protoContactMoved(ProtoContactEvent evt) {
        if (evt.getOldParent().equals(this.metaContact)) {
            this.protoContactRemoved(evt);
        } else if (evt.getNewParent().equals(this.metaContact)) {
            this.protoContactAdded(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protoContactRemoved(ProtoContactEvent evt) {
        if (evt.getOldParent().equals(this.metaContact)) {
            ArrayList transports;
            Contact protoContact = evt.getProtoContact();
            List list = this.chatTransports;
            synchronized (list) {
                transports = new ArrayList(this.chatTransports);
            }
            for (ChatTransport chatTransport : transports) {
                if (!((MetaContactChatTransport)chatTransport).getContact().equals(protoContact)) continue;
                this.removeChatTransport(chatTransport);
            }
        }
    }

    private ChatContact<?> findChatContactByMetaContact(MetaContact metaContact) {
        for (ChatContact chatContact : this.chatParticipants) {
            MetaContact metaChatContact;
            Object chatSourceContact = chatContact.getDescriptor();
            if (chatSourceContact instanceof MetaContact) {
                metaChatContact = (MetaContact)chatSourceContact;
                if (!metaChatContact.equals(metaContact)) continue;
                return chatContact;
            }
            assert (chatSourceContact instanceof ChatRoomMember);
            metaChatContact = (ChatRoomMember)chatSourceContact;
            Contact contact = metaChatContact.getContact();
            MetaContact parentMetaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
            if (parentMetaContact == null || !parentMetaContact.equals(metaContact)) continue;
            return chatContact;
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.metaContactListService != null) {
            this.metaContactListService.removeMetaContactListListener((MetaContactListListener)this);
        }
        for (ChatTransport chatTransport : this.chatTransports) {
            ((Contact)chatTransport.getDescriptor()).removeResourceListener((ContactResourceListener)this);
            chatTransport.dispose();
        }
    }

    @Override
    public ChatSessionRenderer getChatSessionRenderer() {
        return this.sessionRenderer;
    }

    @Override
    public Object getDescriptor() {
        return this.metaContact;
    }

    @Override
    public boolean isDescriptorPersistent() {
        if (this.metaContact == null) {
            return false;
        }
        Contact defaultContact = this.metaContact.getDefaultContact(OperationSetBasicInstantMessaging.class);
        if (defaultContact == null) {
            return false;
        }
        ContactGroup parent = defaultContact.getParentContactGroup();
        boolean isParentPersist = true;
        boolean isParentResolved = true;
        if (parent != null) {
            isParentPersist = parent.isPersistent();
            isParentResolved = parent.isResolved();
        }
        return defaultContact.isPersistent() || defaultContact.isResolved() || isParentPersist || isParentResolved;
    }

    @Override
    public ImageIcon getChatStatusIcon() {
        if (this.metaContact == null) {
            return null;
        }
        Contact c = this.metaContact.getDefaultContact();
        if (c == null) {
            return null;
        }
        PresenceStatus status = c.getPresenceStatus();
        if (status == null) {
            return null;
        }
        return new ImageIcon(Constants.getStatusIcon(status));
    }

    @Override
    public byte[] getChatAvatar() {
        return this.metaContact.getAvatar();
    }

    public void protoContactModified(ProtoContactEvent evt) {
    }

    @Override
    public boolean isContactListSupported() {
        return false;
    }

    private void addChatTransports(Contact contact, String resourceName, boolean isSelectedContact) {
        MetaContactChatTransport chatTransport = null;
        Collection contactResources = contact.getResources();
        if (contact.supportResources() && contactResources != null && contactResources.size() > 0) {
            if (contactResources.size() > 1) {
                chatTransport = new MetaContactChatTransport(this, contact);
                this.addChatTransport(chatTransport);
            }
            for (ContactResource resource : contactResources) {
                MetaContactChatTransport resourceTransport = new MetaContactChatTransport(this, contact, resource, contact.getResources().size() > 1);
                this.addChatTransport(resourceTransport);
                if ((resourceName == null || !resource.getResourceName().equals(resourceName)) && contactResources.size() != 1) continue;
                chatTransport = resourceTransport;
            }
        } else {
            chatTransport = new MetaContactChatTransport(this, contact);
            this.addChatTransport(chatTransport);
        }
        if (isSelectedContact) {
            this.currentChatTransport = chatTransport;
            this.sessionRenderer.setSelectedChatTransport(chatTransport, false);
        }
        if (this.currentChatTransport == null) {
            for (ChatTransport ct : this.chatTransports) {
                if (ct.getStatus() == null || !ct.getStatus().isOnline()) continue;
                this.currentChatTransport = ct;
                break;
            }
            if (this.currentChatTransport == null) {
                this.currentChatTransport = (ChatTransport)this.chatTransports.get(0);
            }
            this.sessionRenderer.setSelectedChatTransport(this.currentChatTransport, false);
        }
        if (contact.supportResources()) {
            contact.addResourceListener((ContactResourceListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatTransport(ChatTransport chatTransport) {
        List list = this.chatTransports;
        synchronized (list) {
            this.chatTransports.add(chatTransport);
        }
        this.sessionRenderer.addChatTransport(chatTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChatTransport(ChatTransport chatTransport) {
        List list = this.chatTransports;
        synchronized (list) {
            this.chatTransports.remove(chatTransport);
        }
        this.sessionRenderer.removeChatTransport(chatTransport);
        chatTransport.dispose();
        if (chatTransport.equals(this.currentChatTransport)) {
            this.currentChatTransport = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChatTransports(Contact contact) {
        ArrayList transports;
        List list = this.chatTransports;
        synchronized (list) {
            transports = new ArrayList(this.chatTransports);
        }
        for (MetaContactChatTransport metaTransport : transports) {
            if (!metaTransport.getContact().equals(contact)) continue;
            this.removeChatTransport(metaTransport);
        }
        contact.removeResourceListener((ContactResourceListener)this);
    }

    private void updateChatTransports(Contact contact) {
        MetaContactChatTransport currentTransport = (MetaContactChatTransport)this.getCurrentChatTransport();
        boolean isSelectedContact = currentTransport.getContact().equals(contact);
        boolean isResourceSelected = isSelectedContact && currentTransport.getResourceName() != null;
        String resourceName = currentTransport.getResourceName();
        this.removeChatTransports(contact);
        if (isResourceSelected) {
            this.addChatTransports(contact, resourceName, true);
        } else {
            this.addChatTransports(contact, null, isSelectedContact);
        }
    }

    public void contactResourceAdded(ContactResourceEvent event) {
        Contact contact = event.getContact();
        if (this.metaContact.containsContact(contact)) {
            this.updateChatTransports(contact);
        }
    }

    public void contactResourceRemoved(ContactResourceEvent event) {
        Contact contact = event.getContact();
        if (this.metaContact.containsContact(contact)) {
            this.updateChatTransports(contact);
        }
    }

    public void contactResourceModified(ContactResourceEvent event) {
        ChatTransport transport;
        Contact contact = event.getContact();
        if (this.metaContact.containsContact(contact) && (transport = this.findChatTransportForResource(event.getContactResource())) != null) {
            this.sessionRenderer.updateChatTransportStatus(transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatTransport findChatTransportForResource(ContactResource resource) {
        ArrayList transports;
        List list = this.chatTransports;
        synchronized (list) {
            transports = new ArrayList(this.chatTransports);
        }
        for (ChatTransport chatTransport : transports) {
            if (!chatTransport.getDescriptor().equals(resource.getContact()) || chatTransport.getResourceName() == null || !chatTransport.getResourceName().equals(resource.getResourceName())) continue;
            return chatTransport;
        }
        return null;
    }
}

