/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.ConferenceCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.UIVideoHandler2;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceParticipantPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferenceMemberPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferencePeerPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ThumbnailConferenceCallPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.AccountInfoUtils;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.swing.VideoContainer;

public class VideoConferenceCallPanel
extends BasicConferenceCallPanel {
    private static final Logger logger = Logger.getLogger(VideoConferenceCallPanel.class);
    private static final boolean SHOW_TOOLBARS = true;
    private final UIVideoHandler2 uiVideoHandler;
    private final Observer uiVideoHandlerObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            VideoConferenceCallPanel.this.updateViewFromModel();
        }
    };
    private final VideoContainer videoContainer;
    private final Set<Component> videos = new HashSet<Component>();
    private final ThumbnailConferenceCallPanel thumbnailContainer;
    private final JPanel thumbnailPanel;

    public VideoConferenceCallPanel(CallPanel callPanel, CallConference callConference, UIVideoHandler2 uiVideoHandler) {
        super(callPanel, callConference);
        this.uiVideoHandler = uiVideoHandler;
        this.thumbnailPanel = new JPanel(new BorderLayout());
        this.thumbnailContainer = new ThumbnailConferenceCallPanel(callPanel, callConference, uiVideoHandler);
        this.videoContainer = this.createVideoContainer();
        uiVideoHandler.addObserver(this.uiVideoHandlerObserver);
        this.initializeComplete();
    }

    private void addConferenceMemberContainers(ConferenceParticipantContainer cpc) {
        List<ConferenceParticipantContainer> cmcs = cpc.conferenceMemberContainers;
        if (cmcs != null && !cmcs.isEmpty()) {
            for (ConferenceParticipantContainer cmc : cmcs) {
                if (cmc.toBeRemoved) continue;
                this.videoContainer.add(cmc.getComponent(), (Object)"CENTER_REMOTE");
            }
        }
    }

    private Component createDefaultPhotoPanel(Call call) {
        byte[] accountImage;
        OperationSetServerStoredAccountInfo accountInfo = (OperationSetServerStoredAccountInfo)call.getProtocolProvider().getOperationSet(OperationSetServerStoredAccountInfo.class);
        ImageIcon photoLabelIcon = null;
        if (accountInfo != null && (accountImage = AccountInfoUtils.getImage((OperationSetServerStoredAccountInfo)accountInfo)) != null && accountImage.length > 0) {
            photoLabelIcon = new ImageIcon(accountImage);
        }
        if (photoLabelIcon == null) {
            photoLabelIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO));
        }
        return this.createDefaultPhotoPanel(photoLabelIcon);
    }

    private Component createDefaultPhotoPanel(CallPeer callPeer) {
        byte[] peerImage = CallManager.getPeerImage(callPeer);
        ImageIcon photoLabelIcon = peerImage == null ? new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO)) : new ImageIcon(peerImage);
        return this.createDefaultPhotoPanel(photoLabelIcon);
    }

    private Component createDefaultPhotoPanel(ConferenceMember conferenceMember) {
        return this.createDefaultPhotoPanel(new ImageIcon(ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO)));
    }

    private Component createDefaultPhotoPanel(ImageIcon photoLabelIcon) {
        JLabel photoLabel = new JLabel();
        photoLabel.setIcon(photoLabelIcon);
        TransparentPanel photoPanel = new TransparentPanel(new GridBagLayout()){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g = g.create();
                try {
                    AntialiasingManager.activateAntialiasing((Graphics)g);
                    g.setColor(Color.GRAY);
                    g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 6, 6);
                }
                finally {
                    g.dispose();
                }
            }
        };
        photoPanel.setPreferredSize(new Dimension(320, 240));
        GridBagConstraints photoPanelConstraints = new GridBagConstraints();
        photoPanelConstraints.anchor = 10;
        photoPanelConstraints.fill = 0;
        photoPanel.add((Component)photoLabel, photoPanelConstraints);
        return photoPanel;
    }

    private VideoContainer createVideoContainer() {
        VideoContainer videoContainer = new VideoContainer(null, true);
        this.thumbnailPanel.setBackground(Color.DARK_GRAY);
        this.thumbnailPanel.add((Component)this.thumbnailContainer, "North");
        this.add((Component)this.thumbnailPanel, "East");
        this.add((Component)videoContainer, "Center");
        return videoContainer;
    }

    public void showThumbnailsList(boolean show) {
        this.thumbnailPanel.setVisible(show);
    }

    @Override
    public void dispose() {
        try {
            this.uiVideoHandler.deleteObserver(this.uiVideoHandlerObserver);
        }
        finally {
            super.dispose();
        }
    }

    private boolean isConferenceMemberCallPeer(ConferenceMember conferenceMember, CallPeer callPeer) {
        return conferenceMember == null ? true : CallManager.addressesAreEqual(conferenceMember.getAddress(), callPeer.getAddress());
    }

    private boolean isConferenceMemberLocalUser(ConferenceMember conferenceMember) {
        String address = conferenceMember.getAddress();
        for (Call call : this.callConference.getCalls()) {
            if (!CallManager.addressesAreEqual(address, call.getProtocolProvider().getAccountID().getAccountAddress())) continue;
            return true;
        }
        return false;
    }

    private void removeConferenceMemberContainers(ConferenceParticipantContainer cpc, boolean all) {
        List<ConferenceParticipantContainer> cmcs = cpc.conferenceMemberContainers;
        if (cmcs != null && !cmcs.isEmpty()) {
            Iterator<ConferenceParticipantContainer> i = cmcs.iterator();
            while (i.hasNext()) {
                ConferenceParticipantContainer cmc = i.next();
                if (!all && !cmc.toBeRemoved) continue;
                i.remove();
                this.videoContainer.remove(cmc.getComponent());
                cmc.dispose();
            }
        }
    }

    private void updateConferenceMemberContainers(ConferenceParticipantContainer cpc, List<Component> videos, OperationSetVideoTelephony videoTelephony) {
        List conferenceMembers;
        boolean addNewConferenceParticipantContainer;
        CallPeer callPeer = (CallPeer)cpc.getParticipant();
        List<ConferenceParticipantContainer> cmcs = cpc.conferenceMemberContainers;
        if (cmcs != null) {
            for (ConferenceParticipantContainer cmc : cmcs) {
                cmc.toBeRemoved = true;
            }
        }
        if (videos != null) {
            Component video = cpc.getVideo();
            for (Component conferenceMemberVideo : videos) {
                if (conferenceMemberVideo == video) continue;
                addNewConferenceParticipantContainer = true;
                ConferenceMember conferenceMember = videoTelephony.getConferenceMember(callPeer, conferenceMemberVideo);
                if (cmcs == null) {
                    cpc.conferenceMemberContainers = cmcs = new LinkedList<ConferenceParticipantContainer>();
                } else {
                    for (ConferenceParticipantContainer cmc : cmcs) {
                        Object cmcParticipant = cmc.getParticipant();
                        if (conferenceMember == null) {
                            if (cmcParticipant != callPeer) continue;
                            Component cmcVideo = cmc.getVideo();
                            if (cmcVideo == null) {
                                cmc.setVideo(conferenceMemberVideo);
                                cmc.toBeRemoved = false;
                                addNewConferenceParticipantContainer = false;
                                break;
                            }
                            if (cmcVideo != conferenceMemberVideo) continue;
                            cmc.toBeRemoved = false;
                            addNewConferenceParticipantContainer = false;
                            break;
                        }
                        if (cmcParticipant != conferenceMember) continue;
                        cmc.setVideo(conferenceMemberVideo);
                        cmc.toBeRemoved = false;
                        addNewConferenceParticipantContainer = false;
                        break;
                    }
                }
                if (!addNewConferenceParticipantContainer) continue;
                ConferenceParticipantContainer cmc = conferenceMember == null ? new ConferenceParticipantContainer(callPeer, conferenceMemberVideo) : new ConferenceParticipantContainer(conferenceMember, conferenceMemberVideo);
                cmcs.add(cmc);
            }
        }
        if (!(conferenceMembers = callPeer.getConferenceMembers()).isEmpty()) {
            if (cmcs == null) {
                cpc.conferenceMemberContainers = cmcs = new LinkedList<ConferenceParticipantContainer>();
            }
            for (ConferenceMember conferenceMember : conferenceMembers) {
                if (this.isConferenceMemberCallPeer(conferenceMember, callPeer) || this.isConferenceMemberLocalUser(conferenceMember)) continue;
                addNewConferenceParticipantContainer = true;
                for (ConferenceParticipantContainer cmc : cmcs) {
                    if (cmc.getParticipant() != conferenceMember) continue;
                    if (cmc.toBeRemoved && !conferenceMember.getVideoStatus().allowsSending()) {
                        cmc.setVideo(null);
                        cmc.toBeRemoved = false;
                    }
                    addNewConferenceParticipantContainer = false;
                    break;
                }
                if (!addNewConferenceParticipantContainer) continue;
                ConferenceParticipantContainer cmc = new ConferenceParticipantContainer(conferenceMember, null);
                cmcs.add(cmc);
            }
        }
        if (cmcs != null && !cmcs.isEmpty()) {
            this.removeConferenceMemberContainers(cpc, false);
            if (UIVideoHandler2.isAncestor(this, cpc.getComponent())) {
                this.addConferenceMemberContainers(cpc);
            }
        }
    }

    @Override
    protected ConferenceCallPeerRenderer updateViewFromModel(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        if (callPeer == null) {
            Component video = null;
            if (this.uiVideoHandler.isLocalVideoVisible()) {
                for (Call aCall : this.callConference.getCalls()) {
                    Iterator callPeerIter = aCall.getCallPeers();
                    OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)aCall.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
                    while (callPeerIter.hasNext()) {
                        callPeer = (CallPeer)callPeerIter.next();
                        if (videoTelephony == null) continue;
                        try {
                            video = videoTelephony.getLocalVisualComponent(callPeer);
                        }
                        catch (OperationFailedException ofe) {
                            logger.error((Object)"Failed to retrieve the local video for display", (Throwable)ofe);
                        }
                        if (video == null) continue;
                    }
                    if (video == null) continue;
                    break;
                }
            }
            if (callPeer == null) {
                callPeerPanel = null;
            } else {
                Call call = callPeer.getCall();
                if (callPeerPanel instanceof ConferenceParticipantContainer) {
                    ConferenceParticipantContainer cpc = (ConferenceParticipantContainer)callPeerPanel;
                    if (cpc.getParticipant() == call) {
                        cpc.setVideo(video);
                    } else {
                        callPeerPanel = null;
                    }
                } else {
                    callPeerPanel = null;
                }
                if (callPeerPanel == null) {
                    callPeerPanel = new ConferenceParticipantContainer(call, video);
                }
            }
        } else {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            List videos = null;
            Component video = null;
            if (videoTelephony != null && (videos = videoTelephony.getVisualComponents(callPeer)) != null && !videos.isEmpty()) {
                for (Component aVideo : videos) {
                    ConferenceMember conferenceMember = videoTelephony.getConferenceMember(callPeer, aVideo);
                    if (!this.isConferenceMemberCallPeer(conferenceMember, callPeer)) continue;
                    video = aVideo;
                    break;
                }
            }
            ConferenceParticipantContainer cpc = null;
            if (callPeerPanel instanceof ConferenceParticipantContainer) {
                cpc = (ConferenceParticipantContainer)callPeerPanel;
                if (cpc.getParticipant() == callPeer) {
                    cpc.setVideo(video);
                } else {
                    cpc = null;
                }
            }
            if (cpc == null) {
                cpc = new ConferenceParticipantContainer(callPeer, video);
            }
            callPeerPanel = cpc;
            this.updateConferenceMemberContainers(cpc, videos, videoTelephony);
        }
        return callPeerPanel;
    }

    @Override
    protected void updateViewFromModelInEventDispatchThread() {
        super.updateViewFromModelInEventDispatchThread();
    }

    @Override
    protected void viewForModelAdded(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        this.videoContainer.add(callPeerPanel.getComponent(), (Object)"CENTER_REMOTE");
        if (callPeer != null && callPeerPanel instanceof ConferenceParticipantContainer) {
            this.addConferenceMemberContainers((ConferenceParticipantContainer)callPeerPanel);
        }
    }

    @Override
    protected void viewForModelRemoved(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        this.videoContainer.remove(callPeerPanel.getComponent());
        if (callPeer != null && callPeerPanel instanceof ConferenceParticipantContainer) {
            this.removeConferenceMemberContainers((ConferenceParticipantContainer)callPeerPanel, true);
        }
    }

    private class ConferenceParticipantContainer
    extends TransparentPanel
    implements ConferenceCallPeerRenderer {
        List<ConferenceParticipantContainer> conferenceMemberContainers;
        boolean toBeRemoved;
        private final BasicConferenceParticipantPanel<?> toolBar;
        private Component video;
        private final VideoContainer videoContainer;
        private CallPeer callPeer;
        private ConferenceMember conferenceMember;
        private boolean isLocalUser;

        public ConferenceParticipantContainer(Call call, Component video) {
            this(videoConferenceCallPanel.createDefaultPhotoPanel(call), video, new ConferencePeerPanel((BasicConferenceCallPanel)videoConferenceCallPanel, call, true), null, null, true);
        }

        public ConferenceParticipantContainer(CallPeer callPeer, Component video) {
            this(videoConferenceCallPanel.createDefaultPhotoPanel(callPeer), video, new ConferencePeerPanel((BasicConferenceCallPanel)videoConferenceCallPanel, callPeer, true), callPeer, null, false);
        }

        private ConferenceParticipantContainer(Component noVideo, Component video, BasicConferenceParticipantPanel<?> toolBar, CallPeer callPeer, ConferenceMember conferenceMember, boolean isLocalUser) {
            super((LayoutManager)new BorderLayout());
            this.callPeer = callPeer;
            this.conferenceMember = conferenceMember;
            this.isLocalUser = isLocalUser;
            this.videoContainer = new VideoContainer(noVideo, false);
            this.add((Component)this.videoContainer, "Center");
            this.toolBar = toolBar;
            if (this.toolBar != null) {
                this.add((Component)((Object)this.toolBar), "South");
            }
            if (video != null) {
                this.setVideo(video);
            } else {
                this.setVisible(false);
            }
        }

        public ConferenceParticipantContainer(ConferenceMember conferenceMember, Component video) {
            this(videoConferenceCallPanel.createDefaultPhotoPanel(conferenceMember), video, new ConferenceMemberPanel((SwingCallRenderer)videoConferenceCallPanel, conferenceMember, true), null, conferenceMember, false);
        }

        public void dispose() {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.dispose();
            }
            CallManager.assertIsEventDispatchingThread();
            if (this.conferenceMemberContainers != null) {
                for (ConferenceParticipantContainer cmc : this.conferenceMemberContainers) {
                    cmc.dispose();
                }
            }
        }

        @Override
        public CallPanel getCallPanel() {
            return this.getCallRenderer().getCallContainer();
        }

        public SwingCallRenderer getCallRenderer() {
            return VideoConferenceCallPanel.this;
        }

        @Override
        public Component getComponent() {
            return this;
        }

        private ConferenceCallPeerRenderer getConferenceCallPeerRendererDelegate() {
            return this.toolBar instanceof ConferenceCallPeerRenderer ? (ConferenceCallPeerRenderer)((Object)this.toolBar) : null;
        }

        public Object getParticipant() {
            return this.toolBar == null ? null : this.toolBar.getParticipant();
        }

        public Component getVideo() {
            return this.video;
        }

        public boolean isLocalVideoVisible() {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            return delegate == null ? false : delegate.isLocalVideoVisible();
        }

        public void printDTMFTone(char dtmfChar) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.printDTMFTone(dtmfChar);
            }
        }

        public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent ev) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.securityNegotiationStarted(ev);
            }
        }

        public void securityOff(CallPeerSecurityOffEvent ev) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.securityOff(ev);
            }
        }

        public void securityOn(CallPeerSecurityOnEvent ev) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.securityOn(ev);
            }
        }

        public void securityPending() {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.securityPending();
            }
        }

        public void securityTimeout(CallPeerSecurityTimeoutEvent ev) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.securityTimeout(ev);
            }
        }

        public void setErrorReason(String reason) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setErrorReason(reason);
            }
        }

        public void setLocalVideoVisible(boolean visible) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setLocalVideoVisible(visible);
            }
        }

        public void setMute(boolean mute) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setMute(mute);
            }
        }

        public void setOnHold(boolean onHold) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setOnHold(onHold);
            }
        }

        public void setPeerImage(byte[] image) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setPeerImage(image);
            }
        }

        public void setPeerName(String name) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setPeerName(name);
            }
        }

        public void setPeerState(CallPeerState oldState, CallPeerState newState, String stateString) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setPeerState(oldState, newState, stateString);
            }
        }

        public void setSecurityPanelVisible(boolean visible) {
            ConferenceCallPeerRenderer delegate = this.getConferenceCallPeerRendererDelegate();
            if (delegate != null) {
                delegate.setSecurityPanelVisible(visible);
            }
        }

        void setVideo(Component video) {
            if (this.video != video) {
                if (this.video != null) {
                    this.videoContainer.remove(this.video);
                }
                this.video = video;
                if (this.video != null) {
                    this.setVisible(true);
                    this.videoContainer.add(this.video, (Object)"CENTER_REMOTE");
                } else {
                    this.setVisible(false);
                }
                if (VideoConferenceCallPanel.this.thumbnailContainer != null) {
                    if (this.conferenceMember != null) {
                        VideoConferenceCallPanel.this.thumbnailContainer.updateThumbnail(this.conferenceMember, video != null);
                    } else if (this.callPeer != null) {
                        VideoConferenceCallPanel.this.thumbnailContainer.updateThumbnail(this.callPeer, video != null);
                    } else if (this.isLocalUser) {
                        VideoConferenceCallPanel.this.thumbnailContainer.updateThumbnail(video != null);
                    }
                }
            }
        }
    }
}

