/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.BorderFactory;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.OrderedTransparentPanel;
import org.jitsi.service.resources.ResourceManagementService;

public class CallToolBar
extends OrderedTransparentPanel {
    private static final int TOOL_BAR_BORDER = 2;
    private static final int TOOL_BAR_X_GAP = 3;
    private final Image buttonDarkSeparatorImage = ImageLoader.getImage(ImageLoader.CALL_TOOLBAR_DARK_SEPARATOR);
    private final Image buttonSeparatorImage = ImageLoader.getImage(ImageLoader.CALL_TOOLBAR_SEPARATOR);
    private boolean fullScreen;
    private final boolean incomingCall;
    private final Color toolbarColor;
    private final Color toolbarFullScreenColor;
    private final Color toolbarInCallBorderColor;
    private final Color toolbarInCallShadowColor;

    public CallToolBar(boolean fullScreen, boolean incomingCall) {
        this.fullScreen = fullScreen;
        this.incomingCall = incomingCall;
        ResourceManagementService res = GuiActivator.getResources();
        this.toolbarColor = new Color(res.getColor("service.gui.CALL_TOOL_BAR"));
        this.toolbarFullScreenColor = new Color(res.getColor("service.gui.CALL_TOOL_BAR_FULL_SCREEN"));
        this.toolbarInCallBorderColor = new Color(res.getColor("service.gui.IN_CALL_TOOL_BAR_BORDER"));
        this.toolbarInCallShadowColor = new Color(res.getColor("service.gui.IN_CALL_TOOL_BAR_BORDER_SHADOW"));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new FlowLayout(1, 3, 0));
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.incomingCall) {
                g.setColor(this.toolbarInCallShadowColor);
                g.drawRoundRect(0, 0, width - 1, height - 2, 10, 10);
                g.setColor(this.toolbarInCallBorderColor);
                g.drawRoundRect(0, 0, width - 1, height - 3, 10, 10);
            } else {
                g.setColor(this.fullScreen ? this.toolbarFullScreenColor : this.toolbarColor);
                g.fillRoundRect(0, 0, width, height, 10, 10);
            }
            if (!this.fullScreen) {
                Image separatorImage;
                int endX = width - 2 - 3;
                Image image = separatorImage = this.incomingCall ? this.buttonDarkSeparatorImage : this.buttonSeparatorImage;
                for (int x = 49; x < endX; x += 47) {
                    g.drawImage(separatorImage, x + 1, (height - separatorImage.getHeight((ImageObserver)((Object)this))) / 2, (ImageObserver)((Object)this));
                }
            }
        }
        finally {
            g.dispose();
        }
    }

    public void setFullScreen(boolean fullScreen) {
        if (this.fullScreen != fullScreen) {
            this.fullScreen = fullScreen;
            if (this.isDisplayable()) {
                this.repaint();
            }
        }
    }
}

