/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets.plaf;

import com.explodingpixels.widgets.WindowUtils;
import com.explodingpixels.widgets.plaf.ScrollBarOrientation;
import com.explodingpixels.widgets.plaf.ScrollBarSkin;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class SkinnableScrollBarUI
extends BasicScrollBarUI {
    private ScrollBarSkin fSkin;
    private ScrollBarOrientation fOrientation;
    private final ScrollBarSkinProvider fScrollBarSkinProvider;

    public SkinnableScrollBarUI(ScrollBarSkinProvider scrollBarSkinProvider) {
        this.fScrollBarSkinProvider = scrollBarSkinProvider;
    }

    public void installUI(JComponent c) {
        JScrollBar scrollBar = (JScrollBar)c;
        this.fOrientation = ScrollBarOrientation.getOrientation(scrollBar.getOrientation());
        this.fSkin = this.fScrollBarSkinProvider.provideSkin(this.fOrientation);
        super.installUI(c);
    }

    protected void installComponents() {
        this.fSkin.installComponents(this.scrollbar);
    }

    protected void installListeners() {
        super.installListeners();
        this.fSkin.installMouseListenersOnButtons(new CustomArrowButtonListener(-1), new CustomArrowButtonListener(1));
        WindowUtils.installJComponentRepainterOnWindowFocusChanged(this.scrollbar);
    }

    public void layoutContainer(Container scrollbarContainer) {
        if (!this.isDragging) {
            if (SkinnableScrollBarUI.isAllContentVisible(this.scrollbar)) {
                this.fSkin.layoutTrackOnly(this.scrollbar, this.fOrientation);
                this.updateThumbBoundsFromScrollBarValue();
            } else {
                this.fSkin.layoutEverything(this.scrollbar, this.fOrientation);
                this.updateThumbBoundsFromScrollBarValue();
            }
        }
    }

    protected Dimension getMinimumThumbSize() {
        return this.fSkin.getMinimumThumbSize();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.fSkin.getPreferredSize();
    }

    protected Rectangle getThumbBounds() {
        return this.fSkin.getScrollThumbBounds();
    }

    private void setThumbBounds(Rectangle thumbBounds) {
        this.setThumbBounds(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        this.fSkin.setScrollThumbBounds(new Rectangle(x, y, width, height));
    }

    protected Rectangle getTrackBounds() {
        return this.fSkin.getTrackBounds();
    }

    protected void paintIncreaseHighlight(Graphics g) {
    }

    protected void paintDecreaseHighlight(Graphics g) {
    }

    private void updateThumbBoundsFromScrollBarValue() {
        float min = this.scrollbar.getMinimum();
        float extent = this.scrollbar.getVisibleAmount();
        float range = (float)this.scrollbar.getMaximum() - min;
        float value = this.scrollbar.getValue();
        int trackSize = this.fOrientation.getLength(this.fSkin.getTrackBounds().getSize());
        int thumbLength = (int)((float)trackSize * (extent / range));
        int minimumThumbLength = this.fOrientation.getLength(this.getMinimumThumbSize());
        thumbLength = Math.max(thumbLength, minimumThumbLength);
        float thumbRange = trackSize - thumbLength;
        int thumbPosition = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        this.fSkin.setScrollThumbBounds(this.fOrientation.createBounds(this.scrollbar, thumbPosition, thumbLength));
    }

    private void updateThumbBoundsAndScrollBarValueFromMouseEvent(MouseEvent event, int offset) {
        int mouseLocation = this.adjustMousePosition(event.getPoint(), offset);
        this.updateThumbBoundsFromMouseLocation(mouseLocation);
        this.updateScrollBarValueFromMouseLocation(mouseLocation);
    }

    private void updateThumbBoundsFromMouseLocation(int mouseLocation) {
        Dimension thumbSize = this.getThumbBounds().getSize();
        Dimension trackSize = this.getTrackBounds().getSize();
        int thumbMaxPossiblePosition = this.fOrientation.getLength(trackSize) - this.fOrientation.getLength(thumbSize);
        int thumbPosition = Math.min(thumbMaxPossiblePosition, Math.max(0, mouseLocation));
        this.setThumbBounds(this.fOrientation.updateBoundsPosition(this.getThumbBounds(), thumbPosition));
    }

    private void updateScrollBarValueFromMouseLocation(int mouseLocation) {
        BoundedRangeModel model = this.scrollbar.getModel();
        Rectangle thumbBounds = this.getThumbBounds();
        Rectangle trackBounds = this.getTrackBounds();
        int minimumPossibleThumbPosition = this.fOrientation.getPosition(trackBounds.getLocation());
        int maximumPossibleThumbPosition = this.getMaximumPossibleThumbPosition(trackBounds, thumbBounds);
        int actualThumbPosition = Math.min(maximumPossibleThumbPosition, Math.max(minimumPossibleThumbPosition, mouseLocation));
        float valueMax = model.getMaximum() - model.getExtent();
        float valueRange = valueMax - (float)model.getMinimum();
        float thumbValue = actualThumbPosition - minimumPossibleThumbPosition;
        float thumbRange = maximumPossibleThumbPosition - minimumPossibleThumbPosition;
        int value = (int)Math.ceil(thumbValue / thumbRange * valueRange);
        this.scrollbar.setValue(value + model.getMinimum());
    }

    private int getMaximumPossibleThumbPosition(Rectangle trackBounds, Rectangle thumbBounds) {
        int trackStartPosition = this.fOrientation.getPosition(trackBounds.getLocation());
        int trackLength = this.fOrientation.getLength(trackBounds.getSize());
        int thumbLength = this.fOrientation.getLength(thumbBounds.getSize());
        return trackStartPosition + trackLength - thumbLength;
    }

    private int adjustMousePosition(Point mousePoint, int offset) {
        return this.fOrientation.getPosition(mousePoint) - offset;
    }

    private boolean isPointBeforeScrollThumb(Point point) {
        int thumbPosition;
        int mousePosition = this.fOrientation.getPosition(point);
        return mousePosition < (thumbPosition = this.fOrientation.getPosition(this.getThumbBounds().getLocation()));
    }

    private boolean isPointAfterScrollThumb(Point point) {
        int thumbPosition;
        int mousePosition = this.fOrientation.getPosition(point);
        return mousePosition > (thumbPosition = this.fOrientation.getPosition(this.getThumbBounds().getLocation()));
    }

    private int getDirectionToMoveThumb(Point mousePoint) {
        return this.isPointBeforeScrollThumb(mousePoint) ? -1 : 1;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new SkinnableTrackListener();
    }

    private static boolean isAllContentVisible(JScrollBar scrollBar) {
        float extent = scrollBar.getVisibleAmount();
        float range = scrollBar.getMaximum() - scrollBar.getMinimum();
        return (double)extent == 0.0 || (double)(extent / range) == 1.0;
    }

    public static interface ScrollBarSkinProvider {
        public ScrollBarSkin provideSkin(ScrollBarOrientation var1);
    }

    protected class CustomArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        private final int iScrollDirection;

        private CustomArrowButtonListener(int scrollDirection) {
            super(SkinnableScrollBarUI.this);
            this.iScrollDirection = scrollDirection;
        }

        public void mousePressed(MouseEvent e) {
            if (SkinnableScrollBarUI.this.scrollbar.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
                SkinnableScrollBarUI.this.scrollByUnit(this.iScrollDirection);
                SkinnableScrollBarUI.this.scrollTimer.stop();
                SkinnableScrollBarUI.this.scrollListener.setDirection(this.iScrollDirection);
                SkinnableScrollBarUI.this.scrollListener.setScrollByBlock(false);
                SkinnableScrollBarUI.this.scrollTimer.start();
            }
        }

        public void mouseReleased(MouseEvent e) {
            SkinnableScrollBarUI.this.scrollTimer.stop();
            SkinnableScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    private class SkinnableTrackListener
    extends BasicScrollBarUI.TrackListener {
        private Point iMousePoint;

        private SkinnableTrackListener() {
            super(SkinnableScrollBarUI.this);
            this.iMousePoint = new Point();
        }

        public void mousePressed(MouseEvent event) {
            if (this.shouldHandleMousePressed(event)) {
                this.doMousePressed(event);
            }
        }

        public void mouseDragged(MouseEvent event) {
            if (this.shouldHandleMouseDragged(event)) {
                this.doMouseDragged(event);
            }
        }

        private void startScrollTimerIfNecessary() {
            if (SkinnableScrollBarUI.this.isPointBeforeScrollThumb(this.iMousePoint) || SkinnableScrollBarUI.this.isPointAfterScrollThumb(this.iMousePoint)) {
                SkinnableScrollBarUI.this.scrollTimer.start();
            }
        }

        private void captureCurrentMousePosition(MouseEvent event) {
            assert (event.getSource() == SkinnableScrollBarUI.this.scrollbar) : "The listener should be registered with the scrollbar for mouse events.";
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            this.iMousePoint.x = this.currentMouseX;
            this.iMousePoint.y = this.currentMouseY;
        }

        private boolean isIgnorableMiddleMousePress(MouseEvent event) {
            return SwingUtilities.isMiddleMouseButton(event) && !SkinnableScrollBarUI.this.getSupportsAbsolutePositioning();
        }

        private boolean shouldHandleMousePressed(MouseEvent event) {
            return !this.isIgnorableMiddleMousePress(event) && !SwingUtilities.isRightMouseButton(event) && SkinnableScrollBarUI.this.scrollbar.isEnabled();
        }

        private boolean shouldHandleMouseDragged(MouseEvent event) {
            return !this.isIgnorableMiddleMousePress(event) && !SwingUtilities.isRightMouseButton(event) && SkinnableScrollBarUI.this.scrollbar.isEnabled() && !SkinnableScrollBarUI.this.getThumbBounds().isEmpty();
        }

        private void doMousePressed(MouseEvent event) {
            SkinnableScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.captureCurrentMousePosition(event);
            if (SkinnableScrollBarUI.this.getThumbBounds().contains(this.iMousePoint)) {
                this.doMousePressedOnThumb();
            } else if (SkinnableScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(event)) {
                this.doMiddleMouseButtonPressedOnTrack(event);
            } else if (SkinnableScrollBarUI.this.getTrackBounds().contains(this.iMousePoint)) {
                this.doMousePressedOnTrack();
            }
        }

        private void doMousePressedOnThumb() {
            this.offset = SkinnableScrollBarUI.this.fOrientation.getPosition(this.iMousePoint) - SkinnableScrollBarUI.this.fOrientation.getPosition(SkinnableScrollBarUI.this.getThumbBounds().getLocation());
            SkinnableScrollBarUI.this.isDragging = true;
        }

        private void doMiddleMouseButtonPressedOnTrack(MouseEvent event) {
            this.offset = SkinnableScrollBarUI.this.fOrientation.getLength(SkinnableScrollBarUI.this.getThumbBounds().getSize()) / 2;
            SkinnableScrollBarUI.this.isDragging = true;
            SkinnableScrollBarUI.this.updateThumbBoundsAndScrollBarValueFromMouseEvent(event, this.offset);
        }

        private void doMousePressedOnTrack() {
            SkinnableScrollBarUI.this.isDragging = false;
            int direction = SkinnableScrollBarUI.this.getDirectionToMoveThumb(this.iMousePoint);
            SkinnableScrollBarUI.this.scrollByBlock(direction);
            SkinnableScrollBarUI.this.scrollTimer.stop();
            SkinnableScrollBarUI.this.scrollListener.setDirection(direction);
            SkinnableScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        private void doMouseDragged(MouseEvent event) {
            if (SkinnableScrollBarUI.this.isDragging) {
                SkinnableScrollBarUI.this.updateThumbBoundsAndScrollBarValueFromMouseEvent(event, this.offset);
            } else {
                this.captureCurrentMousePosition(event);
                this.startScrollTimerIfNecessary();
            }
        }
    }
}

