/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.zrtp;

import gnu.java.zrtp.utils.ZrtpCrc32;
import org.jitsi.impl.neomedia.RawPacket;

public class ZrtpRawPacket
extends RawPacket {
    public static final byte[] ZRTP_MAGIC = new byte[]{90, 82, 84, 80};

    public ZrtpRawPacket(RawPacket pkt) {
        super(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
    }

    public ZrtpRawPacket(byte[] buf, int off, int len) {
        super(buf, off, len);
        this.writeByte(0, (byte)16);
        this.writeByte(1, (byte)0);
        int at = 4;
        this.writeByte(at++, ZRTP_MAGIC[0]);
        this.writeByte(at++, ZRTP_MAGIC[1]);
        this.writeByte(at++, ZRTP_MAGIC[2]);
        this.writeByte(at, ZRTP_MAGIC[3]);
    }

    protected boolean isZrtpPacket() {
        return ZrtpRawPacket.isZrtpData(this);
    }

    static boolean isZrtpData(RawPacket pkt) {
        return pkt.getExtensionBit() && pkt.getHeaderExtensionType() == 20570;
    }

    protected boolean hasMagic() {
        return this.readByte(4) == ZRTP_MAGIC[0] && this.readByte(5) == ZRTP_MAGIC[1] && this.readByte(6) == ZRTP_MAGIC[2] && this.readByte(7) == ZRTP_MAGIC[3];
    }

    protected void setSeqNum(short seq) {
        int at = 2;
        this.writeByte(at++, (byte)(seq >> 8));
        this.writeByte(at, (byte)seq);
    }

    protected boolean checkCrc() {
        int crc = this.readInt(this.getLength() - 4);
        return ZrtpCrc32.zrtpCheckCksum((byte[])this.getBuffer(), (int)this.getOffset(), (int)(this.getLength() - 4), (int)crc);
    }

    protected void setCrc() {
        int crc = ZrtpCrc32.zrtpGenerateCksum((byte[])this.getBuffer(), (int)this.getOffset(), (int)(this.getLength() - 4));
        crc = ZrtpCrc32.zrtpEndCksum((int)crc);
        this.writeInt(this.getLength() - 4, crc);
    }
}

