/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Processor;
import org.jitsi.util.Logger;

public class ProcessorUtility
implements ControllerListener {
    private static final Logger logger = Logger.getLogger(ProcessorUtility.class);
    private final Object stateLock = new Object();
    private boolean failed = false;

    private Object getStateLock() {
        return this.stateLock;
    }

    private void setFailed(boolean failed) {
        this.failed = failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent ce) {
        Object stateLock;
        if (ce instanceof ControllerClosedEvent) {
            if (ce instanceof ControllerErrorEvent) {
                logger.warn("ControllerErrorEvent: " + ce);
            } else if (logger.isDebugEnabled()) {
                logger.debug("ControllerClosedEvent: " + ce);
            }
            this.setFailed(true);
        }
        Object object = stateLock = this.getStateLock();
        synchronized (object) {
            stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean waitForState(Processor processor, int state) {
        processor.addControllerListener((ControllerListener)this);
        this.setFailed(false);
        if (state == 180) {
            processor.configure();
        } else if (state == 300) {
            processor.realize();
        }
        boolean interrupted = false;
        while (processor.getState() < state && !this.failed) {
            Object stateLock;
            Object object = stateLock = this.getStateLock();
            synchronized (object) {
                try {
                    stateLock.wait();
                }
                catch (InterruptedException ie) {
                    logger.warn("Interrupted while waiting on Processor " + processor + " for state " + state, ie);
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        processor.removeControllerListener((ControllerListener)this);
        return !this.failed;
    }
}

