/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.validator;

import lombok.Generated;
import org.antlr.v4.runtime.CommonTokenStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.common.antlr.CaseInsensitiveCharStream;
import org.opensearch.sql.common.antlr.SyntaxAnalysisErrorListener;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.spark.antlr.parser.OpenSearchPPLLexer;
import org.opensearch.sql.spark.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.spark.validator.GrammarElementValidator;
import org.opensearch.sql.spark.validator.GrammarElementValidatorProvider;
import org.opensearch.sql.spark.validator.PPLQueryValidationVisitor;
import org.opensearch.sql.spark.validator.SQLQueryValidator;

public class PPLQueryValidator {
    private static final Logger log = LogManager.getLogger(SQLQueryValidator.class);
    private final GrammarElementValidatorProvider grammarElementValidatorProvider;

    public void validate(String pplQuery, DataSourceType datasourceType) {
        GrammarElementValidator grammarElementValidator = this.grammarElementValidatorProvider.getValidatorForDatasource(datasourceType);
        PPLQueryValidationVisitor visitor2 = new PPLQueryValidationVisitor(grammarElementValidator);
        try {
            visitor2.visit(PPLQueryValidator.getPplParser(pplQuery).root());
        }
        catch (IllegalArgumentException e) {
            log.error("Query validation failed. DataSourceType=" + String.valueOf(datasourceType), (Throwable)e);
            throw e;
        }
    }

    public static OpenSearchPPLParser getPplParser(String pplQuery) {
        OpenSearchPPLParser sqlBaseParser = new OpenSearchPPLParser(new CommonTokenStream(new OpenSearchPPLLexer(new CaseInsensitiveCharStream(pplQuery))));
        sqlBaseParser.addErrorListener(new SyntaxAnalysisErrorListener());
        return sqlBaseParser;
    }

    @Generated
    public PPLQueryValidator(GrammarElementValidatorProvider grammarElementValidatorProvider) {
        this.grammarElementValidatorProvider = grammarElementValidatorProvider;
    }
}

