/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.client;

import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.emrserverless.AWSEMRServerless;
import com.amazonaws.services.emrserverless.AWSEMRServerlessClientBuilder;
import java.security.AccessController;
import lombok.Generated;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.spark.asyncquery.model.NullAsyncQueryRequestContext;
import org.opensearch.sql.spark.client.EMRServerlessClient;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.client.EmrServerlessClientImpl;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfig;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplier;
import org.opensearch.sql.spark.metrics.MetricsService;

public class EMRServerlessClientFactoryImpl
implements EMRServerlessClientFactory {
    private final SparkExecutionEngineConfigSupplier sparkExecutionEngineConfigSupplier;
    private final MetricsService metricsService;
    private EMRServerlessClient emrServerlessClient;
    private String region;

    @Override
    public EMRServerlessClient getClient(String accountId) {
        SparkExecutionEngineConfig sparkExecutionEngineConfig = this.sparkExecutionEngineConfigSupplier.getSparkExecutionEngineConfig(new NullAsyncQueryRequestContext());
        this.validateSparkExecutionEngineConfig(sparkExecutionEngineConfig);
        if (this.isNewClientCreationRequired(sparkExecutionEngineConfig.getRegion())) {
            this.region = sparkExecutionEngineConfig.getRegion();
            this.emrServerlessClient = this.createEMRServerlessClient(this.region);
        }
        return this.emrServerlessClient;
    }

    private boolean isNewClientCreationRequired(String region) {
        return !region.equals(this.region);
    }

    private void validateSparkExecutionEngineConfig(SparkExecutionEngineConfig sparkExecutionEngineConfig) {
        if (sparkExecutionEngineConfig == null || sparkExecutionEngineConfig.getRegion() == null) {
            throw new IllegalArgumentException(String.format("Async Query APIs are disabled. Please configure %s in cluster settings to enable them.", Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG.getKeyValue()));
        }
    }

    private EMRServerlessClient createEMRServerlessClient(String awsRegion) {
        return AccessController.doPrivileged(() -> {
            AWSEMRServerless awsemrServerless = (AWSEMRServerless)((AWSEMRServerlessClientBuilder)((AWSEMRServerlessClientBuilder)AWSEMRServerlessClientBuilder.standard().withRegion(awsRegion)).withCredentials(new DefaultAWSCredentialsProviderChain())).build();
            return new EmrServerlessClientImpl(awsemrServerless, this.metricsService);
        });
    }

    @Generated
    public EMRServerlessClientFactoryImpl(SparkExecutionEngineConfigSupplier sparkExecutionEngineConfigSupplier, MetricsService metricsService) {
        this.sparkExecutionEngineConfigSupplier = sparkExecutionEngineConfigSupplier;
        this.metricsService = metricsService;
    }
}

