/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.util;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Point;
import org.opensearch.sql.calcite.type.ExprJavaType;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprGeoPointValue;

public final class JdbcOpenSearchDataTypeConvertor {
    private static final Logger LOG = LogManager.getLogger();

    public static ExprType getExprTypeFromSqlType(int sqlType) {
        switch (sqlType) {
            case 4: {
                return ExprCoreType.INTEGER;
            }
            case -5: {
                return ExprCoreType.LONG;
            }
            case 2: 
            case 3: 
            case 8: {
                return ExprCoreType.DOUBLE;
            }
            case 6: {
                return ExprCoreType.FLOAT;
            }
            case 91: {
                return ExprCoreType.DATE;
            }
            case 93: {
                return ExprCoreType.TIMESTAMP;
            }
            case 16: {
                return ExprCoreType.BOOLEAN;
            }
            case -1: 
            case 1: 
            case 12: {
                return ExprCoreType.STRING;
            }
        }
        return ExprCoreType.UNKNOWN;
    }

    public static ExprValue getExprValueFromSqlType(ResultSet rs, int i, int sqlType, RelDataType fieldType, String fieldName) throws SQLException {
        Object value = rs.getObject(i);
        if (value == null) {
            return ExprNullValue.of();
        }
        if (fieldType instanceof ExprJavaType && value instanceof ExprValue) {
            return (ExprValue)value;
        }
        if (fieldType.getSqlTypeName() == SqlTypeName.GEOMETRY) {
            Point geoPoint = (Point)rs.getObject(fieldName);
            return new OpenSearchExprGeoPointValue(geoPoint.getY(), geoPoint.getX());
        }
        try {
            switch (sqlType) {
                case -1: 
                case 1: 
                case 12: {
                    return ExprValueUtils.fromObjectValue(rs.getString(i));
                }
                case 4: {
                    return ExprValueUtils.fromObjectValue(rs.getInt(i));
                }
                case -5: {
                    return ExprValueUtils.fromObjectValue(rs.getLong(i));
                }
                case 6: 
                case 7: {
                    return ExprValueUtils.fromObjectValue(Float.valueOf(rs.getFloat(i)));
                }
                case 2: 
                case 3: 
                case 8: {
                    return ExprValueUtils.fromObjectValue(rs.getDouble(i));
                }
                case 91: {
                    String dateStr = rs.getString(i);
                    return new ExprDateValue(dateStr);
                }
                case 92: {
                    String timeStr = rs.getString(i);
                    return new ExprTimeValue(timeStr);
                }
                case 93: {
                    String timestampStr = rs.getString(i);
                    return new ExprTimestampValue(timestampStr);
                }
                case 16: {
                    return ExprValueUtils.fromObjectValue(rs.getBoolean(i));
                }
                case 2003: {
                    Array array = rs.getArray(i);
                    if (array instanceof ArrayImpl) {
                        return ExprValueUtils.fromObjectValue(Arrays.asList((Object[])((ArrayImpl)value).getArray()));
                    }
                    return ExprValueUtils.fromObjectValue(array);
                }
            }
            LOG.debug("Unchecked sql type: {}, return Object type {}", (Object)sqlType, (Object)value.getClass().getTypeName());
            return JdbcOpenSearchDataTypeConvertor.convertComplexValue(value);
        }
        catch (SQLException e) {
            LOG.error("Error converting SQL type {}: {}", (Object)sqlType, (Object)e.getMessage());
            throw e;
        }
    }

    private static ExprValue convertComplexValue(Object value) {
        Object converted = JdbcOpenSearchDataTypeConvertor.processValue(value);
        return ExprValueUtils.fromObjectValue(converted);
    }

    private static Object processValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Point) {
            Point point = (Point)value;
            return new OpenSearchExprGeoPointValue(point.getY(), point.getX());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            HashMap<String, Object> convertedMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                convertedMap.put((String)entry.getKey(), JdbcOpenSearchDataTypeConvertor.processValue(entry.getValue()));
            }
            return convertedMap;
        }
        return value;
    }

    @Generated
    private JdbcOpenSearchDataTypeConvertor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

