/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.functions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.common.util.BigArrays;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;

public class DistinctCountApproxAggFunction
implements UserDefinedAggFunction<HLLAccumulator> {
    @Override
    public HLLAccumulator init() {
        return new HLLAccumulator();
    }

    @Override
    public Object result(HLLAccumulator accumulator) {
        return accumulator.value(new Object[0]);
    }

    @Override
    public HLLAccumulator add(HLLAccumulator acc, Object ... values2) {
        for (Object value : values2) {
            if (value == null) continue;
            acc.add(value);
        }
        return acc;
    }

    private static long hash(Object data2) {
        byte[] bytes;
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        if (data2 == null) {
            return 0L;
        }
        if (data2 instanceof byte[]) {
            bytes = (byte[])data2;
        } else if (data2 instanceof String) {
            bytes = ((String)data2).getBytes(StandardCharsets.UTF_8);
        } else if (data2 instanceof Number) {
            long value = ((Number)data2).longValue();
            bytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
        } else {
            bytes = data2.toString().getBytes(StandardCharsets.UTF_8);
        }
        MurmurHash3.hash128((byte[])bytes, (int)0, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)hash);
        return hash.h1 ^ hash.h2;
    }

    public static class HLLAccumulator
    implements UserDefinedAggFunction.Accumulator {
        private final HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus(14, BigArrays.NON_RECYCLING_INSTANCE, 1L);

        public void add(Object value) {
            this.hll.collect(0L, DistinctCountApproxAggFunction.hash(value));
        }

        @Override
        public Object value(Object ... args2) {
            return this.hll.cardinality(0L);
        }
    }
}

