/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;

public class OpenSearchAliasType
extends OpenSearchDataType {
    public static final String typeName = "alias";
    public static final String pathPropertyName = "path";
    public static final Set<OpenSearchDataType.MappingType> objectFieldTypes = Set.of(OpenSearchDataType.MappingType.Object, OpenSearchDataType.MappingType.Nested);
    private final String path;
    private final OpenSearchDataType originalType;

    public OpenSearchAliasType(String path, OpenSearchDataType type2) {
        super(type2.getExprCoreType());
        if (type2 instanceof OpenSearchAliasType) {
            throw new IllegalStateException(String.format("Alias field cannot refer to the path [%s] of alias type", path));
        }
        if (objectFieldTypes.contains((Object)type2.getMappingType())) {
            throw new IllegalStateException(String.format("Alias field cannot refer to the path [%s] of object type", path));
        }
        this.path = path;
        this.originalType = type2;
    }

    @Override
    public Optional<String> getOriginalPath() {
        return Optional.of(this.path);
    }

    @Override
    public ExprType getOriginalExprType() {
        return this.originalType.getExprType();
    }

    @Override
    public ExprType getExprType() {
        return this;
    }

    @Override
    public OpenSearchDataType cloneEmpty() {
        return new OpenSearchAliasType(this.path, this.originalType.cloneEmpty());
    }

    @Override
    public boolean isCompatible(ExprType other) {
        return this.originalType.isCompatible(other);
    }

    @Override
    public List<ExprType> getParent() {
        return this.originalType.getParent();
    }

    @Override
    public String typeName() {
        return this.originalType.typeName();
    }

    @Override
    public String legacyTypeName() {
        return this.originalType.legacyTypeName();
    }

    @Override
    public boolean shouldCast(ExprType other) {
        return this.originalType.shouldCast(other);
    }
}

