/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.nestedfield;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import org.opensearch.sql.legacy.rewriter.nestedfield.SQLClause;
import org.opensearch.sql.legacy.rewriter.nestedfield.Scope;

class Identifier
extends SQLClause<SQLIdentifierExpr> {
    private static final String SEPARATOR = ".";

    Identifier(SQLIdentifierExpr expr) {
        super(expr);
    }

    @Override
    void rewrite(Scope scope2) {
        this.eraseParentAlias(scope2);
        if (this.isNestedField(scope2)) {
            this.renameByFullPath(scope2);
            if (this.isInCondition()) {
                this.useFullPathAsTag(scope2);
            } else {
                this.replaceByNestedFunction((SQLExpr)this.expr, this.pathFromIdentifier((SQLExpr)this.expr));
            }
        }
    }

    String path() {
        return this.separatorIndex() == -1 ? ((SQLIdentifierExpr)this.expr).getName() : ((SQLIdentifierExpr)this.expr).getName().substring(0, this.separatorIndex());
    }

    String name() {
        return ((SQLIdentifierExpr)this.expr).getName().substring(this.separatorIndex() + 1);
    }

    private int separatorIndex() {
        return ((SQLIdentifierExpr)this.expr).getName().indexOf(SEPARATOR);
    }

    private void eraseParentAlias(Scope scope2) {
        if (this.isStartWithParentAlias(scope2)) {
            ((SQLIdentifierExpr)this.expr).setName(this.name());
        }
    }

    private boolean isStartWithParentAlias(Scope scope2) {
        return this.path().equals(scope2.getParentAlias());
    }

    private boolean isNestedField(Scope scope2) {
        return !scope2.getFullPath(this.path()).isEmpty();
    }

    private void renameByFullPath(Scope scope2) {
        String fullPath = scope2.getFullPath(this.path());
        if (fullPath.isEmpty()) {
            throw new IllegalStateException("Full path not found for identifier:" + ((SQLIdentifierExpr)this.expr).getName());
        }
        ((SQLIdentifierExpr)this.expr).setName(((SQLIdentifierExpr)this.expr).getName().replaceFirst(this.path(), fullPath));
    }

    private void useFullPathAsTag(Scope scope2) {
        scope2.addConditionTag((SQLBinaryOpExpr)((SQLIdentifierExpr)this.expr).getParent(), this.path());
    }

    private boolean isInCondition() {
        return ((SQLIdentifierExpr)this.expr).getParent() instanceof SQLBinaryOpExpr;
    }
}

