/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.syntax;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.opensearch.sql.legacy.antlr.syntax.SyntaxAnalysisException;
import org.opensearch.sql.legacy.utils.StringUtils;

public class SyntaxAnalysisErrorListener
extends BaseErrorListener {
    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        Token offendingToken = (Token)offendingSymbol;
        String query = tokens.getText();
        throw new SyntaxAnalysisException(StringUtils.format("Failed to parse query due to offending symbol [%s] at: '%s' <--- HERE... More details: %s", this.getOffendingText(offendingToken), this.truncateQueryAtOffendingToken(query, offendingToken), this.getDetails(recognizer, msg, e)));
    }

    private String getOffendingText(Token offendingToken) {
        return offendingToken.getText();
    }

    private String truncateQueryAtOffendingToken(String query, Token offendingToken) {
        return query.substring(0, offendingToken.getStopIndex() + 1);
    }

    private String getDetails(Recognizer<?, ?> recognizer, String msg, RecognitionException e) {
        Object details;
        if (e == null) {
            details = msg;
        } else {
            IntervalSet followSet = e.getExpectedTokens();
            details = "Expecting tokens in " + followSet.toString(recognizer.getVocabulary());
        }
        return details;
    }
}

