/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.time.LocalDateTime;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class SysdateFunction
extends ImplementorUDF {
    public SysdateFunction() {
        super(new SysdateImplementor(), NullPolicy.ANY);
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.OPTIONAL_INTEGER;
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.TIMESTAMP_FORCE_NULLABLE;
    }

    public static class SysdateImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(translatedOperands, translator);
            return Expressions.call(SysdateImplementor.class, "sysdate", operandsWithProperties);
        }

        public static String sysdate(FunctionProperties properties2) {
            LocalDateTime localDateTime = DateTimeFunctions.formatNow(properties2.getSystemClock(), 0);
            return (String)new ExprTimestampValue(localDateTime).valueForCalcite();
        }

        public static String sysdate(FunctionProperties properties2, int precision) {
            LocalDateTime localDateTime = DateTimeFunctions.formatNow(properties2.getSystemClock(), precision);
            return (String)new ExprTimestampValue(localDateTime).valueForCalcite();
        }
    }
}

