/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.binning;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class WidthBucketFunction
extends ImplementorUDF {
    public WidthBucketFunction() {
        super(new WidthBucketImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR_2000;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_NUMERIC_NUMERIC_NUMERIC;
    }

    public static class WidthBucketImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression fieldValue = translatedOperands.get(0);
            Expression numBins = translatedOperands.get(1);
            Expression dataRange = translatedOperands.get(2);
            Expression maxValue = translatedOperands.get(3);
            return Expressions.call(WidthBucketImplementor.class, "calculateWidthBucket", new Expression[]{Expressions.convert_(fieldValue, Number.class), Expressions.convert_(numBins, Number.class), Expressions.convert_(dataRange, Number.class), Expressions.convert_(maxValue, Number.class)});
        }

        public static String calculateWidthBucket(Number fieldValue, Number numBinsParam, Number dataRange, Number maxValue) {
            if (fieldValue == null || numBinsParam == null || dataRange == null || maxValue == null) {
                return null;
            }
            double value = fieldValue.doubleValue();
            int numBins = numBinsParam.intValue();
            if (numBins < 2 || numBins > 50000) {
                return null;
            }
            double range = dataRange.doubleValue();
            double max = maxValue.doubleValue();
            if (range <= 0.0) {
                return null;
            }
            double width = WidthBucketImplementor.calculateOptimalWidth(range, max, numBins);
            if (width <= 0.0) {
                return null;
            }
            double binStart = Math.floor(value / width) * width;
            double binEnd = binStart + width;
            return WidthBucketImplementor.formatRange(binStart, binEnd, width);
        }

        private static double calculateOptimalWidth(double dataRange, double maxValue, int requestedBins) {
            if (dataRange <= 0.0 || requestedBins <= 0) {
                return 1.0;
            }
            double targetWidth = dataRange / (double)requestedBins;
            double exponent = Math.ceil(Math.log10(targetWidth));
            double optimalWidth = Math.pow(10.0, exponent);
            double actualBins = Math.ceil(dataRange / optimalWidth);
            if (maxValue % optimalWidth == 0.0) {
                actualBins += 1.0;
            }
            if (actualBins > (double)requestedBins) {
                optimalWidth = Math.pow(10.0, exponent + 1.0);
            }
            return optimalWidth;
        }

        private static String formatRange(double binStart, double binEnd, double span) {
            if (WidthBucketImplementor.isIntegerSpan(span) && WidthBucketImplementor.isIntegerValue(binStart) && WidthBucketImplementor.isIntegerValue(binEnd)) {
                return String.format("%d-%d", (long)binStart, (long)binEnd);
            }
            return WidthBucketImplementor.formatFloatingPointRange(binStart, binEnd, span);
        }

        private static boolean isIntegerSpan(double span) {
            return span == Math.floor(span) && !Double.isInfinite(span);
        }

        private static boolean isIntegerValue(double value) {
            return Math.abs(value - (double)Math.round(value)) < 1.0E-10;
        }

        private static String formatFloatingPointRange(double binStart, double binEnd, double span) {
            int decimalPlaces = WidthBucketImplementor.getAppropriateDecimalPlaces(span);
            String format = String.format("%%.%df-%%.%df", decimalPlaces, decimalPlaces);
            return String.format(format, binStart, binEnd);
        }

        private static int getAppropriateDecimalPlaces(double span) {
            if (span >= 1.0) {
                return 1;
            }
            if (span >= 0.1) {
                return 2;
            }
            if (span >= 0.01) {
                return 3;
            }
            return 4;
        }
    }
}

