/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.RequestContext;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceStatus;
import org.opensearch.sql.datasources.auth.DataSourceUserAuthorizationHelper;
import org.opensearch.sql.datasources.exceptions.DataSourceNotFoundException;
import org.opensearch.sql.datasources.exceptions.DatasourceDisabledException;
import org.opensearch.sql.datasources.service.DataSourceLoaderCache;
import org.opensearch.sql.datasources.service.DataSourceLoaderCacheImpl;
import org.opensearch.sql.datasources.service.DataSourceMetadataStorage;
import org.opensearch.sql.storage.DataSourceFactory;

public class DataSourceServiceImpl
implements DataSourceService {
    public static final Set<String> CONFIDENTIAL_AUTH_KEYS = Set.of("auth.username", "auth.password", "auth.access_key", "auth.secret_key");
    private final DataSourceLoaderCache dataSourceLoaderCache;
    private final DataSourceMetadataStorage dataSourceMetadataStorage;
    private final DataSourceUserAuthorizationHelper dataSourceUserAuthorizationHelper;

    public DataSourceServiceImpl(Set<DataSourceFactory> dataSourceFactories, DataSourceMetadataStorage dataSourceMetadataStorage, DataSourceUserAuthorizationHelper dataSourceUserAuthorizationHelper) {
        this.dataSourceMetadataStorage = dataSourceMetadataStorage;
        this.dataSourceUserAuthorizationHelper = dataSourceUserAuthorizationHelper;
        this.dataSourceLoaderCache = new DataSourceLoaderCacheImpl(dataSourceFactories);
    }

    @Override
    public Set<DataSourceMetadata> getDataSourceMetadata(boolean isDefaultDataSourceRequired) {
        List<DataSourceMetadata> dataSourceMetadataList = this.dataSourceMetadataStorage.getDataSourceMetadata();
        HashSet<DataSourceMetadata> dataSourceMetadataSet = new HashSet<DataSourceMetadata>(dataSourceMetadataList);
        if (isDefaultDataSourceRequired) {
            dataSourceMetadataSet.add(DataSourceMetadata.defaultOpenSearchDataSourceMetadata());
        }
        return this.removeAuthInfo(dataSourceMetadataSet);
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata(String dataSourceName) {
        DataSourceMetadata dataSourceMetadata = this.getRawDataSourceMetadata(dataSourceName);
        return this.removeAuthInfo(dataSourceMetadata);
    }

    @Override
    public DataSource getDataSource(String dataSourceName) {
        DataSourceMetadata dataSourceMetadata = this.getRawDataSourceMetadata(dataSourceName);
        this.verifyDataSourceAccess(dataSourceMetadata);
        return this.dataSourceLoaderCache.getOrLoadDataSource(dataSourceMetadata);
    }

    @Override
    public void createDataSource(DataSourceMetadata metadata2) {
        if (!metadata2.getName().equals("@opensearch")) {
            this.dataSourceLoaderCache.getOrLoadDataSource(metadata2);
            this.dataSourceMetadataStorage.createDataSourceMetadata(metadata2);
        }
    }

    @Override
    public void updateDataSource(DataSourceMetadata dataSourceMetadata) {
        if (dataSourceMetadata.getName().equals("@opensearch")) {
            throw new UnsupportedOperationException("Not allowed to update default datasource :@opensearch");
        }
        this.dataSourceLoaderCache.getOrLoadDataSource(dataSourceMetadata);
        this.dataSourceMetadataStorage.updateDataSourceMetadata(dataSourceMetadata);
    }

    @Override
    public void patchDataSource(Map<String, Object> dataSourceData) {
        if (dataSourceData.get("name").equals("@opensearch")) {
            throw new UnsupportedOperationException("Not allowed to update default datasource :@opensearch");
        }
        DataSourceMetadata dataSourceMetadata = this.getRawDataSourceMetadata((String)dataSourceData.get("name"));
        DataSourceMetadata updatedMetadata = this.constructUpdatedDatasourceMetadata(dataSourceData, dataSourceMetadata);
        this.updateDataSource(updatedMetadata);
    }

    @Override
    public void deleteDataSource(String dataSourceName) {
        if (dataSourceName.equals("@opensearch")) {
            throw new UnsupportedOperationException("Not allowed to delete default datasource :@opensearch");
        }
        this.dataSourceMetadataStorage.deleteDataSourceMetadata(dataSourceName);
    }

    @Override
    public Boolean dataSourceExists(String dataSourceName) {
        return "@opensearch".equals(dataSourceName) || this.dataSourceMetadataStorage.getDataSourceMetadata(dataSourceName).isPresent();
    }

    @Override
    public DataSourceMetadata verifyDataSourceAccessAndGetRawMetadata(String dataSourceName, RequestContext requestContext) {
        DataSourceMetadata dataSourceMetadata = this.getRawDataSourceMetadata(dataSourceName);
        this.verifyDataSourceAccess(dataSourceMetadata);
        return dataSourceMetadata;
    }

    private void verifyDataSourceAccess(DataSourceMetadata dataSourceMetadata) {
        if (dataSourceMetadata.getStatus().equals((Object)DataSourceStatus.DISABLED)) {
            throw new DatasourceDisabledException(String.format("Datasource %s is disabled.", dataSourceMetadata.getName()));
        }
        this.dataSourceUserAuthorizationHelper.authorizeDataSource(dataSourceMetadata);
    }

    private DataSourceMetadata constructUpdatedDatasourceMetadata(Map<String, Object> dataSourceData, DataSourceMetadata metadata2) {
        DataSourceMetadata.Builder metadataBuilder = new DataSourceMetadata.Builder(metadata2);
        Iterator<String> iterator2 = dataSourceData.keySet().iterator();
        while (iterator2.hasNext()) {
            String key;
            switch (key = iterator2.next()) {
                case "description": {
                    metadataBuilder.setDescription((String)dataSourceData.get("description"));
                    break;
                }
                case "allowedRoles": {
                    metadataBuilder.setAllowedRoles((List)dataSourceData.get("allowedRoles"));
                    break;
                }
                case "properties": {
                    HashMap<String, String> properties2 = new HashMap<String, String>(metadata2.getProperties());
                    properties2.putAll((Map)dataSourceData.get("properties"));
                    metadataBuilder.setProperties(properties2);
                    break;
                }
                case "resultIndex": {
                    metadataBuilder.setResultIndex((String)dataSourceData.get("resultIndex"));
                }
                case "status": {
                    metadataBuilder.setDataSourceStatus((DataSourceStatus)((Object)dataSourceData.get("status")));
                }
            }
        }
        return metadataBuilder.validateAndBuild();
    }

    private DataSourceMetadata getRawDataSourceMetadata(String dataSourceName) {
        if (dataSourceName.equals("@opensearch")) {
            return DataSourceMetadata.defaultOpenSearchDataSourceMetadata();
        }
        Optional<DataSourceMetadata> dataSourceMetadataOptional = this.dataSourceMetadataStorage.getDataSourceMetadata(dataSourceName);
        if (dataSourceMetadataOptional.isEmpty()) {
            throw new DataSourceNotFoundException(String.format("DataSource with name %s doesn't exist.", dataSourceName));
        }
        return dataSourceMetadataOptional.get();
    }

    private Set<DataSourceMetadata> removeAuthInfo(Set<DataSourceMetadata> dataSourceMetadataSet) {
        return dataSourceMetadataSet.stream().map(this::removeAuthInfo).collect(Collectors.toSet());
    }

    private DataSourceMetadata removeAuthInfo(DataSourceMetadata dataSourceMetadata) {
        HashMap<String, String> safeProperties = new HashMap<String, String>(dataSourceMetadata.getProperties());
        safeProperties.entrySet().removeIf(entry -> CONFIDENTIAL_AUTH_KEYS.stream().anyMatch(confidentialKey -> ((String)entry.getKey()).endsWith((String)confidentialKey)));
        return new DataSourceMetadata.Builder(dataSourceMetadata).setProperties(safeProperties).validateAndBuild();
    }
}

