/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitConfig;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class AlignmentHandler {
    public static RexNode createEpochAlignedSpan(RexNode fieldExpr, int intervalValue, TimeUnitConfig config, long referenceEpochSeconds, CalcitePlanContext context) {
        RexNode epochSeconds = context.rexBuilder.makeCall(PPLBuiltinOperators.UNIX_TIMESTAMP, fieldExpr);
        RexLiteral referenceTimestamp = context.relBuilder.literal(referenceEpochSeconds);
        long intervalSeconds = config.toSeconds(intervalValue);
        RexLiteral intervalLiteral = context.relBuilder.literal(intervalSeconds);
        RexNode timeOffset = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, epochSeconds, referenceTimestamp);
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, timeOffset, intervalLiteral));
        RexNode binOffset = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, binNumber, intervalLiteral);
        RexNode binStartSeconds = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, referenceTimestamp, binOffset);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, binStartSeconds);
    }

    public static RexNode createTimeModifierAlignedSpan(RexNode fieldExpr, int intervalValue, TimeUnitConfig config, String timeModifier, CalcitePlanContext context) {
        RexNode epochSeconds = context.rexBuilder.makeCall(PPLBuiltinOperators.UNIX_TIMESTAMP, fieldExpr);
        long offsetMillis = AlignmentHandler.parseTimeModifier(timeModifier);
        boolean alignToDay = timeModifier != null && timeModifier.startsWith("@d");
        long intervalSeconds = config.toSeconds(intervalValue);
        RexLiteral intervalLiteral = context.relBuilder.literal(intervalSeconds);
        if (alignToDay) {
            RexNode alignmentReference;
            RexLiteral secondsPerDay = context.relBuilder.literal(86400L);
            RexLiteral earliestTimestamp = context.relBuilder.literal(1753661723L);
            RexNode daysSinceEpoch = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, earliestTimestamp, secondsPerDay));
            RexNode startOfEarliestDay = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, daysSinceEpoch, secondsPerDay);
            if (offsetMillis != 0L) {
                long offsetSeconds = offsetMillis / 1000L;
                alignmentReference = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, startOfEarliestDay, context.relBuilder.literal(offsetSeconds));
            } else {
                alignmentReference = startOfEarliestDay;
            }
            RexNode timeOffset = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, epochSeconds, alignmentReference);
            RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, timeOffset, intervalLiteral));
            RexNode binOffset = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, binNumber, intervalLiteral);
            RexNode binStartSeconds = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, alignmentReference, binOffset);
            return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, binStartSeconds);
        }
        RexNode divided = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, epochSeconds, intervalLiteral);
        RexNode binNumber = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.FLOOR, divided);
        RexNode binStartSeconds = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, binNumber, intervalLiteral);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.FROM_UNIXTIME, binStartSeconds);
    }

    private static long parseTimeModifier(String timeModifier) {
        if (timeModifier == null || timeModifier.equals("@d")) {
            return 0L;
        }
        if (timeModifier.startsWith("@d+")) {
            String offsetStr = timeModifier.substring(3);
            return AlignmentHandler.parseTimeOffset(offsetStr);
        }
        if (timeModifier.startsWith("@d-")) {
            String offsetStr = timeModifier.substring(3);
            return -AlignmentHandler.parseTimeOffset(offsetStr);
        }
        return 0L;
    }

    private static long parseTimeOffset(String offsetStr) {
        if ((offsetStr = offsetStr.trim().toLowerCase()).endsWith("h")) {
            int hours = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)hours * 3600000L;
        }
        if (offsetStr.endsWith("m")) {
            int minutes = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)minutes * 60000L;
        }
        if (offsetStr.endsWith("s")) {
            int seconds = Integer.parseInt(offsetStr.substring(0, offsetStr.length() - 1));
            return (long)seconds * 1000L;
        }
        int hours = Integer.parseInt(offsetStr);
        return (long)hours * 3600000L;
    }
}

