/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Holder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.analysis.DataSourceSchemaIdentifierNameResolver;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.EmptySourcePropagateVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.PatternMethod;
import org.opensearch.sql.ast.expression.PatternMode;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowFrame;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.subquery.SubqueryExpression;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Paginate;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Timechart;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.CalciteAggCallVisitor;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.plan.OpenSearchConstants;
import org.opensearch.sql.calcite.utils.BinUtils;
import org.opensearch.sql.calcite.utils.JoinAndLookupUtils;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.WildcardUtils;
import org.opensearch.sql.common.patterns.PatternUtils;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.exception.CalciteUnsupportedException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;
import org.opensearch.sql.expression.parse.RegexCommonUtils;
import org.opensearch.sql.utils.ParseUtils;
import org.opensearch.sql.utils.WildcardRenameUtils;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Iterables;
import shaded.com.google.common.collect.Streams;

public class CalciteRelNodeVisitor
extends AbstractNodeVisitor<RelNode, CalcitePlanContext> {
    private final CalciteRexNodeVisitor rexVisitor = new CalciteRexNodeVisitor(this);
    private final CalciteAggCallVisitor aggVisitor = new CalciteAggCallVisitor(this.rexVisitor);
    private final DataSourceService dataSourceService;
    private static final String REVERSE_ROW_NUM = "__reverse_row_num__";

    public CalciteRelNodeVisitor(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    public RelNode analyze(UnresolvedPlan unresolved, CalcitePlanContext context) {
        return unresolved.accept(this, context);
    }

    @Override
    public RelNode visitRelation(Relation node, CalcitePlanContext context) {
        DataSourceSchemaIdentifierNameResolver nameResolver = new DataSourceSchemaIdentifierNameResolver(this.dataSourceService, node.getTableQualifiedName().getParts());
        if (!nameResolver.getDataSourceName().equals("@opensearch")) {
            throw new CalciteUnsupportedException("Datasource " + nameResolver.getDataSourceName() + " is unsupported in Calcite");
        }
        if (nameResolver.getIdentifierName().equals(".DATASOURCES")) {
            throw new CalciteUnsupportedException("SHOW DATASOURCES is unsupported in Calcite");
        }
        if (nameResolver.getSchemaName().equals("information_schema")) {
            throw new CalciteUnsupportedException("information_schema is unsupported in Calcite");
        }
        context.relBuilder.scan(node.getTableQualifiedName().getParts());
        return context.relBuilder.peek();
    }

    private RelBuilder scan(RelOptTable tableSchema, CalcitePlanContext context) {
        RelNode scan = context.relBuilder.getScanFactory().createScan(ViewExpanders.simpleContext(context.relBuilder.getCluster()), tableSchema);
        context.relBuilder.push(scan);
        return context.relBuilder;
    }

    @Override
    public RelNode visitSearch(Search node, CalcitePlanContext context) {
        node.getChild().get(0).accept(this, context);
        Function queryStringFunc = AstDSL.function("query_string", AstDSL.unresolvedArg("query", AstDSL.stringLiteral(node.getQueryString())));
        RexNode queryStringRex = this.rexVisitor.analyze(queryStringFunc, context);
        context.relBuilder.filter(queryStringRex);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitFilter(Filter node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        boolean containsSubqueryExpression = this.containsSubqueryExpression(node.getCondition());
        Holder<@Nullable E> v = Holder.empty();
        if (containsSubqueryExpression) {
            context.relBuilder.variable(v::set);
            context.pushCorrelVar((RexCorrelVariable)v.get());
        }
        RexNode condition = this.rexVisitor.analyze(node.getCondition(), context);
        if (containsSubqueryExpression) {
            context.relBuilder.filter(ImmutableList.of(((RexCorrelVariable)v.get()).id), condition);
            context.popCorrelVar();
        } else {
            context.relBuilder.filter(condition);
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitRegex(Regex node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldRex = this.rexVisitor.analyze(node.getField(), context);
        RexNode patternRex = this.rexVisitor.analyze(node.getPattern(), context);
        if (!SqlTypeFamily.CHARACTER.contains(fieldRex.getType())) {
            throw new IllegalArgumentException(String.format("Regex command requires field of string type, but got %s for field '%s'", new Object[]{fieldRex.getType().getSqlTypeName(), node.getField().toString()}));
        }
        RexNode regexCondition = context.rexBuilder.makeCall((SqlOperator)SqlLibraryOperators.REGEXP_CONTAINS, fieldRex, patternRex);
        if (node.isNegated()) {
            regexCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, regexCondition);
        }
        context.relBuilder.filter(regexCondition);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitRex(Rex node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldRex = this.rexVisitor.analyze(node.getField(), context);
        String patternStr = (String)node.getPattern().getValue();
        if (node.getMode() == Rex.RexMode.SED) {
            RexNode sedCall = this.createOptimizedSedCall(fieldRex, patternStr, context);
            String fieldName = node.getField().toString();
            this.projectPlusOverriding(List.of(sedCall), List.of(fieldName), context);
            return context.relBuilder.peek();
        }
        List<String> namedGroups = RegexCommonUtils.getNamedGroupCandidates(patternStr);
        if (namedGroups.isEmpty()) {
            throw new IllegalArgumentException("Rex pattern must contain at least one named capture group");
        }
        ArrayList<RexNode> newFields = new ArrayList<RexNode>();
        ArrayList<String> newFieldNames = new ArrayList<String>();
        for (int i = 0; i < namedGroups.size(); ++i) {
            RexNode extractCall = node.getMaxMatch().isPresent() && node.getMaxMatch().get() > 1 ? PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_EXTRACT_MULTI, fieldRex, context.rexBuilder.makeLiteral(patternStr), context.relBuilder.literal(i + 1), context.relBuilder.literal(node.getMaxMatch().get())) : PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_EXTRACT, fieldRex, context.rexBuilder.makeLiteral(patternStr), context.relBuilder.literal(i + 1));
            newFields.add(extractCall);
            newFieldNames.add(namedGroups.get(i));
        }
        if (node.getOffsetField().isPresent()) {
            RexNode offsetCall = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.REX_OFFSET, fieldRex, context.rexBuilder.makeLiteral(patternStr));
            newFields.add(offsetCall);
            newFieldNames.add(node.getOffsetField().get());
        }
        this.projectPlusOverriding(newFields, newFieldNames, context);
        return context.relBuilder.peek();
    }

    private boolean containsSubqueryExpression(Node expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof SubqueryExpression) {
            return true;
        }
        if (expr instanceof Let) {
            Let l = (Let)expr;
            return this.containsSubqueryExpression(l.getExpression());
        }
        for (Node node : expr.getChild()) {
            if (!this.containsSubqueryExpression(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelNode visitProject(Project node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (this.isSingleAllFieldsProject(node)) {
            return this.handleAllFieldsProject(node, context);
        }
        List<String> currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> expandedFields = this.expandProjectFields(node.getProjectList(), currentFields, context);
        if (node.isExcluded()) {
            this.validateExclusion(expandedFields, currentFields);
            context.relBuilder.projectExcept(expandedFields);
        } else {
            if (!context.isResolvingSubquery()) {
                context.setProjectVisited(true);
            }
            context.relBuilder.project(expandedFields);
        }
        return context.relBuilder.peek();
    }

    private boolean isSingleAllFieldsProject(Project node) {
        return node.getProjectList().size() == 1 && node.getProjectList().getFirst() instanceof AllFields;
    }

    private RelNode handleAllFieldsProject(Project node, CalcitePlanContext context) {
        if (node.isExcluded()) {
            throw new IllegalArgumentException("Invalid field exclusion: operation would exclude all fields from the result set");
        }
        AllFields allFields = (AllFields)node.getProjectList().getFirst();
        CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
        CalciteRelNodeVisitor.tryToRemoveMetaFields(context, allFields instanceof AllFieldsExcludeMeta);
        return context.relBuilder.peek();
    }

    private List<RexNode> expandProjectFields(List<UnresolvedExpression> projectList, List<String> currentFields, CalcitePlanContext context) {
        ArrayList<RexNode> expandedFields = new ArrayList<RexNode>();
        HashSet<String> addedFields = new HashSet<String>();
        block4: for (UnresolvedExpression expr : projectList) {
            UnresolvedExpression unresolvedExpression;
            Objects.requireNonNull(expr);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Field.class, AllFields.class}, (Object)unresolvedExpression, n)) {
                case 0: {
                    Field field2 = (Field)unresolvedExpression;
                    String fieldName = field2.getField().toString();
                    if (WildcardUtils.containsWildcard(fieldName)) {
                        List<String> matchingFields = WildcardUtils.expandWildcardPattern(fieldName, currentFields).stream().filter(f -> !this.isMetadataField((String)f)).filter(addedFields::add).toList();
                        if (matchingFields.isEmpty()) continue block4;
                        matchingFields.forEach(f -> expandedFields.add(context.relBuilder.field((String)f)));
                        break;
                    }
                    if (!addedFields.add(fieldName)) continue block4;
                    expandedFields.add(this.rexVisitor.analyze(field2, context));
                    break;
                }
                case 1: {
                    AllFields ignored = (AllFields)unresolvedExpression;
                    currentFields.stream().filter(field -> !this.isMetadataField((String)field)).filter(addedFields::add).forEach(field -> expandedFields.add(context.relBuilder.field((String)field)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected expression type in project list: " + expr.getClass().getSimpleName());
                }
            }
        }
        if (expandedFields.isEmpty()) {
            this.validateWildcardPatterns(projectList, currentFields);
        }
        return expandedFields;
    }

    private void validateExclusion(List<RexNode> fieldsToExclude, List<String> currentFields) {
        Set nonMetaFields = currentFields.stream().filter(field -> !this.isMetadataField((String)field)).collect(Collectors.toSet());
        if (fieldsToExclude.size() >= nonMetaFields.size()) {
            throw new IllegalArgumentException("Invalid field exclusion: operation would exclude all fields from the result set");
        }
    }

    private void validateWildcardPatterns(List<UnresolvedExpression> projectList, List<String> currentFields) {
        String firstWildcardPattern = projectList.stream().filter(expr -> {
            Field field;
            return expr instanceof Field && WildcardUtils.containsWildcard((field = (Field)expr).getField().toString());
        }).map(expr -> ((Field)expr).getField().toString()).findFirst().orElse(null);
        if (firstWildcardPattern != null) {
            throw new IllegalArgumentException(String.format("wildcard pattern [%s] matches no fields", firstWildcardPattern));
        }
    }

    private boolean isMetadataField(String fieldName) {
        return OpenSearchConstants.METADATAFIELD_TYPE_MAP.containsKey(fieldName);
    }

    private static void tryToRemoveNestedFields(CalcitePlanContext context) {
        HashSet<String> allFields = new HashSet<String>(context.relBuilder.peek().getRowType().getFieldNames());
        List<RexNode> duplicatedNestedFields = allFields.stream().filter(field -> {
            int lastDot = field.lastIndexOf(".");
            return -1 != lastDot && allFields.contains(field.substring(0, lastDot));
        }).map(field -> context.relBuilder.field((String)field)).toList();
        if (!duplicatedNestedFields.isEmpty()) {
            CalciteRelNodeVisitor.forceProjectExcept(context.relBuilder, duplicatedNestedFields);
        }
    }

    private static void forceProjectExcept(RelBuilder relBuilder, Iterable<RexNode> expressions) {
        ArrayList<RexNode> allExpressions = new ArrayList<RexNode>(relBuilder.fields());
        HashSet<RexNode> excludeExpressions = new HashSet<RexNode>();
        for (RexNode excludeExp : expressions) {
            if (!excludeExpressions.add(excludeExp)) {
                throw new IllegalArgumentException("Input list contains duplicates. Expression " + String.valueOf(excludeExp) + " exists multiple times.");
            }
            if (allExpressions.remove(excludeExp)) continue;
            throw new IllegalArgumentException("Expression " + excludeExp.toString() + " not found.");
        }
        relBuilder.project(allExpressions, ImmutableList.of(), true);
    }

    private static void tryToRemoveMetaFields(CalcitePlanContext context, boolean excludeByForce) {
        if (excludeByForce || !context.isProjectVisited()) {
            List<String> originalFields = context.relBuilder.peek().getRowType().getFieldNames();
            List<RexNode> metaFieldsRef = originalFields.stream().filter(OpenSearchConstants.METADATAFIELD_TYPE_MAP::containsKey).map(metaField -> context.relBuilder.field((String)metaField)).toList();
            if (!metaFieldsRef.isEmpty() && metaFieldsRef.size() != originalFields.size()) {
                context.relBuilder.projectExcept(metaFieldsRef);
            }
        }
    }

    @Override
    public RelNode visitRename(Rename node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<String> originalNames = context.relBuilder.peek().getRowType().getFieldNames();
        ArrayList<String> newNames = new ArrayList<String>(originalNames);
        for (Map renameMap : node.getRenameList()) {
            if (!(renameMap.getTarget() instanceof Field)) {
                throw new SemanticCheckException(String.format("the target expected to be field, but is %s", renameMap.getTarget()));
            }
            String sourcePattern = ((Field)renameMap.getOrigin()).getField().toString();
            String targetPattern = ((Field)renameMap.getTarget()).getField().toString();
            if (WildcardRenameUtils.isWildcardPattern(sourcePattern) && !WildcardRenameUtils.validatePatternCompatibility(sourcePattern, targetPattern)) {
                throw new SemanticCheckException("Source and target patterns have different wildcard counts");
            }
            List<String> matchingFields = WildcardRenameUtils.matchFieldNames(sourcePattern, newNames);
            for (String fieldName : matchingFields) {
                int fieldIndex;
                String newName = WildcardRenameUtils.applyWildcardTransformation(sourcePattern, targetPattern, fieldName);
                if (newNames.contains(newName) && !newName.equals(fieldName)) {
                    this.removeFieldIfExists(newName, newNames, context);
                }
                if ((fieldIndex = newNames.indexOf(fieldName)) == -1) continue;
                newNames.set(fieldIndex, newName);
            }
            if (!matchingFields.isEmpty() || !newNames.contains(targetPattern)) continue;
            this.removeFieldIfExists(targetPattern, newNames, context);
            context.relBuilder.rename(newNames);
        }
        context.relBuilder.rename(newNames);
        return context.relBuilder.peek();
    }

    private void removeFieldIfExists(String fieldName, List<String> newNames, CalcitePlanContext context) {
        newNames.remove(fieldName);
        context.relBuilder.projectExcept(context.relBuilder.field(fieldName));
    }

    @Override
    public RelNode visitSort(Sort node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List sortList = node.getSortList().stream().map(expr -> {
            RexNode sortField = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            Sort.SortOption sortOption = this.analyzeSortOption(expr.getFieldArgs());
            if (sortOption.getSortOrder() == Sort.SortOrder.DESC) {
                sortField = context.relBuilder.desc(sortField);
            }
            sortField = sortOption.getNullOrder() == Sort.NullOrder.NULL_LAST ? context.relBuilder.nullsLast(sortField) : context.relBuilder.nullsFirst(sortField);
            return sortField;
        }).collect(Collectors.toList());
        context.relBuilder.sort(sortList);
        if (node.getCount() != 0) {
            context.relBuilder.limit(0, node.getCount());
        }
        return context.relBuilder.peek();
    }

    private Sort.SortOption analyzeSortOption(List<Argument> fieldArgs) {
        Boolean asc = (Boolean)fieldArgs.get(0).getValue().getValue();
        Optional<Argument> nullFirst = fieldArgs.stream().filter(option -> "nullFirst".equals(option.getArgName())).findFirst();
        if (nullFirst.isPresent()) {
            Boolean isNullFirst = (Boolean)nullFirst.get().getValue().getValue();
            return new Sort.SortOption(asc != false ? Sort.SortOrder.ASC : Sort.SortOrder.DESC, isNullFirst != false ? Sort.NullOrder.NULL_FIRST : Sort.NullOrder.NULL_LAST);
        }
        return asc != false ? Sort.SortOption.DEFAULT_ASC : Sort.SortOption.DEFAULT_DESC;
    }

    @Override
    public RelNode visitHead(Head node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.limit(node.getFrom(), node.getSize());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitReverse(Reverse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().rowsTo(RexWindowBounds.CURRENT_ROW).as(REVERSE_ROW_NUM);
        context.relBuilder.projectPlus(rowNumber);
        context.relBuilder.sort(context.relBuilder.desc(context.relBuilder.field(REVERSE_ROW_NUM)));
        context.relBuilder.projectExcept(context.relBuilder.field(REVERSE_ROW_NUM));
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitBin(Bin node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode fieldExpr = this.rexVisitor.analyze(node.getField(), context);
        String fieldName = BinUtils.extractFieldName(node);
        RexNode binExpression = BinUtils.createBinExpression(node, fieldExpr, context, this.rexVisitor);
        String alias = node.getAlias() != null ? node.getAlias() : fieldName;
        this.projectPlusOverriding(List.of(binExpression), List.of(alias), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitParse(Parse node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        this.buildParseRelNode(node, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitSpath(SPath node, CalcitePlanContext context) {
        return this.visitEval(node.rewriteAsEval(), context);
    }

    @Override
    public RelNode visitPatterns(Patterns node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode showNumberedTokenExpr = this.rexVisitor.analyze(node.getShowNumberedToken(), context);
        Boolean showNumberedToken = Boolean.TRUE.equals(((RexLiteral)showNumberedTokenExpr).getValueAs(Boolean.class));
        if (PatternMethod.SIMPLE_PATTERN.equals((Object)node.getPatternMethod())) {
            Parse parseNode = new Parse(ParseMethod.PATTERNS, node.getSourceField(), node.getArguments().getOrDefault("pattern", AstDSL.stringLiteral("")), node.getArguments());
            this.buildParseRelNode(parseNode, context);
            if (PatternMode.AGGREGATION.equals((Object)node.getPatternMode())) {
                Field patternField = AstDSL.field(node.getAlias());
                List<RelBuilder.AggCall> aggCalls = Stream.of(new Alias("pattern_count", new AggregateFunction(BuiltinFunctionName.COUNT.name(), patternField)), new Alias("sample_logs", new AggregateFunction(BuiltinFunctionName.TAKE.name(), node.getSourceField(), ImmutableList.of(node.getPatternMaxSampleCount())))).map(aggFun -> this.aggVisitor.analyze((UnresolvedExpression)aggFun, context)).toList();
                ArrayList<RexNode> groupByList = new ArrayList<RexNode>();
                groupByList.add(this.rexVisitor.analyze(patternField, context));
                groupByList.addAll(node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList());
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), (Iterable<? extends RelBuilder.AggCall>)aggCalls);
                if (showNumberedToken.booleanValue()) {
                    RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, context.relBuilder.field(node.getAlias()), context.relBuilder.field("sample_logs"));
                    this.flattenParsedPattern(node.getAlias(), parsedNode, context, false, true);
                    this.projectPlusOverriding(List.of(context.relBuilder.field(node.getAlias()), context.relBuilder.field("pattern_count"), context.relBuilder.field("tokens"), context.relBuilder.field("sample_logs")), List.of(node.getAlias(), "pattern_count", "tokens", "sample_logs"), context);
                }
            } else if (showNumberedToken.booleanValue()) {
                RexNode parsedNode = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, context.relBuilder.field(node.getAlias()), this.rexVisitor.analyze(node.getSourceField(), context));
                this.flattenParsedPattern(node.getAlias(), parsedNode, context, false, true);
            }
        } else {
            ArrayList<UnresolvedExpression> funcParamList = new ArrayList<UnresolvedExpression>();
            funcParamList.add(node.getSourceField());
            funcParamList.add(node.getPatternMaxSampleCount());
            funcParamList.add(node.getPatternBufferLimit());
            funcParamList.add(node.getShowNumberedToken());
            funcParamList.addAll(node.getArguments().entrySet().stream().filter(entry -> PatternUtils.VALID_BRAIN_PARAMETERS.contains(entry.getKey())).map(entry -> new Argument((String)entry.getKey(), (Literal)entry.getValue())).sorted(Comparator.comparing(Argument::getArgName)).toList());
            if (PatternMode.LABEL.equals((Object)node.getPatternMode())) {
                RexNode windowNode = this.rexVisitor.analyze(new WindowFunction(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), node.getPartitionByList(), List.of()), context);
                RexNode nestedNode = context.relBuilder.alias(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_PATTERN_PARSER, this.rexVisitor.analyze(node.getSourceField(), context), windowNode, showNumberedTokenExpr), node.getAlias());
                context.relBuilder.projectPlus(nestedNode);
                this.flattenParsedPattern(node.getAlias(), context.relBuilder.field(node.getAlias()), context, false, showNumberedToken);
            } else {
                RelBuilder.AggCall aggCall = this.aggVisitor.analyze(new Function(BuiltinFunctionName.INTERNAL_PATTERN.getName().getFunctionName(), funcParamList), context).as(node.getAlias());
                List<RexNode> groupByList = node.getPartitionByList().stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
                context.relBuilder.aggregate(context.relBuilder.groupKey(groupByList), aggCall);
                this.buildExpandRelNode(context.relBuilder.field(node.getAlias()), node.getAlias(), node.getAlias(), context);
                this.flattenParsedPattern(node.getAlias(), context.relBuilder.field(node.getAlias()), context, true, showNumberedToken);
            }
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitEval(Eval node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        node.getExpressionList().forEach(expr -> {
            boolean containsSubqueryExpression = this.containsSubqueryExpression((Node)expr);
            Holder<@Nullable E> v = Holder.empty();
            if (containsSubqueryExpression) {
                context.relBuilder.variable(v::set);
                context.pushCorrelVar((RexCorrelVariable)v.get());
            }
            RexNode eval = this.rexVisitor.analyze((UnresolvedExpression)expr, context);
            if (containsSubqueryExpression) {
                context.relBuilder.project(Iterables.concat(context.relBuilder.fields(), ImmutableList.of(eval)), ImmutableList.of(), false, ImmutableList.of(((RexCorrelVariable)v.get()).id));
                context.popCorrelVar();
            } else {
                String alias = ((RexLiteral)((RexCall)eval).getOperands().get(1)).getValueAs(String.class);
                this.projectPlusOverriding(List.of(eval), List.of(alias), context);
            }
        });
        return context.relBuilder.peek();
    }

    private void projectPlusOverriding(List<RexNode> newFields, List<String> newNames, CalcitePlanContext context) {
        List<String> originalFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<RexNode> toOverrideList = originalFieldNames.stream().filter(newNames::contains).map(a -> context.relBuilder.field((String)a)).toList();
        context.relBuilder.projectPlus(newFields);
        if (!toOverrideList.isEmpty()) {
            context.relBuilder.projectExcept(toOverrideList);
        }
        List<String> currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        int length = currentFields.size();
        ArrayList<String> expectedRenameFields = new ArrayList<String>(currentFields.subList(0, length - newNames.size()));
        expectedRenameFields.addAll(newNames);
        context.relBuilder.rename(expectedRenameFields);
    }

    private List<List<RexInputRef>> extractInputRefList(List<RelBuilder.AggCall> aggCalls) {
        return aggCalls.stream().map(RelBuilder.AggCall::over).map(RelBuilder.OverCall::toRex).map(node -> PlanUtils.getRexCall(node, this::isCountField)).map(list -> list.isEmpty() ? null : (RexCall)list.getFirst()).map(PlanUtils::getInputRefs).toList();
    }

    private boolean isCountField(RexCall call) {
        return call.isA(SqlKind.COUNT) && call.getOperands().size() == 1 && call.getOperands().get(0) instanceof RexInputRef;
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregateWithTrimming(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context) {
        Pair<List<RexNode>, List<RelBuilder.AggCall>> resolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        List<RexNode> resolvedGroupByList = resolved.getLeft();
        List<RelBuilder.AggCall> resolvedAggCallList = resolved.getRight();
        if (resolvedGroupByList.isEmpty()) {
            List<Object> distinctRefsOfCounts;
            List<List<RexInputRef>> refsPerCount = this.extractInputRefList(resolvedAggCallList);
            RelNode relNode = context.relBuilder.peek();
            if (relNode instanceof org.apache.calcite.rel.core.Project) {
                org.apache.calcite.rel.core.Project project = (org.apache.calcite.rel.core.Project)relNode;
                List<RexNode> mappedInProject = refsPerCount.stream().flatMap(Collection::stream).map(ref -> project.getProjects().get(ref.getIndex())).toList();
                distinctRefsOfCounts = mappedInProject.stream().allMatch(RexInputRef.class::isInstance) ? mappedInProject.stream().map(RexInputRef.class::cast).distinct().toList() : List.of();
            } else {
                distinctRefsOfCounts = refsPerCount.stream().flatMap(Collection::stream).distinct().toList();
            }
            if (distinctRefsOfCounts.size() == 1 && refsPerCount.stream().noneMatch(List::isEmpty)) {
                context.relBuilder.filter(context.relBuilder.isNotNull((RexNode)distinctRefsOfCounts.getFirst()));
            }
        }
        ArrayList<RexInputRef> trimmedRefs = new ArrayList<RexInputRef>();
        trimmedRefs.addAll(PlanUtils.getInputRefs(resolvedGroupByList));
        trimmedRefs.addAll(PlanUtils.getInputRefsFromAggCall(resolvedAggCallList));
        context.relBuilder.project(trimmedRefs);
        Pair<List<RexNode>, List<RelBuilder.AggCall>> reResolved = this.resolveAttributesForAggregation(groupExprList, aggExprList, context);
        context.relBuilder.aggregate(context.relBuilder.groupKey((Iterable<? extends RexNode>)reResolved.getLeft()), (Iterable<? extends RelBuilder.AggCall>)reResolved.getRight());
        return Pair.of(reResolved.getLeft(), reResolved.getRight());
    }

    private Pair<List<RexNode>, List<RelBuilder.AggCall>> resolveAttributesForAggregation(List<UnresolvedExpression> groupExprList, List<UnresolvedExpression> aggExprList, CalcitePlanContext context) {
        List<RelBuilder.AggCall> aggCallList = aggExprList.stream().map(expr -> this.aggVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        List<RexNode> groupByList = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
        return Pair.of(groupByList, aggCallList);
    }

    @Override
    public RelNode visitAggregation(Aggregation node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<UnresolvedExpression> aggExprList = node.getAggExprList();
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>();
        UnresolvedExpression span = node.getSpan();
        if (Objects.nonNull(span)) {
            groupExprList.add(span);
            List<RexNode> timeSpanFilters = this.getTimeSpanField(span).stream().map(f -> this.rexVisitor.analyze((UnresolvedExpression)f, context)).map(context.relBuilder::isNotNull).toList();
            if (!timeSpanFilters.isEmpty()) {
                context.relBuilder.filter(timeSpanFilters);
            }
        }
        groupExprList.addAll(node.getGroupExprList());
        Argument.ArgumentMap statsArgs = Argument.ArgumentMap.of(node.getArgExprList());
        Boolean bucketNullable = (Boolean)statsArgs.getOrDefault("bucket_nullable", Literal.TRUE).getValue();
        boolean toAddHintsOnAggregate = false;
        if (!(bucketNullable.booleanValue() || groupExprList.isEmpty() || groupExprList.size() == 1 && this.getTimeSpanField(span).isPresent())) {
            toAddHintsOnAggregate = true;
            List<RexNode> groupByList = groupExprList.stream().map(expr -> this.rexVisitor.analyze((UnresolvedExpression)expr, context)).toList();
            context.relBuilder.filter(PlanUtils.getSelectColumns(groupByList).stream().map(context.relBuilder::field).map(context.relBuilder::isNotNull).toList());
        }
        Pair<List<RexNode>, List<RelBuilder.AggCall>> aggregationAttributes = this.aggregateWithTrimming(groupExprList, aggExprList, context);
        if (toAddHintsOnAggregate) {
            RelHint statHits = RelHint.builder("stats_args").hintOption("bucket_nullable", "false").build();
            assert (context.relBuilder.peek() instanceof LogicalAggregate) : "Stats hits should be added to LogicalAggregate";
            context.relBuilder.hints(statHits);
            context.relBuilder.getCluster().setHintStrategies(HintStrategyTable.builder().hintStrategy("stats_args", (hint, rel) -> rel instanceof LogicalAggregate).build());
        }
        ImmutableList<RexNode> outputFields = context.relBuilder.fields();
        int numOfOutputFields = outputFields.size();
        int numOfAggList = aggExprList.size();
        ArrayList reordered = new ArrayList(numOfOutputFields);
        List aggRexList = outputFields.subList(numOfOutputFields - numOfAggList, numOfOutputFields);
        reordered.addAll(aggRexList);
        List<RexNode> aliasedGroupByList = aggregationAttributes.getLeft().stream().map(this::extractAliasLiteral).flatMap(Optional::stream).map(ref -> ref.getValueAs(String.class)).map(context.relBuilder::field).map(f -> f).toList();
        reordered.addAll(aliasedGroupByList);
        context.relBuilder.project(reordered);
        return context.relBuilder.peek();
    }

    private Optional<UnresolvedExpression> getTimeSpanField(UnresolvedExpression expr) {
        Span span;
        if (Objects.isNull(expr)) {
            return Optional.empty();
        }
        if (expr instanceof Span && SpanUnit.isTimeUnit((span = (Span)expr).getUnit())) {
            return Optional.of(span.getField());
        }
        if (expr instanceof Alias) {
            Alias alias = (Alias)expr;
            return this.getTimeSpanField(alias.getDelegated());
        }
        return Optional.empty();
    }

    private Optional<RexLiteral> extractAliasLiteral(RexNode node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node.getKind() == SqlKind.AS) {
            return Optional.of((RexLiteral)((RexCall)node).getOperands().get(1));
        }
        return Optional.empty();
    }

    @Override
    public RelNode visitJoin(Join node, CalcitePlanContext context) {
        List<UnresolvedPlan> children = node.getChildren();
        children.forEach(c -> this.analyze((UnresolvedPlan)c, context));
        if (node.getJoinCondition().isEmpty()) {
            List<String> leftColumns = context.relBuilder.peek(1).getRowType().getFieldNames();
            List<String> rightColumns = context.relBuilder.peek().getRowType().getFieldNames();
            List<String> duplicatedFieldNames = leftColumns.stream().filter(rightColumns::contains).toList();
            RexNode joinCondition = node.getJoinFields().isPresent() ? node.getJoinFields().get().stream().map(field -> CalciteRelNodeVisitor.buildJoinConditionByFieldName(context, field.getField().toString())).reduce(context.rexBuilder::and).orElse(context.relBuilder.literal(true)) : duplicatedFieldNames.stream().map(fieldName -> CalciteRelNodeVisitor.buildJoinConditionByFieldName(context, fieldName)).reduce(context.rexBuilder::and).orElse(context.relBuilder.literal(true));
            if (node.getJoinType() == Join.JoinType.SEMI || node.getJoinType() == Join.JoinType.ANTI) {
                context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
                return context.relBuilder.peek();
            }
            List<RexNode> toBeRemovedFields = node.getArgumentMap().get("overwrite") == null || node.getArgumentMap().get("overwrite").equals(Literal.TRUE) ? duplicatedFieldNames.stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList() : duplicatedFieldNames.stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            Literal max = node.getArgumentMap().get("max");
            if (max != null && !max.equals(Literal.ZERO)) {
                Integer allowedDuplication = (Integer)max.getValue();
                if (allowedDuplication < 0) {
                    throw new SemanticCheckException("max option must be a positive integer");
                }
                List<RexNode> dedupeFields = node.getJoinFields().isPresent() ? node.getJoinFields().get().stream().map(a -> context.relBuilder.field(a.getField().toString())).toList() : duplicatedFieldNames.stream().map(a -> context.relBuilder.field((String)a)).toList();
                CalciteRelNodeVisitor.buildDedupNotNull(context, dedupeFields, allowedDuplication);
            }
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
            if (!toBeRemovedFields.isEmpty()) {
                context.relBuilder.projectExcept(toBeRemovedFields);
            }
            return context.relBuilder.peek();
        }
        RexNode joinCondition = node.getJoinCondition().map(c -> this.rexVisitor.analyzeJoinCondition((UnresolvedExpression)c, context)).orElse(context.relBuilder.literal(true));
        if (node.getJoinType() == Join.JoinType.SEMI || node.getJoinType() == Join.JoinType.ANTI) {
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
        } else {
            List<String> leftColumns = context.relBuilder.peek(1).getRowType().getFieldNames();
            List<String> rightColumns = context.relBuilder.peek().getRowType().getFieldNames();
            List<String> rightTableName = PlanUtils.findTable(context.relBuilder.peek()).getQualifiedName();
            String rightTableQualifiedName = rightTableName.getLast();
            List<String> rightColumnsWithAliasIfConflict = rightColumns.stream().map(col -> leftColumns.contains(col) ? node.getRightAlias().map(a -> a + "." + col).orElse(rightTableQualifiedName + "." + col) : col).toList();
            Literal max = node.getArgumentMap().get("max");
            if (max != null && !max.equals(Literal.ZERO)) {
                Integer allowedDuplication = (Integer)max.getValue();
                if (allowedDuplication < 0) {
                    throw new SemanticCheckException("max option must be a positive integer");
                }
                List<RexNode> dedupeFields = this.getRightColumnsInJoinCriteria(context.relBuilder, joinCondition);
                CalciteRelNodeVisitor.buildDedupNotNull(context, dedupeFields, allowedDuplication);
            }
            context.relBuilder.join(JoinAndLookupUtils.translateJoinType(node.getJoinType()), joinCondition);
            JoinAndLookupUtils.renameToExpectedFields(rightColumnsWithAliasIfConflict, leftColumns.size(), context);
        }
        return context.relBuilder.peek();
    }

    private List<RexNode> getRightColumnsInJoinCriteria(RelBuilder relBuilder, RexNode joinCondition) {
        int stackSize = relBuilder.size();
        final int leftFieldCount = relBuilder.peek(stackSize - 1).getRowType().getFieldCount();
        RelNode right = relBuilder.peek(stackSize - 2);
        List<String> allColumnNamesOfRight = right.getRowType().getFieldNames();
        final ArrayList rightColumnIndexes = new ArrayList();
        joinCondition.accept(new RexVisitorImpl<Void>(this, true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (inputRef.getIndex() >= leftFieldCount) {
                    rightColumnIndexes.add(inputRef.getIndex() - leftFieldCount);
                }
                return (Void)super.visitInputRef(inputRef);
            }
        });
        return rightColumnIndexes.stream().map(allColumnNamesOfRight::get).map(n -> relBuilder.field((String)n)).toList();
    }

    private static RexNode buildJoinConditionByFieldName(CalcitePlanContext context, String fieldName) {
        RexNode lookupKey = JoinAndLookupUtils.analyzeFieldsForLookUp(fieldName, false, context);
        RexNode sourceKey = JoinAndLookupUtils.analyzeFieldsForLookUp(fieldName, true, context);
        return context.rexBuilder.equals(sourceKey, lookupKey);
    }

    @Override
    public RelNode visitSubqueryAlias(SubqueryAlias node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        context.relBuilder.as(node.getAlias());
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitLookup(Lookup node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<String> sourceFieldsNames = context.relBuilder.peek().getRowType().getFieldNames();
        this.analyze(node.getLookupRelation(), context);
        JoinAndLookupUtils.addProjectionIfNecessary(node, context);
        List<String> lookupTableFieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        List<String> toBeRemovedLookupFieldNames = node.getMappingAliasMap().keySet().stream().filter(k -> !node.getOutputAliasMap().containsKey(k)).toList();
        List<String> providedFieldNames = lookupTableFieldNames.stream().filter(k -> !toBeRemovedLookupFieldNames.contains(k)).toList();
        List<RexNode> toBeRemovedLookupFields = toBeRemovedLookupFieldNames.stream().map(d -> context.relBuilder.field(2, 1, (String)d)).toList();
        ArrayList<RexNode> toBeRemovedFields = new ArrayList<RexNode>(toBeRemovedLookupFields);
        java.util.Map<String, String> duplicatedFieldNamesMap = JoinAndLookupUtils.findDuplicatedFields(node, sourceFieldsNames, providedFieldNames);
        List<RexNode> duplicatedSourceFields = duplicatedFieldNamesMap.keySet().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, true, context)).toList();
        toBeRemovedFields.addAll(duplicatedSourceFields);
        List<String> expectedProvidedFieldNames = providedFieldNames.stream().map(k -> node.getOutputAliasMap().getOrDefault(k, (String)k)).toList();
        ArrayList<RexNode> newCoalesceList = new ArrayList<RexNode>();
        if (!duplicatedFieldNamesMap.isEmpty() && node.getOutputStrategy() == Lookup.OutputStrategy.APPEND) {
            List<RexNode> duplicatedProvidedFields = duplicatedFieldNamesMap.values().stream().map(field -> JoinAndLookupUtils.analyzeFieldsForLookUp(field, false, context)).toList();
            for (int i = 0; i < duplicatedProvidedFields.size(); ++i) {
                newCoalesceList.add(context.rexBuilder.coalesce(duplicatedSourceFields.get(i), duplicatedProvidedFields.get(i)));
            }
            toBeRemovedFields.addAll(duplicatedProvidedFields);
            ArrayList<String> newExpectedFieldNames = new ArrayList<String>(expectedProvidedFieldNames.stream().filter(k -> !duplicatedFieldNamesMap.containsKey(k)).toList());
            newExpectedFieldNames.addAll(duplicatedFieldNamesMap.keySet());
            expectedProvidedFieldNames = newExpectedFieldNames;
        }
        JoinAndLookupUtils.addJoinForLookUp(node, context);
        if (!newCoalesceList.isEmpty()) {
            context.relBuilder.projectPlus(newCoalesceList);
        }
        if (!toBeRemovedFields.isEmpty()) {
            context.relBuilder.projectExcept(toBeRemovedFields);
        }
        JoinAndLookupUtils.renameToExpectedFields(expectedProvidedFieldNames, sourceFieldsNames.size() - duplicatedSourceFields.size(), context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitDedupe(Dedupe node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<Argument> options = node.getOptions();
        Integer allowedDuplication = (Integer)options.get(0).getValue().getValue();
        Boolean keepEmpty = (Boolean)options.get(1).getValue().getValue();
        Boolean consecutive = (Boolean)options.get(2).getValue().getValue();
        if (allowedDuplication <= 0) {
            throw new IllegalArgumentException("Number of duplicate events must be greater than 0");
        }
        if (consecutive.booleanValue()) {
            throw new CalciteUnsupportedException("Consecutive deduplication is unsupported in Calcite");
        }
        List<RexNode> dedupeFields = node.getFields().stream().map(f -> this.rexVisitor.analyze((UnresolvedExpression)f, context)).toList();
        if (keepEmpty.booleanValue()) {
            CalciteRelNodeVisitor.buildDedupOrNull(context, dedupeFields, allowedDuplication);
        } else {
            CalciteRelNodeVisitor.buildDedupNotNull(context, dedupeFields, allowedDuplication);
        }
        return context.relBuilder.peek();
    }

    private static void buildDedupOrNull(CalcitePlanContext context, List<RexNode> dedupeFields, Integer allowedDuplication) {
        RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_dedup_");
        context.relBuilder.projectPlus(rowNumber);
        RexInputRef _row_number_dedup_ = context.relBuilder.field("_row_number_dedup_");
        RexNode[] rexNodeArray = new RexNode[1];
        RexNode[] rexNodeArray2 = new RexNode[2];
        rexNodeArray2[0] = context.relBuilder.or(dedupeFields.stream().map(context.relBuilder::isNull).toList());
        rexNodeArray2[1] = context.relBuilder.lessThanOrEqual(_row_number_dedup_, context.relBuilder.literal(allowedDuplication));
        rexNodeArray[0] = context.relBuilder.or(rexNodeArray2);
        context.relBuilder.filter(rexNodeArray);
        context.relBuilder.projectExcept(_row_number_dedup_);
    }

    private static void buildDedupNotNull(CalcitePlanContext context, List<RexNode> dedupeFields, Integer allowedDuplication) {
        RexNode[] rexNodeArray = new RexNode[1];
        rexNodeArray[0] = context.relBuilder.and(dedupeFields.stream().map(context.relBuilder::isNotNull).toList());
        context.relBuilder.filter(rexNodeArray);
        RexNode rowNumber = context.relBuilder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.ROW_NUMBER, new RexNode[0]).over().partitionBy(dedupeFields).orderBy(dedupeFields).rowsTo(RexWindowBounds.CURRENT_ROW).as("_row_number_dedup_");
        context.relBuilder.projectPlus(rowNumber);
        RexInputRef _row_number_dedup_ = context.relBuilder.field("_row_number_dedup_");
        context.relBuilder.filter(context.relBuilder.lessThanOrEqual(_row_number_dedup_, context.relBuilder.literal(allowedDuplication)));
        context.relBuilder.projectExcept(_row_number_dedup_);
    }

    @Override
    public RelNode visitWindow(Window node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        List<RexNode> overExpressions = node.getWindowFunctionList().stream().map(w -> this.rexVisitor.analyze((UnresolvedExpression)w, context)).toList();
        context.relBuilder.projectPlus(overExpressions);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitFillNull(FillNull node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        if (node.getFields().size() != new HashSet<String>(node.getFields().stream().map(f -> f.getField().toString()).toList()).size()) {
            throw new IllegalArgumentException("The field list cannot be duplicated in fillnull");
        }
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        List<RelDataTypeField> fieldsList = context.relBuilder.peek().getRowType().getFieldList();
        for (RelDataTypeField field : fieldsList) {
            RexInputRef fieldRef = context.rexBuilder.makeInputRef(field.getType(), field.getIndex());
            boolean toReplace = false;
            for (Pair<Field, UnresolvedExpression> pair : node.getReplacementPairs()) {
                if (!field.getName().equalsIgnoreCase(pair.getLeft().getField().toString())) continue;
                RexNode replacement = this.rexVisitor.analyze(pair.getRight(), context);
                RexNode coalesce = context.rexBuilder.coalesce(fieldRef, replacement);
                RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
                projects.add(coalesceWithAlias);
                toReplace = true;
                break;
            }
            if (!toReplace && node.getReplacementForAll().isEmpty()) {
                projects.add(fieldRef);
                continue;
            }
            if (!node.getReplacementForAll().isPresent()) continue;
            RexNode replacement = this.rexVisitor.analyze(node.getReplacementForAll().get(), context);
            RexNode coalesce = context.rexBuilder.coalesce(fieldRef, replacement);
            RexNode coalesceWithAlias = context.relBuilder.alias(coalesce, field.getName());
            projects.add(coalesceWithAlias);
        }
        context.relBuilder.project(projects);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppendCol(AppendCol node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        RexNode mainRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(context.relBuilder.alias(mainRowNumber, "_row_number_main_"));
        UnresolvedPlan relation = PlanUtils.getRelation(node);
        PlanUtils.transformPlanToAttachChild(node.getSubSearch(), relation);
        node.getSubSearch().accept(this, context);
        RexNode subsearchRowNumber = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), List.of(), List.of(), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(context.relBuilder.alias(subsearchRowNumber, "_row_number_subsearch_"));
        List<String> subsearchFields = context.relBuilder.peek().getRowType().getFieldNames();
        List<String> mainFields = context.relBuilder.peek(1).getRowType().getFieldNames();
        if (!node.isOverride()) {
            List<String> subsearchProjectList = subsearchFields.stream().filter(r -> !mainFields.contains(r)).toList();
            context.relBuilder.project(context.relBuilder.fields((Iterable<String>)subsearchProjectList));
        }
        RexNode joinCondition = context.relBuilder.equals(context.relBuilder.field(2, 0, "_row_number_main_"), context.relBuilder.field(2, 1, "_row_number_subsearch_"));
        context.relBuilder.join(JoinAndLookupUtils.translateJoinType(Join.JoinType.FULL), joinCondition);
        if (!node.isOverride()) {
            context.relBuilder.projectExcept(List.of(context.relBuilder.field("_row_number_main_"), context.relBuilder.field("_row_number_subsearch_")));
            return context.relBuilder.peek();
        }
        ArrayList<RexNode> finalProjections = new ArrayList<RexNode>();
        ArrayList<String> finalFieldNames = new ArrayList<String>();
        int mainFieldCount = mainFields.size();
        Set duplicatedFields = mainFields.stream().filter(subsearchFields::contains).collect(Collectors.toSet());
        RexNode caseCondition = context.relBuilder.equals(context.relBuilder.field("_row_number_main_"), context.relBuilder.field("_row_number_subsearch_"));
        for (int mainFieldIndex = 0; mainFieldIndex < mainFields.size(); ++mainFieldIndex) {
            String mainFieldName = mainFields.get(mainFieldIndex);
            if (mainFieldName.equals("_row_number_main_")) continue;
            finalFieldNames.add(mainFieldName);
            if (duplicatedFields.contains(mainFieldName)) {
                int subsearchFieldIndex = mainFieldCount + subsearchFields.indexOf(mainFieldName);
                RexNode caseExpr = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, caseCondition, context.relBuilder.field(subsearchFieldIndex), context.relBuilder.field(mainFieldIndex));
                finalProjections.add(caseExpr);
                continue;
            }
            finalProjections.add(context.relBuilder.field(mainFieldIndex));
        }
        for (int subsearchFieldIndex = 0; subsearchFieldIndex < subsearchFields.size(); ++subsearchFieldIndex) {
            String subsearchFieldName = subsearchFields.get(subsearchFieldIndex);
            if (subsearchFieldName.equals("_row_number_subsearch_") || duplicatedFields.contains(subsearchFieldName)) continue;
            finalProjections.add(context.relBuilder.field(mainFieldCount + subsearchFieldIndex));
            finalFieldNames.add(subsearchFieldName);
        }
        context.relBuilder.project(finalProjections, finalFieldNames);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAppend(Append node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        UnresolvedPlan prunedSubSearch = node.getSubSearch().accept(new EmptySourcePropagateVisitor(), null);
        prunedSubSearch.accept(this, context);
        RelNode subsearchNode = context.relBuilder.build();
        RelNode mainNode = context.relBuilder.build();
        List<RelDataTypeField> mainFields = mainNode.getRowType().getFieldList();
        List<RelDataTypeField> subsearchFields = subsearchNode.getRowType().getFieldList();
        java.util.Map<String, RelDataTypeField> subsearchFieldMap = subsearchFields.stream().map(typeField -> Pair.of(typeField.getName(), typeField)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        boolean[] isSelected = new boolean[subsearchFields.size()];
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RexNode> mainUnionProjects = new ArrayList<RexNode>();
        ArrayList<RexNode> subsearchUnionProjects = new ArrayList<RexNode>();
        for (int i = 0; i < mainFields.size(); ++i) {
            mainUnionProjects.add(context.rexBuilder.makeInputRef(mainNode, i));
            RelDataTypeField mainField = mainFields.get(i);
            RelDataTypeField subsearchField = subsearchFieldMap.get(mainField.getName());
            names.add(mainField.getName());
            if (subsearchFieldMap.containsKey(mainField.getName()) && subsearchField != null && subsearchField.getType().equals(mainField.getType())) {
                subsearchUnionProjects.add(context.rexBuilder.makeInputRef(subsearchNode, subsearchField.getIndex()));
                isSelected[subsearchField.getIndex()] = true;
                continue;
            }
            subsearchUnionProjects.add(context.rexBuilder.makeNullLiteral(mainField.getType()));
        }
        for (int j = 0; j < subsearchFields.size(); ++j) {
            RelDataTypeField subsearchField = subsearchFields.get(j);
            if (isSelected[j]) continue;
            mainUnionProjects.add(context.rexBuilder.makeNullLiteral(subsearchField.getType()));
            subsearchUnionProjects.add(context.rexBuilder.makeInputRef(subsearchNode, j));
            names.add(subsearchField.getName());
        }
        List<String> uniqNames = SqlValidatorUtil.uniquify(names, SqlValidatorUtil.EXPR_SUGGESTER, true);
        RelNode projectedMainNode = context.relBuilder.push(mainNode).project(mainUnionProjects, uniqNames).build();
        RelNode projectedSubsearchNode = context.relBuilder.push(subsearchNode).project(subsearchUnionProjects, uniqNames).build();
        context.relBuilder.push(projectedMainNode);
        context.relBuilder.push(projectedSubsearchNode);
        context.relBuilder.union(true);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitAD(AD node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("AD command is unsupported in Calcite");
    }

    @Override
    public RelNode visitCloseCursor(CloseCursor closeCursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Close cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitFetchCursor(FetchCursor cursor, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Fetch cursor operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitML(ML node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("ML command is unsupported in Calcite");
    }

    @Override
    public RelNode visitPaginate(Paginate paginate, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Paginate operation is unsupported in Calcite");
    }

    @Override
    public RelNode visitKmeans(Kmeans node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Kmeans command is unsupported in Calcite");
    }

    @Override
    public RelNode visitRareTopN(RareTopN node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        Argument.ArgumentMap arguments2 = Argument.ArgumentMap.of(node.getArguments());
        String countFieldName = (String)arguments2.get("countField").getValue();
        if (context.relBuilder.peek().getRowType().getFieldNames().contains(countFieldName)) {
            throw new IllegalArgumentException("Field `" + countFieldName + "` is existed, change the count field by setting countfield='xyz'");
        }
        ArrayList<UnresolvedExpression> groupExprList = new ArrayList<UnresolvedExpression>(node.getGroupExprList());
        List<UnresolvedExpression> fieldList = node.getFields().stream().map(f -> f).toList();
        groupExprList.addAll(fieldList);
        List<UnresolvedExpression> aggExprList = List.of(AstDSL.alias(countFieldName, AstDSL.aggregate("count", null)));
        this.aggregateWithTrimming(groupExprList, aggExprList, context);
        List<RexNode> partitionKeys = this.rexVisitor.analyze(node.getGroupExprList(), context);
        RexNode countField = node.getCommandType() == RareTopN.CommandType.TOP ? context.relBuilder.desc(context.relBuilder.field(countFieldName)) : context.relBuilder.field(countFieldName);
        RexNode rowNumberWindowOver = PlanUtils.makeOver(context, BuiltinFunctionName.ROW_NUMBER, null, List.of(), partitionKeys, List.of(countField), WindowFrame.toCurrentRow());
        context.relBuilder.projectPlus(context.relBuilder.alias(rowNumberWindowOver, "_row_number_"));
        Integer N2 = (Integer)arguments2.get("noOfResults").getValue();
        context.relBuilder.filter(context.relBuilder.lessThanOrEqual(context.relBuilder.field("_row_number_"), context.relBuilder.literal(N2)));
        Boolean showCount = (Boolean)arguments2.get("showCount").getValue();
        if (showCount.booleanValue()) {
            context.relBuilder.projectExcept(context.relBuilder.field("_row_number_"));
        } else {
            context.relBuilder.projectExcept(context.relBuilder.field("_row_number_"), context.relBuilder.field(countFieldName));
        }
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitTableFunction(TableFunction node, CalcitePlanContext context) {
        throw new CalciteUnsupportedException("Table function is unsupported in Calcite");
    }

    @Override
    public RelNode visitFlatten(Flatten node, CalcitePlanContext context) {
        List<String> expandedFieldNames;
        this.visitChildren(node, context);
        RelBuilder relBuilder = context.relBuilder;
        String fieldName = node.getField().getField().toString();
        List<RelDataTypeField> fieldsToExpand = relBuilder.peek().getRowType().getFieldList().stream().filter(f -> f.getName().startsWith(fieldName + ".")).toList();
        if (node.getAliases() != null) {
            if (node.getAliases().size() != fieldsToExpand.size()) {
                throw new IllegalArgumentException(String.format("The number of aliases has to match the number of flattened fields. Expected %d (%s), got %d (%s)", fieldsToExpand.size(), fieldsToExpand.stream().map(RelDataTypeField::getName).collect(Collectors.joining(", ")), node.getAliases().size(), String.join((CharSequence)", ", node.getAliases())));
            }
            expandedFieldNames = node.getAliases();
        } else {
            expandedFieldNames = fieldsToExpand.stream().map(RelDataTypeField::getName).map(name -> name.substring(fieldName.length() + 1)).collect(Collectors.toList());
        }
        List expandedFields = Streams.zip(fieldsToExpand.stream(), expandedFieldNames.stream(), (f, n) -> relBuilder.alias(relBuilder.field(f.getName()), (String)n)).collect(Collectors.toList());
        relBuilder.projectPlus(expandedFields);
        return relBuilder.peek();
    }

    private String getValueFunctionName(UnresolvedExpression aggregateFunction) {
        if (!(aggregateFunction instanceof AggregateFunction)) {
            return "value";
        }
        AggregateFunction aggFunc = (AggregateFunction)aggregateFunction;
        String funcName = aggFunc.getFuncName().toLowerCase();
        ArrayList<UnresolvedExpression> args2 = new ArrayList<UnresolvedExpression>();
        if (aggFunc.getField() != null) {
            args2.add(aggFunc.getField());
        }
        if (aggFunc.getArgList() != null) {
            args2.addAll(aggFunc.getArgList());
        }
        if (args2.isEmpty() || funcName.equals("count")) {
            return "count";
        }
        StringBuilder sb = new StringBuilder(funcName).append("(");
        for (int i = 0; i < args2.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (args2.get(i) instanceof Field) {
                sb.append(((Field)args2.get(i)).getField().toString());
                continue;
            }
            sb.append(((UnresolvedExpression)args2.get(i)).toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public RelNode visitTimechart(Timechart node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        UnresolvedExpression spanExpr = node.getBinExpression();
        List<UnresolvedExpression> groupExprList = Arrays.asList(spanExpr);
        if (node.getByField() == null) {
            String valueFunctionName = this.getValueFunctionName(node.getAggregateFunction());
            ArrayList<UnresolvedExpression> simpleGroupExprList = new ArrayList<UnresolvedExpression>();
            simpleGroupExprList.add(new Alias("timestamp", spanExpr));
            List<UnresolvedExpression> simpleAggExprList = List.of(new Alias(valueFunctionName, node.getAggregateFunction()));
            Aggregation aggregation = new Aggregation(simpleAggExprList, Collections.emptyList(), simpleGroupExprList, null, Collections.emptyList());
            RelNode result2 = this.visitAggregation(aggregation, context);
            context.relBuilder.push(result2);
            context.relBuilder.project(context.relBuilder.field("timestamp"), context.relBuilder.field(valueFunctionName));
            context.relBuilder.rename(List.of("@timestamp", valueFunctionName));
            context.relBuilder.sort(context.relBuilder.field(0));
            return context.relBuilder.peek();
        }
        UnresolvedExpression byField = node.getByField();
        String byFieldName = ((Field)byField).getField().toString();
        String valueFunctionName = this.getValueFunctionName(node.getAggregateFunction());
        int limit = Optional.ofNullable(node.getLimit()).orElse(10);
        boolean useOther = Optional.ofNullable(node.getUseOther()).orElse(true);
        try {
            groupExprList = Arrays.asList(spanExpr, byField);
            this.aggregateWithTrimming(groupExprList, List.of(node.getAggregateFunction()), context);
            List<String> fieldNames = context.relBuilder.peek().getRowType().getFieldNames();
            ArrayList<String> renamedFields = new ArrayList<String>(fieldNames);
            renamedFields.set(fieldNames.size() - 2, "@timestamp");
            context.relBuilder.rename(renamedFields);
            ImmutableList<RexNode> outputFields = context.relBuilder.fields();
            ArrayList<RexNode> reordered = new ArrayList<RexNode>();
            reordered.add(context.relBuilder.field("@timestamp"));
            reordered.add(context.relBuilder.field(byFieldName));
            reordered.add((RexNode)outputFields.get(outputFields.size() - 1));
            context.relBuilder.project(reordered);
            if (limit == 0) {
                context.relBuilder.project(context.relBuilder.alias(context.relBuilder.field(0), "@timestamp"), context.relBuilder.alias(context.relBuilder.field(1), byFieldName), context.relBuilder.alias(context.relBuilder.field(2), valueFunctionName));
                context.relBuilder.sort(context.relBuilder.field(0), context.relBuilder.field(1));
                return context.relBuilder.peek();
            }
            RelNode completeResults = context.relBuilder.build();
            RelNode topCategories = this.buildTopCategoriesQuery(completeResults, limit, context);
            return this.buildFinalResultWithOther(completeResults, topCategories, byFieldName, valueFunctionName, useOther, limit, context);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in visitTimechart: " + e.getMessage(), e);
        }
    }

    private RelNode buildTopCategoriesQuery(RelNode completeResults, int limit, CalcitePlanContext context) {
        context.relBuilder.push(completeResults);
        context.relBuilder.filter(context.relBuilder.isNotNull(context.relBuilder.field(1)));
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(1)), context.relBuilder.sum(context.relBuilder.field(2)).as("grand_total"));
        context.relBuilder.sort(context.relBuilder.desc(context.relBuilder.field("grand_total")));
        if (limit > 0) {
            context.relBuilder.limit(0, limit);
        }
        return context.relBuilder.build();
    }

    private RelNode buildFinalResultWithOther(RelNode completeResults, RelNode topCategories, String byFieldName, String valueFunctionName, boolean useOther, int limit, CalcitePlanContext context) {
        if (valueFunctionName.equals("count")) {
            return this.buildZeroFilledResult(completeResults, topCategories, byFieldName, valueFunctionName, useOther, limit, context);
        }
        return this.buildStandardResult(completeResults, topCategories, byFieldName, valueFunctionName, useOther, context);
    }

    private RelNode buildStandardResult(RelNode completeResults, RelNode topCategories, String byFieldName, String valueFunctionName, boolean useOther, CalcitePlanContext context) {
        context.relBuilder.push(completeResults);
        context.relBuilder.push(topCategories);
        context.relBuilder.join(JoinRelType.LEFT, context.relBuilder.equals(context.relBuilder.field(2, 0, 1), context.relBuilder.field(2, 1, 0)));
        int topCategoryFieldIndex = completeResults.getRowType().getFieldCount();
        RexNode categoryExpr = this.createOtherCaseExpression(topCategoryFieldIndex, 1, context);
        context.relBuilder.project(context.relBuilder.alias(context.relBuilder.field(0), "@timestamp"), context.relBuilder.alias(categoryExpr, byFieldName), context.relBuilder.alias(context.relBuilder.field(2), valueFunctionName));
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(0), context.relBuilder.field(1)), context.relBuilder.sum(context.relBuilder.field(2)).as(valueFunctionName));
        this.applyFiltersAndSort(useOther, context);
        return context.relBuilder.peek();
    }

    private RexNode createOtherCaseExpression(int topCategoryFieldIndex, int byIndex, CalcitePlanContext context) {
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, context.relBuilder.isNotNull(context.relBuilder.field(topCategoryFieldIndex)), context.relBuilder.field(byIndex), context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, context.relBuilder.isNull(context.relBuilder.field(byIndex)), context.relBuilder.literal(null), context.relBuilder.literal("OTHER")));
    }

    private void applyFiltersAndSort(boolean useOther, CalcitePlanContext context) {
        if (!useOther) {
            context.relBuilder.filter(context.relBuilder.notEquals(context.relBuilder.field(1), context.relBuilder.literal("OTHER")));
        }
        context.relBuilder.sort(context.relBuilder.field(0), context.relBuilder.field(1));
    }

    private RelNode buildZeroFilledResult(RelNode completeResults, RelNode topCategories, String byFieldName, String valueFunctionName, boolean useOther, int limit, CalcitePlanContext context) {
        context.relBuilder.push(completeResults);
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(0)), new RelBuilder.AggCall[0]);
        RelNode allTimestamps = context.relBuilder.build();
        context.relBuilder.push(completeResults);
        context.relBuilder.push(topCategories);
        context.relBuilder.join(JoinRelType.LEFT, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, context.relBuilder.field(2, 0, 1), context.relBuilder.field(2, 1, 0)));
        int topCategoryFieldIndex = completeResults.getRowType().getFieldCount();
        RexNode categoryExpr = this.createOtherCaseExpression(topCategoryFieldIndex, 1, context);
        context.relBuilder.project(categoryExpr);
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(0)), new RelBuilder.AggCall[0]);
        RelNode allCategories = context.relBuilder.build();
        context.relBuilder.push(allTimestamps);
        context.relBuilder.push(allCategories);
        context.relBuilder.join(JoinRelType.INNER, context.relBuilder.literal(true));
        context.relBuilder.project(context.relBuilder.alias(context.relBuilder.cast(context.relBuilder.field(0), SqlTypeName.TIMESTAMP), "@timestamp"), context.relBuilder.alias(context.relBuilder.field(1), byFieldName), context.relBuilder.alias(context.relBuilder.literal(0), valueFunctionName));
        RelNode zeroFilledCombinations = context.relBuilder.build();
        context.relBuilder.push(completeResults);
        context.relBuilder.push(topCategories);
        context.relBuilder.join(JoinRelType.LEFT, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, context.relBuilder.field(2, 0, 1), context.relBuilder.field(2, 1, 0)));
        int actualTopCategoryFieldIndex = completeResults.getRowType().getFieldCount();
        RexNode actualCategoryExpr = this.createOtherCaseExpression(actualTopCategoryFieldIndex, 1, context);
        context.relBuilder.project(context.relBuilder.alias(context.relBuilder.cast(context.relBuilder.field(0), SqlTypeName.TIMESTAMP), "@timestamp"), context.relBuilder.alias(actualCategoryExpr, byFieldName), context.relBuilder.alias(context.relBuilder.field(2), valueFunctionName));
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(0), context.relBuilder.field(1)), context.relBuilder.sum(context.relBuilder.field(2)).as("actual_count"));
        RelNode actualResults = context.relBuilder.build();
        context.relBuilder.push(actualResults);
        context.relBuilder.push(zeroFilledCombinations);
        context.relBuilder.union(false);
        context.relBuilder.aggregate(context.relBuilder.groupKey(context.relBuilder.field(0), context.relBuilder.field(1)), context.relBuilder.sum(context.relBuilder.field(2)).as(valueFunctionName));
        this.applyFiltersAndSort(useOther, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitTrendline(Trendline node, CalcitePlanContext context) {
        this.visitChildren(node, context);
        node.getSortByField().ifPresent(sortField -> {
            Sort.SortOption sortOption = this.analyzeSortOption(sortField.getFieldArgs());
            RexNode field = this.rexVisitor.analyze((UnresolvedExpression)sortField, context);
            if (sortOption == Sort.SortOption.DEFAULT_DESC) {
                context.relBuilder.sort(context.relBuilder.desc(field));
            } else {
                context.relBuilder.sort(field);
            }
        });
        ArrayList<RexNode> trendlineNodes = new ArrayList<RexNode>();
        ArrayList<String> aliases = new ArrayList<String>();
        node.getComputations().forEach(trendlineComputation -> {
            RexNode field = this.rexVisitor.analyze(trendlineComputation.getDataField(), context);
            context.relBuilder.filter(context.relBuilder.isNotNull(field));
            WindowFrame windowFrame = WindowFrame.of(WindowFrame.FrameType.ROWS, StringUtils.format("%d PRECEDING", trendlineComputation.getNumberOfDataPoints() - 1), "CURRENT ROW");
            RexNode countExpr = PlanUtils.makeOver(context, BuiltinFunctionName.COUNT, null, List.of(), List.of(), List.of(), windowFrame);
            RexNode whenConditionExpr = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ">", countExpr, context.relBuilder.literal(trendlineComputation.getNumberOfDataPoints() - 1));
            RexNode thenExpr = switch (trendlineComputation.getComputationType()) {
                case Trendline.TrendlineType.SMA -> PlanUtils.makeOver(context, BuiltinFunctionName.AVG, field, List.of(), List.of(), List.of(), windowFrame);
                case Trendline.TrendlineType.WMA -> this.buildWmaRexNode(field, trendlineComputation.getNumberOfDataPoints(), windowFrame, context);
                default -> throw new IllegalStateException("Unsupported trendline type");
            };
            RexLiteral elseExpr = context.relBuilder.literal(null);
            ArrayList<RexNode> caseOperands = new ArrayList<RexNode>();
            caseOperands.add(whenConditionExpr);
            caseOperands.add(thenExpr);
            caseOperands.add(elseExpr);
            RexNode trendlineNode = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
            trendlineNodes.add(trendlineNode);
            aliases.add(trendlineComputation.getAlias());
        });
        this.projectPlusOverriding(trendlineNodes, aliases, context);
        return context.relBuilder.peek();
    }

    private RexNode buildWmaRexNode(RexNode field, Integer numberOfDataPoints, WindowFrame windowFrame, CalcitePlanContext context) {
        RexLiteral divisor = context.relBuilder.literal(numberOfDataPoints * (numberOfDataPoints + 1) / 2);
        RexNode divider = context.relBuilder.literal(0);
        for (int i = 1; i <= numberOfDataPoints; ++i) {
            RexNode nthValueExpr = PlanUtils.makeOver(context, BuiltinFunctionName.NTH_VALUE, field, List.of(context.relBuilder.literal(i)), List.of(), List.of(), windowFrame);
            divider = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.PLUS, divider, context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, nthValueExpr, context.relBuilder.literal(i)));
        }
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, divider, context.relBuilder.cast(divisor, SqlTypeName.DOUBLE));
    }

    @Override
    public RelNode visitExpand(Expand expand, CalcitePlanContext context) {
        this.visitChildren(expand, context);
        Field arrayField = expand.getField();
        RexInputRef arrayFieldRex = (RexInputRef)this.rexVisitor.analyze(arrayField, context);
        String alias = expand.getAlias();
        this.buildExpandRelNode(arrayFieldRex, arrayField.getField().toString(), alias, context);
        return context.relBuilder.peek();
    }

    @Override
    public RelNode visitValues(Values values2, CalcitePlanContext context) {
        if (values2.getValues() == null || values2.getValues().isEmpty()) {
            context.relBuilder.values(context.relBuilder.getTypeFactory().builder().build());
            return context.relBuilder.peek();
        }
        throw new CalciteUnsupportedException("Explicit values node is unsupported in Calcite");
    }

    private void buildParseRelNode(Parse node, CalcitePlanContext context) {
        RexNode sourceField = this.rexVisitor.analyze(node.getSourceField(), context);
        ParseMethod parseMethod = node.getParseMethod();
        java.util.Map<String, Literal> arguments2 = node.getArguments();
        String patternValue = (String)node.getPattern().getValue();
        String pattern = ParseMethod.PATTERNS.equals((Object)parseMethod) && Strings.isNullOrEmpty(patternValue) ? "[a-zA-Z0-9]+" : patternValue;
        List<String> groupCandidates = ParseUtils.getNamedGroupCandidates(parseMethod, pattern, arguments2);
        RexNode[] rexNodeList = new RexNode[]{sourceField, context.rexBuilder.makeLiteral(pattern, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)};
        rexNodeList = ParseMethod.PATTERNS.equals((Object)parseMethod) ? ArrayUtils.add(rexNodeList, context.rexBuilder.makeLiteral("<*>", context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)) : ArrayUtils.add(rexNodeList, context.rexBuilder.makeLiteral(parseMethod.getName(), context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true));
        ArrayList<RexNode> newFields = new ArrayList<RexNode>();
        for (String groupCandidate : groupCandidates) {
            RexNode innerRex = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, ParseUtils.BUILTIN_FUNCTION_MAP.get((Object)parseMethod), rexNodeList);
            if (!ParseMethod.PATTERNS.equals((Object)parseMethod)) {
                newFields.add(PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, innerRex, context.rexBuilder.makeLiteral(groupCandidate, context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true)));
                continue;
            }
            RexNode emptyString = context.rexBuilder.makeLiteral("", context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true);
            RexNode isEmptyCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, sourceField, emptyString);
            RexNode isNullCondition = context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, sourceField);
            newFields.add(context.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, isNullCondition, emptyString, isEmptyCondition, emptyString, innerRex));
        }
        this.projectPlusOverriding(newFields, groupCandidates, context);
    }

    private void flattenParsedPattern(String originalPatternResultAlias, RexNode parsedNode, CalcitePlanContext context, boolean flattenPatternAggResult, Boolean showNumberedToken) {
        ArrayList<RexNode> fattenedNodes = new ArrayList<RexNode>();
        ArrayList<String> projectNames = new ArrayList<String>();
        RexNode patternExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, parsedNode, context.rexBuilder.makeLiteral("pattern")), true, true);
        fattenedNodes.add(context.relBuilder.alias(patternExpr, originalPatternResultAlias));
        projectNames.add(originalPatternResultAlias);
        if (flattenPatternAggResult) {
            RexNode patternCountExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, parsedNode, context.rexBuilder.makeLiteral("pattern_count")), true, true);
            fattenedNodes.add(context.relBuilder.alias(patternCountExpr, "pattern_count"));
            projectNames.add("pattern_count");
        }
        if (showNumberedToken.booleanValue()) {
            RexNode tokensExpr = context.rexBuilder.makeCast(UserDefinedFunctionUtils.tokensMap, PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, parsedNode, context.rexBuilder.makeLiteral("tokens")), true, true);
            fattenedNodes.add(context.relBuilder.alias(tokensExpr, "tokens"));
            projectNames.add("tokens");
        }
        if (flattenPatternAggResult) {
            RexNode sampleLogsExpr = context.rexBuilder.makeCast(context.rexBuilder.getTypeFactory().createArrayType(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), -1L), PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, parsedNode, context.rexBuilder.makeLiteral("sample_logs")), true, true);
            fattenedNodes.add(context.relBuilder.alias(sampleLogsExpr, "sample_logs"));
            projectNames.add("sample_logs");
        }
        this.projectPlusOverriding(fattenedNodes, projectNames, context);
    }

    private void buildExpandRelNode(RexInputRef arrayFieldRex, String arrayFieldName, String alias, CalcitePlanContext context) {
        Holder correlVariable = Holder.empty();
        context.relBuilder.variable(correlVariable::set);
        RexNode correlArrayFieldAccess = context.relBuilder.field(context.rexBuilder.makeCorrel(context.relBuilder.peek().getRowType(), ((RexCorrelVariable)correlVariable.get()).id), arrayFieldRex.getIndex());
        RelNode leftNode = context.relBuilder.build();
        RelNode rightNode = context.relBuilder.push(LogicalValues.createOneRow(context.relBuilder.getCluster())).project(List.of(correlArrayFieldAccess), List.of(arrayFieldName)).uncollect(List.of(), false).build();
        context.relBuilder.push(leftNode).push(rightNode).correlate(JoinRelType.INNER, ((RexCorrelVariable)correlVariable.get()).id, List.of(arrayFieldRex)).projectExcept(arrayFieldRex);
        if (alias != null) {
            CalciteRelNodeVisitor.tryToRemoveNestedFields(context);
            RexInputRef expandedField = context.relBuilder.field(arrayFieldName);
            ArrayList<String> names = new ArrayList<String>(context.relBuilder.peek().getRowType().getFieldNames());
            names.set(expandedField.getIndex(), alias);
            context.relBuilder.rename(names);
        }
    }

    private RexNode createOptimizedSedCall(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        if (sedExpression.startsWith("s/")) {
            return this.createOptimizedSubstitution(fieldRex, sedExpression, context);
        }
        if (sedExpression.startsWith("y/")) {
            return this.createOptimizedTransliteration(fieldRex, sedExpression, context);
        }
        throw new RuntimeException("Unsupported sed pattern: " + sedExpression);
    }

    private RexNode createOptimizedSubstitution(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        try {
            if (!sedExpression.matches("s/.+/.*/.*")) {
                throw new IllegalArgumentException("Invalid sed substitution format");
            }
            int firstDelimiter = sedExpression.indexOf(47, 2);
            int secondDelimiter = sedExpression.indexOf(47, firstDelimiter + 1);
            int thirdDelimiter = sedExpression.indexOf(47, secondDelimiter + 1);
            if (firstDelimiter == -1 || secondDelimiter == -1) {
                throw new IllegalArgumentException("Invalid sed substitution format");
            }
            String pattern = sedExpression.substring(2, firstDelimiter);
            String replacement = sedExpression.substring(firstDelimiter + 1, secondDelimiter);
            String flags = secondDelimiter + 1 < sedExpression.length() ? sedExpression.substring(secondDelimiter + 1) : "";
            String javaReplacement = replacement.replaceAll("\\\\(\\d+)", "\\$$1");
            if (flags.isEmpty()) {
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_3, fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement));
            }
            if (flags.matches("[gi]+")) {
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_PG_4, fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement), context.rexBuilder.makeLiteral(flags));
            }
            if (flags.matches("\\d+")) {
                int occurrence = Integer.parseInt(flags);
                return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_REGEXP_REPLACE_5, fieldRex, context.rexBuilder.makeLiteral(pattern), context.rexBuilder.makeLiteral(javaReplacement), context.relBuilder.literal(1), context.relBuilder.literal(occurrence));
            }
            throw new RuntimeException("Unsupported sed flags: " + flags + " in expression: " + sedExpression);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to optimize sed expression: " + sedExpression, e);
        }
    }

    private RexNode createOptimizedTransliteration(RexNode fieldRex, String sedExpression, CalcitePlanContext context) {
        try {
            if (!sedExpression.matches("y/.+/.*/.*")) {
                throw new IllegalArgumentException("Invalid sed transliteration format");
            }
            int firstSlash = sedExpression.indexOf(47, 1);
            int secondSlash = sedExpression.indexOf(47, firstSlash + 1);
            int thirdSlash = sedExpression.indexOf(47, secondSlash + 1);
            if (firstSlash == -1 || secondSlash == -1) {
                throw new IllegalArgumentException("Invalid sed transliteration format");
            }
            String from = sedExpression.substring(firstSlash + 1, secondSlash);
            String to = sedExpression.substring(secondSlash + 1, thirdSlash != -1 ? thirdSlash : sedExpression.length());
            return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_TRANSLATE3, fieldRex, context.rexBuilder.makeLiteral(from), context.rexBuilder.makeLiteral(to));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to optimize sed expression: " + sedExpression, e);
        }
    }
}

