/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

public enum MemoryStrategyType {
    SEMANTIC("SEMANTIC"),
    USER_PREFERENCE("USER_PREFERENCE"),
    SUMMARY("SUMMARY");

    private final String value;

    private MemoryStrategyType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static MemoryStrategyType fromString(String value) {
        if (value == null) {
            return null;
        }
        for (MemoryStrategyType type2 : MemoryStrategyType.values()) {
            if (!type2.value.equalsIgnoreCase(value)) continue;
            return type2;
        }
        throw new IllegalArgumentException("Invalid memory type: " + value + ". Must be SEMANTIC, USER_PREFERENCE, or SUMMARY");
    }

    public String toString() {
        return this.value;
    }
}

