/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.nio;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.nio.support.AbstractAsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.client.nio.HeapBufferedAsyncEntityConsumer;

public class HeapBufferedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<ClassicHttpResponse, byte[]> {
    private static final Log LOGGER = LogFactory.getLog(HeapBufferedAsyncResponseConsumer.class);
    private final int bufferLimit;

    public HeapBufferedAsyncResponseConsumer(int bufferLimit) {
        super(new HeapBufferedAsyncEntityConsumer(bufferLimit));
        this.bufferLimit = bufferLimit;
    }

    public int getBufferLimit() {
        return this.bufferLimit;
    }

    @Override
    public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
    }

    @Override
    protected ClassicHttpResponse buildResult(HttpResponse response, byte[] entity, ContentType contentType) {
        BasicClassicHttpResponse classicResponse = new BasicClassicHttpResponse(response.getCode());
        classicResponse.setVersion(response.getVersion());
        classicResponse.setHeaders(response.getHeaders());
        classicResponse.setReasonPhrase(response.getReasonPhrase());
        if (response.getLocale() != null) {
            classicResponse.setLocale(response.getLocale());
        }
        if (entity != null) {
            String encoding = null;
            try {
                Header contentEncoding = response.getHeader("Content-Encoding");
                if (contentEncoding != null) {
                    encoding = contentEncoding.getValue();
                }
            }
            catch (HttpException ex) {
                LOGGER.debug("Unable to detect content encoding", ex);
            }
            ByteArrayEntity httpEntity = new ByteArrayEntity(entity, contentType, encoding);
            classicResponse.setEntity(httpEntity);
        }
        return classicResponse;
    }
}

