/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.geodesic.Geodesic;
import org.locationtech.proj4j.geodesic.GeodesicData;
import org.locationtech.proj4j.proj.AzimuthalProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class EquidistantAzimuthalProjection
extends AzimuthalProjection {
    private static final double TOL = 1.0E-8;
    private int mode;
    private double[] en;
    private double M1;
    private double N1;
    private double Mp;
    private double He;
    private double G;
    private double sinphi0;
    private double cosphi0;
    private Geodesic geodesic;

    public EquidistantAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public EquidistantAzimuthalProjection(double projectionLatitude, double projectionLongitude) {
        super(projectionLatitude, projectionLongitude);
        this.initialize();
    }

    @Override
    public Object clone() {
        EquidistantAzimuthalProjection p = (EquidistantAzimuthalProjection)super.clone();
        if (this.en != null) {
            p.en = (double[])this.en.clone();
        }
        return p;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            this.mode = this.projectionLatitude < 0.0 ? 2 : 1;
            this.sinphi0 = this.projectionLatitude < 0.0 ? -1.0 : 1.0;
            this.cosphi0 = 0.0;
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 3;
            this.sinphi0 = 0.0;
            this.cosphi0 = 1.0;
        } else {
            this.mode = 4;
            this.sinphi0 = Math.sin(this.projectionLatitude);
            this.cosphi0 = Math.cos(this.projectionLatitude);
        }
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            switch (this.mode) {
                case 1: {
                    this.Mp = ProjectionMath.mlfn(1.5707963267948966, 1.0, 0.0, this.en);
                    break;
                }
                case 2: {
                    this.Mp = ProjectionMath.mlfn(-1.5707963267948966, -1.0, 0.0, this.en);
                    break;
                }
                case 3: 
                case 4: {
                    this.N1 = 1.0 / Math.sqrt(1.0 - this.es * this.sinphi0 * this.sinphi0);
                    this.He = this.e / Math.sqrt(this.one_es);
                    this.G = this.sinphi0 * this.He;
                    this.He *= this.cosphi0;
                    this.geodesic = new Geodesic(this.ellipsoid.getA(), (this.ellipsoid.getA() - this.ellipsoid.getB()) / this.ellipsoid.getA());
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        if (this.spherical) {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lam);
            switch (this.mode) {
                case 3: 
                case 4: {
                    xy.y = this.mode == 3 ? cosphi * coslam : this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (Math.abs(Math.abs(xy.y) - 1.0) < 1.0E-8) {
                        if (xy.y < 0.0) {
                            throw new ProjectionException();
                        }
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    xy.y = Math.acos(xy.y);
                    xy.y /= Math.sin(xy.y);
                    xy.x = xy.y * cosphi * Math.sin(lam);
                    xy.y = xy.y * (this.mode == 3 ? sinphi : this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam);
                    break;
                }
                case 1: {
                    phi = -phi;
                    coslam = -coslam;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-10) {
                        throw new ProjectionException();
                    }
                    xy.y = 1.5707963267948966 + phi;
                    xy.x = xy.y * Math.sin(lam);
                    xy.y *= coslam;
                }
            }
        } else {
            double coslam = Math.cos(lam);
            double cosphi = Math.cos(phi);
            double sinphi = Math.sin(phi);
            switch (this.mode) {
                case 1: {
                    coslam = -coslam;
                }
                case 2: {
                    double rho = Math.abs(this.Mp - ProjectionMath.mlfn(phi, sinphi, cosphi, this.en));
                    xy.x = rho * Math.sin(lam);
                    xy.y = rho * coslam;
                    break;
                }
                case 3: 
                case 4: {
                    if (Math.abs(lam) < 1.0E-10 && Math.abs(phi - this.projectionLatitude) < 1.0E-10) {
                        xy.y = 0.0;
                        xy.x = 0.0;
                        break;
                    }
                    GeodesicData g2 = this.geodesic.Inverse(Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), Math.toDegrees(phi), Math.toDegrees(lam + this.projectionLongitude));
                    double azi1 = Math.toRadians(g2.azi1);
                    xy.x = g2.s12 * Math.sin(azi1) / this.geodesic.EquatorialRadius();
                    xy.y = g2.s12 * Math.cos(azi1) / this.geodesic.EquatorialRadius();
                }
            }
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        if (this.spherical) {
            double d;
            double c_rh = ProjectionMath.distance(x, y);
            if (d > Math.PI) {
                if (c_rh - 1.0E-10 > Math.PI) {
                    throw new ProjectionException();
                }
                c_rh = Math.PI;
            } else if (c_rh < 1.0E-10) {
                lp.y = this.projectionLatitude;
                lp.x = 0.0;
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double sinc = Math.sin(c_rh);
                double cosc = Math.cos(c_rh);
                if (this.mode == 3) {
                    lp.y = ProjectionMath.asin(y * sinc / c_rh);
                    x *= sinc;
                    y = cosc * c_rh;
                } else {
                    lp.y = ProjectionMath.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / c_rh);
                    y = (cosc - this.sinphi0 * Math.sin(lp.y)) * c_rh;
                    x *= sinc * this.cosphi0;
                }
                lp.x = y == 0.0 ? 0.0 : Math.atan2(x, y);
            } else if (this.mode == 1) {
                lp.y = 1.5707963267948966 - c_rh;
                lp.x = Math.atan2(x, -y);
            } else {
                lp.y = c_rh - 1.5707963267948966;
                lp.x = Math.atan2(x, y);
            }
        } else {
            double d;
            double c = ProjectionMath.distance(x, y);
            if (d < 1.0E-10) {
                lp.y = this.projectionLatitude;
                lp.x = 0.0;
                return lp;
            }
            if (this.mode == 4 || this.mode == 3) {
                double x2 = x * this.geodesic.EquatorialRadius();
                double y2 = y * this.geodesic.EquatorialRadius();
                double azi1 = Math.atan2(x2, y2);
                double s12 = Math.sqrt(x2 * x2 + y2 * y2);
                GeodesicData g2 = this.geodesic.Direct(Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), Math.toDegrees(azi1), s12);
                lp.y = Math.toRadians(g2.lat2);
                lp.x = Math.toRadians(g2.lon2);
                lp.x -= this.projectionLongitude;
            } else {
                lp.y = ProjectionMath.inv_mlfn(this.mode == 1 ? this.Mp - c : this.Mp + c, this.es, this.en);
                lp.x = Math.atan2(x, this.mode == 1 ? -y : y);
            }
        }
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Equidistant Azimuthal";
    }
}

