/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.javac;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.util.javac.JavaCompiler;
import org.apache.calcite.util.javac.JavaCompilerArgs;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.commons.compiler.util.resource.MapResourceFinder;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;

public class JaninoCompiler
implements JavaCompiler {
    public final JaninoCompilerArgs args = new JaninoCompilerArgs();
    private @Nullable AccountingClassLoader classLoader;

    @Override
    public void compile() {
        String destdir = Objects.requireNonNull(this.args.destdir, "args.destdir");
        String fullClassName = Objects.requireNonNull(this.args.fullClassName, "args.fullClassName");
        String source2 = Objects.requireNonNull(this.args.source, "args.source");
        ClassLoader parentClassLoader = this.args.getClassLoader();
        if (this.classLoader != null) {
            parentClassLoader = this.classLoader;
        }
        HashMap<String, byte[]> sourceMap = new HashMap<String, byte[]>();
        sourceMap.put(ClassFile.getSourceResourceName(fullClassName), source2.getBytes(StandardCharsets.UTF_8));
        MapResourceFinder sourceFinder = new MapResourceFinder(sourceMap);
        AccountingClassLoader classLoader = this.classLoader = new AccountingClassLoader(parentClassLoader, sourceFinder, null, destdir == null ? null : new File(destdir));
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            classLoader.setDebuggingInfo(true, true, true);
        }
        try {
            classLoader.loadClass(fullClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("while compiling " + fullClassName, ex);
        }
    }

    @Override
    public JavaCompilerArgs getArgs() {
        return this.args;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getAccountingClassLoader();
    }

    private AccountingClassLoader getAccountingClassLoader() {
        return Objects.requireNonNull(this.classLoader, "classLoader is null. Need to call #compile()");
    }

    @Override
    public int getTotalByteCodeSize() {
        return this.getAccountingClassLoader().getTotalByteCodeSize();
    }

    private static class AccountingClassLoader
    extends JavaSourceClassLoader {
        private final @Nullable File destDir;
        private int nBytes;

        AccountingClassLoader(ClassLoader parentClassLoader, ResourceFinder sourceFinder, @Nullable String optionalCharacterEncoding, @Nullable File destDir) {
            super(parentClassLoader, sourceFinder, optionalCharacterEncoding);
            this.destDir = destDir;
        }

        int getTotalByteCodeSize() {
            return this.nBytes;
        }

        @Override
        public @Nullable Map<String, byte[]> generateBytecodes(String name) throws ClassNotFoundException {
            Map<String, byte[]> map = super.generateBytecodes(name);
            if (map == null) {
                return null;
            }
            if (this.destDir != null) {
                try {
                    for (Map.Entry entry : map.entrySet()) {
                        File file = new File(this.destDir, (String)entry.getKey() + ".class");
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write((byte[])entry.getValue());
                        fos.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (Object object : map.values()) {
                byte[] bytes = (byte[])object;
                this.nBytes += bytes.length;
            }
            return map;
        }
    }

    public static class JaninoCompilerArgs
    extends JavaCompilerArgs {
        @Nullable String destdir;
        @Nullable String fullClassName;
        @Nullable String source;

        @Override
        public boolean supportsSetSource() {
            return true;
        }

        @Override
        public void setDestdir(String destdir) {
            super.setDestdir(destdir);
            this.destdir = destdir;
        }

        @Override
        public void setSource(String source2, String fileName) {
            this.source = source2;
            this.addFile(fileName);
        }

        @Override
        public void setFullClassName(String fullClassName) {
            this.fullClassName = fullClassName;
        }
    }
}

