/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;

public class SqlJsonObjectAggAggFunction
extends SqlAggFunction {
    private final SqlJsonConstructorNullClause nullClause;

    public SqlJsonObjectAggAggFunction(SqlKind kind, SqlJsonConstructorNullClause nullClause) {
        super((Object)((Object)kind) + "_" + nullClause.name(), null, kind, ReturnTypes.VARCHAR_2000, (callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            operandTypes[0] = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            operandTypes[1] = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }, OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM, false, false, Optionality.FORBIDDEN);
        this.nullClause = Objects.requireNonNull(nullClause, "nullClause");
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startFunCall("JSON_OBJECTAGG");
        writer.keyword("KEY");
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.keyword("VALUE");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.nullClause.sql);
        writer.endFunCall(frame);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope2, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope2, call);
    }

    public SqlJsonObjectAggAggFunction with(SqlJsonConstructorNullClause nullClause) {
        return this.nullClause == nullClause ? this : new SqlJsonObjectAggAggFunction(this.getKind(), nullClause);
    }

    public SqlJsonConstructorNullClause getNullClause() {
        return this.nullClause;
    }
}

