/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SnowflakeSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.SNOWFLAKE).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.TO_UPPER);
    public static final SqlDialect DEFAULT = new SnowflakeSqlDialect(DEFAULT_CONTEXT);

    public SnowflakeSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case BIT_AND: {
                SqlCall bitAndCall = SqlLibraryOperators.BITAND_AGG.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, bitAndCall, leftPrec, rightPrec);
                break;
            }
            case BIT_OR: {
                SqlCall bitOrCall = SqlLibraryOperators.BITOR_AGG.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, bitOrCall, leftPrec, rightPrec);
                break;
            }
            case CHAR_LENGTH: {
                SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                break;
            }
            case ENDS_WITH: {
                SqlCall endsWithCall = SqlLibraryOperators.ENDSWITH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, endsWithCall, leftPrec, rightPrec);
                break;
            }
            case STARTS_WITH: {
                SqlCall startsWithCall = SqlLibraryOperators.STARTSWITH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, startsWithCall, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public SqlNode rewriteMaxMinExpr(SqlNode aggCall, RelDataType relDataType) {
        return SnowflakeSqlDialect.rewriteMaxMin(aggCall, relDataType);
    }

    public static SqlNode rewriteMaxMin(SqlNode aggCall, RelDataType relDataType) {
        boolean isMax;
        SqlTypeName type2 = relDataType.getSqlTypeName();
        boolean bl = isMax = aggCall.getKind() == SqlKind.MAX;
        if (type2 == SqlTypeName.BOOLEAN) {
            SqlAggFunction op = isMax ? SqlLibraryOperators.BOOLOR_AGG : SqlLibraryOperators.BOOLAND_AGG;
            Object operand = ((SqlBasicCall)aggCall).operand(0);
            return op.createCall(SqlParserPos.ZERO, new SqlNode[]{operand});
        }
        return aggCall;
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }
}

