/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class FireboltSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.FIREBOLT).withIdentifierQuoteString("\"").withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new FireboltSqlDialect(DEFAULT_CONTEXT);
    private static final List<String> RESERVED_KEYWORDS = ImmutableList.copyOf(Arrays.asList("ALL", "ALTER", "AND", "ARRAY", "BETWEEN", "BIGINT", "BOOL", "BOOLEAN", "BOTH", "CASE", "CAST", "CHAR", "CONCAT", "COPY", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DATABASE", "DATE", "DATETIME", "DECIMAL", "DELETE", "DESCRIBE", "DISTINCT", "DOUBLE", "DOUBLECOLON", "DOW", "DOY", "DROP", "EMPTY_IDENTIFIER", "EPOCH", "EXCEPT", "EXECUTE", "EXISTS", "EXPLAIN", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FROM", "FULL", "GENERATE", "GROUP", "HAVING", "IF", "ILIKE", "IN", "INNER", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "IS", "ISNULL", "JOIN", "JOIN_TYPE", "LEADING", "LEFT", "LIKE", "LIMIT", "LIMIT_DISTINCT", "LOCALTIMESTAMP", "LONG", "NATURAL", "NEXT", "NOT", "NULL", "NUMERIC", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECISION", "PREPARE", "PRIMARY", "QUARTER", "RIGHT", "ROW", "ROWS", "SAMPLE", "SELECT", "SET", "SHOW", "TEXT", "TIME", "TIMESTAMP", "TOP", "TRAILING", "TRIM", "TRUE", "TRUNCATE", "UNION", "UNKNOWN_CHAR", "UNNEST", "UNTERMINATED_STRING", "UPDATE", "USING", "VARCHAR", "WEEK", "WHEN", "WHERE", "WITH"));
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");

    public FireboltSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        FireboltSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case ANY_VALUE: 
            case AVG: 
            case COUNT: 
            case MAX: 
            case MIN: 
            case STDDEV_SAMP: 
            case SUM: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean identifierNeedsQuote(String val) {
        return IDENTIFIER_REGEX.matcher(val).matches() || RESERVED_KEYWORDS.contains(val.toUpperCase(Locale.ROOT));
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type2) {
        String castSpec;
        switch (type2.getSqlTypeName()) {
            case TINYINT: 
            case SMALLINT: {
                castSpec = "INT";
                break;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                castSpec = "TIMESTAMP";
                break;
            }
            case CHAR: {
                castSpec = "VARCHAR";
                break;
            }
            case DECIMAL: {
                castSpec = "FLOAT";
                break;
            }
            case REAL: {
                castSpec = "DOUBLE";
                break;
            }
            default: {
                return super.getCastSpec(type2);
            }
        }
        return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec(castSpec, type2.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Override
    public boolean supportsAggregateFunctionFilter() {
        return false;
    }

    @Override
    public boolean supportsFunction(SqlOperator operator, RelDataType type2, List<RelDataType> paramTypes) {
        switch (operator.kind) {
            case LIKE: 
            case EXISTS: {
                return true;
            }
        }
        return super.supportsFunction(operator, type2, paramTypes);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            RelToSqlConverterUtil.specialOperatorByName("SUBSTR").unparse(writer, call, 0, 0);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    @Override
    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        SqlIntervalLiteral.IntervalValue interval = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        writer.keyword("INTERVAL");
        writer.print("'");
        try {
            Long.parseLong(interval.getIntervalLiteral());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Only INT64 is supported as the interval value for Firebolt.");
        }
        writer.literal(interval.getIntervalLiteral());
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
        writer.print("'");
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        String start = FireboltSqlDialect.validate(qualifier.timeUnitRange.startUnit).name();
        if (qualifier.timeUnitRange.endUnit != null) {
            throw new RuntimeException("Range time unit is not supported for Firebolt.");
        }
        writer.keyword(start);
    }

    private static TimeUnit validate(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECOND: 
            case MILLISECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case DAY: 
            case WEEK: 
            case MONTH: 
            case YEAR: 
            case DECADE: 
            case CENTURY: 
            case MILLENNIUM: {
                return timeUnit;
            }
        }
        throw new RuntimeException("Time unit " + (Object)((Object)timeUnit) + " is not supported for Firebolt.");
    }
}

