/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.SocketFactory;

public class SocketFactoryImpl
extends SocketFactory {
    public static final boolean SO_KEEPALIVE = false;
    public static final boolean OOBINLINE = false;
    public static final boolean SO_REUSEADDR = false;
    public static final boolean TCP_NODELAY = true;
    public static final int SO_RCVBUF = 8192;
    public static final int SO_SNDBUF = 1024;
    public static final int SO_TIMEOUT = 12000;
    public static final int SO_CONNECT_TIMEOUT = 5000;
    public static final boolean SO_LINGER = true;
    public static final int LINGER = 0;

    @Override
    public Socket createSocket() {
        Socket s2 = new Socket();
        return this.applySettings(s2);
    }

    protected Socket applySettings(Socket s2) {
        try {
            s2.setKeepAlive(false);
            s2.setOOBInline(false);
            s2.setReuseAddress(false);
            s2.setTcpNoDelay(true);
            s2.setOOBInline(false);
            s2.setReceiveBufferSize(8192);
            s2.setSendBufferSize(1024);
            s2.setSoTimeout(12000);
            s2.setSoLinger(true, 0);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        return s2;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket s2 = this.createSocket();
        s2.connect(new InetSocketAddress(host, port), 5000);
        return s2;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket s2 = this.createSocket();
        s2.connect(new InetSocketAddress(host, port), 5000);
        return s2;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress local, int localPort) throws IOException {
        Socket s2 = this.createSocket();
        s2.bind(new InetSocketAddress(local, localPort));
        s2.connect(new InetSocketAddress(host, port), 5000);
        return s2;
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress local, int localPort) throws IOException {
        Socket s2 = this.createSocket();
        s2.bind(new InetSocketAddress(local, localPort));
        s2.connect(new InetSocketAddress(host, port), 5000);
        return s2;
    }

    public static SocketFactory getDefault() {
        return new SocketFactoryImpl();
    }
}

