/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ThrowStatement
extends Statement {
    public final Expression expression;

    public ThrowStatement(Expression expression) {
        super(ExpressionType.Throw, Void.TYPE);
        this.expression = expression;
    }

    @Override
    public Statement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression = this.expression.accept(shuttle);
        return shuttle.visit(this, expression);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("throw ").append(this.expression).append(';').newlineAndIndent();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrowStatement that = (ThrowStatement)o;
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression});
    }
}

