/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.ArrayList;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.Service;

public abstract class AbstractService
implements Service {
    private Service.RpcMetadataResponse rpcMetadata = null;

    abstract SerializationType getSerializationType();

    Meta.Signature finagle(Meta.Signature signature2) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData column : signature2.columns) {
            columns.add(this.finagle(column));
        }
        if (columns.equals(signature2.columns)) {
            return signature2;
        }
        return new Meta.Signature(columns, signature2.sql, signature2.parameters, signature2.internalParameters, signature2.cursorFactory, signature2.statementType);
    }

    ColumnMetaData finagle(ColumnMetaData column) {
        switch (column.type.rep) {
            case BYTE: 
            case PRIMITIVE_BYTE: 
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: 
            case FLOAT: 
            case PRIMITIVE_FLOAT: 
            case INTEGER: 
            case PRIMITIVE_INT: 
            case SHORT: 
            case PRIMITIVE_SHORT: 
            case LONG: 
            case PRIMITIVE_LONG: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        switch (column.type.id) {
            case -3: 
            case -2: {
                switch (this.getSerializationType()) {
                    case JSON: {
                        return column.setRep(ColumnMetaData.Rep.STRING);
                    }
                    case PROTOBUF: {
                        return column;
                    }
                }
                throw new IllegalStateException("Unhandled case statement with serializationType: " + (Object)((Object)this.getSerializationType()));
            }
            case 2: 
            case 3: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        return column;
    }

    Service.PrepareResponse finagle(Service.PrepareResponse response) {
        Meta.StatementHandle statement = this.finagle(response.statement);
        if (statement == response.statement) {
            return response;
        }
        return new Service.PrepareResponse(statement, this.rpcMetadata);
    }

    Meta.StatementHandle finagle(Meta.StatementHandle h2) {
        Meta.Signature signature2 = this.finagle(h2.signature);
        if (signature2 == h2.signature) {
            return h2;
        }
        return new Meta.StatementHandle(h2.connectionId, h2.id, signature2);
    }

    Service.ResultSetResponse finagle(Service.ResultSetResponse r) {
        if (r.updateCount != -1L) {
            assert (r.signature == null);
            return r;
        }
        if (r.signature == null) {
            return r;
        }
        Meta.Signature signature2 = this.finagle(r.signature);
        if (signature2 == r.signature) {
            return r;
        }
        return new Service.ResultSetResponse(r.connectionId, r.statementId, r.ownStatement, signature2, r.firstFrame, r.updateCount, this.rpcMetadata);
    }

    Service.ExecuteResponse finagle(Service.ExecuteResponse r) {
        if (r.missingStatement) {
            return r;
        }
        ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
        int changeCount = 0;
        for (Service.ResultSetResponse result2 : r.results) {
            Service.ResultSetResponse result22 = this.finagle(result2);
            if (result22 != result2) {
                ++changeCount;
            }
            results.add(result22);
        }
        if (changeCount == 0) {
            return r;
        }
        return new Service.ExecuteResponse(results, r.missingStatement, this.rpcMetadata);
    }

    @Override
    public void setRpcMetadata(Service.RpcMetadataResponse metadata2) {
        this.rpcMetadata = metadata2;
    }

    static enum SerializationType {
        JSON,
        PROTOBUF;

    }
}

