/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.internal.InMemoryRetryRegistry;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface RetryRegistry
extends Registry<Retry, RetryConfig> {
    public static RetryRegistry of(RetryConfig retryConfig) {
        return new InMemoryRetryRegistry(retryConfig);
    }

    public static RetryRegistry of(RetryConfig retryConfig, RegistryEventConsumer<Retry> registryEventConsumer) {
        return new InMemoryRetryRegistry(retryConfig, registryEventConsumer);
    }

    public static RetryRegistry of(RetryConfig retryConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        return new InMemoryRetryRegistry(retryConfig, registryEventConsumers);
    }

    public static RetryRegistry ofDefaults() {
        return new InMemoryRetryRegistry();
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs) {
        return RetryRegistry.of(configs, HashMap.empty());
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryRetryRegistry(configs, tags);
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer) {
        return new InMemoryRetryRegistry(configs, registryEventConsumer);
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        return new InMemoryRetryRegistry(configs, registryEventConsumer, tags);
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        return new InMemoryRetryRegistry(configs, registryEventConsumers);
    }

    public Seq<Retry> getAllRetries();

    public Retry retry(String var1);

    public Retry retry(String var1, io.vavr.collection.Map<String, String> var2);

    public Retry retry(String var1, RetryConfig var2);

    public Retry retry(String var1, RetryConfig var2, io.vavr.collection.Map<String, String> var3);

    public Retry retry(String var1, Supplier<RetryConfig> var2);

    public Retry retry(String var1, Supplier<RetryConfig> var2, io.vavr.collection.Map<String, String> var3);

    public Retry retry(String var1, String var2);

    public Retry retry(String var1, String var2, io.vavr.collection.Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore registryStore;
        private Map<String, RetryConfig> retryConfigsMap = new java.util.HashMap<String, RetryConfig>();
        private List<RegistryEventConsumer<Retry>> registryEventConsumers = new ArrayList<RegistryEventConsumer<Retry>>();
        private io.vavr.collection.Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withRetryConfig(RetryConfig retryConfig) {
            this.retryConfigsMap.put(DEFAULT_CONFIG, retryConfig);
            return this;
        }

        public Builder addRetryConfig(String configName, RetryConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.retryConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<Retry> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(io.vavr.collection.Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public RetryRegistry build() {
            return new InMemoryRetryRegistry(this.retryConfigsMap, this.registryEventConsumers, this.tags, this.registryStore);
        }
    }
}

