/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesUpdatableSketch
extends ArrayOfDoublesSketch {
    final long seed_;

    ArrayOfDoublesUpdatableSketch(int numValues, long seed) {
        super(numValues);
        this.seed_ = seed;
    }

    public void update(long key, double[] values2) {
        this.update(new long[]{key}, values2);
    }

    public void update(double key, double[] values2) {
        this.update(Util.doubleToLongArray(key), values2);
    }

    public void update(String key, double[] values2) {
        this.update(Util.stringToByteArray(key), values2);
    }

    public void update(byte[] key, double[] values2) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values2);
    }

    public void update(int[] key, double[] values2) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values2);
    }

    public void update(long[] key, double[] values2) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, this.seed_)[0] >>> 1, values2);
    }

    public abstract int getNominalEntries();

    public abstract void trim();

    public ArrayOfDoublesCompactSketch compact() {
        return this.compact(null);
    }

    public ArrayOfDoublesCompactSketch compact(Memory dstMem) {
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this);
        }
        return new DirectArrayOfDoublesCompactSketch(this, dstMem);
    }

    long getSeed() {
        return this.seed_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.seed_);
    }

    abstract void insertOrIgnore(long var1, double[] var3);
}

