/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.MapNode;
import com.google.uzaygezen.core.NodeValue;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.Maps;
import shaded.com.google.common.primitives.Ints;

public class Pow2LengthBitSetRangeFactory<V>
implements Function<MapNode<BitVector, V>, Map<Pow2LengthBitSetRange, NodeValue<V>>> {
    private final int[] elementLengths;
    private final int[] elementLengthSums;

    private Pow2LengthBitSetRangeFactory(List<Integer> cardinality) {
        this.elementLengths = Ints.toArray(cardinality);
        this.elementLengthSums = new int[this.elementLengths.length];
        for (int i = 0; i < this.elementLengths.length; ++i) {
            this.elementLengthSums[i] = (i == 0 ? 0 : this.elementLengthSums[i - 1]) + this.elementLengths[i];
        }
    }

    public static <V> Pow2LengthBitSetRangeFactory<V> create(List<Integer> elementLengths) {
        return new Pow2LengthBitSetRangeFactory<V>(elementLengths);
    }

    @Override
    public Map<Pow2LengthBitSetRange, NodeValue<V>> apply(MapNode<BitVector, V> from) {
        MapNode inputNode;
        if (from == null) {
            return ImmutableMap.of();
        }
        ArrayDeque inputStack = new ArrayDeque();
        ArrayDeque<BitVectorWithIterationLevelAndValue> outputStack = new ArrayDeque<BitVectorWithIterationLevelAndValue>();
        inputStack.push(from);
        int n = this.elementLengthSums.length;
        int bitCount = n == 0 ? 0 : this.elementLengthSums[n - 1];
        outputStack.push(new BitVectorWithIterationLevelAndValue((BitVector)BitVectorFactories.OPTIMAL.apply(bitCount), n, from.getValue()));
        HashMap<Pow2LengthBitSetRange, NodeValue<NodeValue<Object>>> map = Maps.newHashMap();
        while ((inputNode = (MapNode)inputStack.poll()) != null) {
            BitVectorWithIterationLevelAndValue outputElement = (BitVectorWithIterationLevelAndValue)outputStack.poll();
            map.put(new Pow2LengthBitSetRange(outputElement.bitVector, outputElement.level == 0 ? 0 : this.elementLengthSums[outputElement.level - 1]), NodeValue.of(outputElement.value, inputNode.getChildren().isEmpty()));
            Preconditions.checkArgument(outputElement.level > 0 || inputNode.getChildren().isEmpty() && outputElement.level >= 0);
            for (Map.Entry entry : inputNode.getChildren().entrySet()) {
                int i;
                inputStack.push(entry.getValue());
                BitVector childBitSet = outputElement.bitVector.clone();
                BitVector key = (BitVector)entry.getKey();
                int n2 = i = key.size() == 0 ? -1 : key.nextSetBit(0);
                while (i != -1) {
                    int bitIndex = (outputElement.level == 1 ? 0 : this.elementLengthSums[outputElement.level - 2]) + i;
                    Preconditions.checkState(bitIndex < bitCount, "bitIndex is too high");
                    Preconditions.checkState(!childBitSet.get(bitIndex));
                    childBitSet.set(bitIndex);
                    i = i == key.size() - 1 ? -1 : key.nextSetBit(i + 1);
                }
                outputStack.push(new BitVectorWithIterationLevelAndValue(childBitSet, outputElement.level - 1, entry.getValue().getValue()));
            }
        }
        Preconditions.checkState(outputStack.isEmpty() & !map.isEmpty());
        return map;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private class BitVectorWithIterationLevelAndValue {
        private final BitVector bitVector;
        private final int level;
        private final V value;

        public BitVectorWithIterationLevelAndValue(BitVector bitSet, int level, V value) {
            this.bitVector = bitSet;
            this.level = level;
            this.value = value;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

