/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class MasterKey<K extends MasterKey<K>>
extends MasterKeyProvider<K> {
    public abstract String getProviderId();

    @Override
    public String getDefaultProviderId() {
        return this.getProviderId();
    }

    public abstract String getKeyId();

    public abstract DataKey<K> generateDataKey(CryptoAlgorithm var1, Map<String, String> var2);

    public abstract DataKey<K> encryptDataKey(CryptoAlgorithm var1, Map<String, String> var2, DataKey<?> var3);

    @Override
    public boolean canProvide(String provider) {
        return this.getProviderId().equals(provider);
    }

    @Override
    public K getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException("MasterKeys can only provide themselves. Requested " + MasterKey.buildName(provider, keyId) + " but only " + this.toString() + " is available");
        }
        if (!this.getKeyId().equals(keyId)) {
            throw new NoSuchMasterKeyException("MasterKeys can only provide themselves. Requested " + MasterKey.buildName(provider, keyId) + " but only " + this.toString() + " is available");
        }
        return (K)this;
    }

    public String toString() {
        return MasterKey.buildName(this.getProviderId(), this.getKeyId());
    }

    @Override
    public List<K> getMasterKeysForEncryption(MasterKeyRequest request) {
        return Collections.singletonList(this);
    }

    private static String buildName(String provider, String keyId) {
        return String.format("%s://%s", provider, keyId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MasterKey mk = (MasterKey)obj;
        return Objects.equals(this.getKeyId(), mk.getKeyId()) && Objects.equals(this.getProviderId(), mk.getProviderId()) && Objects.equals(this.getDefaultProviderId(), mk.getDefaultProviderId());
    }

    public int hashCode() {
        return Objects.hash(this.getKeyId(), this.getProviderId(), this.getDefaultProviderId());
    }
}

