/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4j2Impl
implements Log {
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;

    public Log4j2Impl(Logger log) {
        this.log = log;
    }

    public Log4j2Impl(String loggerName) {
        this.log = LogManager.getLogger((String)loggerName);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s2, Throwable e) {
        ++this.errorCount;
        this.log.error(s2, e);
    }

    @Override
    public void error(String s2) {
        ++this.errorCount;
        this.log.error(s2);
    }

    @Override
    public void debug(String s2) {
        ++this.debugCount;
        this.log.debug(s2);
    }

    @Override
    public void debug(String s2, Throwable e) {
        ++this.debugCount;
        this.log.debug(s2, e);
    }

    @Override
    public void warn(String s2) {
        this.log.warn(s2);
        ++this.warnCount;
    }

    @Override
    public void warn(String s2, Throwable e) {
        this.log.warn(s2, e);
        ++this.warnCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.info(msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabled(Level.WARN);
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    public String toString() {
        return this.log.toString();
    }
}

