/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.ibatis;

import com.alibaba.druid.support.ibatis.SpringIbatisBeanTypeAutoProxyCreatorMBean;
import com.alibaba.druid.support.ibatis.SqlMapClientWrapper;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.PatternMatchUtils;

public class SpringIbatisBeanTypeAutoProxyCreator
extends AbstractAutoProxyCreator
implements SpringIbatisBeanTypeAutoProxyCreatorMBean {
    private static final Log LOG = LogFactory.getLog(SpringIbatisBeanTypeAutoProxyCreator.class);
    private static final long serialVersionUID = -9094985530794052264L;
    private List<String> beanNames = new ArrayList<String>();
    private final List<String> proxyBeanNames = new ArrayList<String>();

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        for (String mappedName : this.beanNames) {
            if (FactoryBean.class.isAssignableFrom(beanClass)) {
                if (!mappedName.startsWith("&")) continue;
                mappedName = mappedName.substring("&".length());
            }
            if (!this.isMatch(beanName, mappedName)) continue;
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return DO_NOT_PROXY;
    }

    protected Object createProxy(Class beanClass, String beanName, Object[] specificInterceptors, TargetSource targetSource) {
        try {
            Object target = targetSource.getTarget();
            if (target instanceof SqlMapClientWrapper) {
                this.proxyBeanNames.add(beanName);
                return target;
            }
            if (target instanceof SqlMapClient) {
                this.proxyBeanNames.add(beanName);
                return new SqlMapClientWrapper((ExtendedSqlMapClient)target);
            }
            return super.createProxy(beanClass, beanName, specificInterceptors, targetSource);
        }
        catch (Throwable ex) {
            LOG.error(ex.getMessage(), ex);
            return super.createProxy(beanClass, beanName, specificInterceptors, targetSource);
        }
    }

    protected boolean isMatch(String beanName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)beanName);
    }

    public List<String> getBeanNames() {
        return this.beanNames;
    }

    @Override
    public List<String> getProxyBeanNames() {
        return this.proxyBeanNames;
    }
}

